/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.ads.zzatp;
import com.google.android.gms.internal.ads.zzatx;
import com.google.android.gms.internal.ads.zzaus;
import com.google.android.gms.internal.ads.zzfre;
import com.google.android.gms.internal.ads.zzfrg;
import com.google.android.gms.internal.ads.zzfrm;
import com.google.android.gms.internal.ads.zzfrr;
import com.google.android.gms.internal.ads.zzfrs;
import com.google.android.gms.internal.ads.zzfrt;
import com.google.android.gms.internal.ads.zzfru;
import com.google.android.gms.internal.ads.zzfrv;
import com.google.android.gms.internal.ads.zzfrw;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class zzfrx {
    private final Context zza;
    private final Executor zzb;
    private final zzfre zzc;
    private final zzfrg zzd;
    private final zzfrw zze;
    private final zzfrw zzf;
    private Task zzg;
    private Task zzh;

    public final zzaus zza() {
        zzfrw zzfrw2 = this.zze;
        return zzfrx.zzg(this.zzg, zzfrw2.zza());
    }

    public final zzaus zzb() {
        zzfrw zzfrw2 = this.zzf;
        return zzfrx.zzg(this.zzh, zzfrw2.zza());
    }

    private static zzaus zzg(@NonNull Task task, @NonNull zzaus zzaus2) {
        if (!task.isSuccessful()) {
            return zzaus2;
        }
        return (zzaus)((Object)task.getResult());
    }

    final /* synthetic */ zzaus zzc() throws Exception {
        zzatp zzatp2 = zzaus.zza();
        AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)((zzfrx)object).zza);
        Object object = info.getId();
        if (object != null && ((String)object).matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            object = UUID.fromString((String)object);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(((UUID)object).getMostSignificantBits());
            byteBuffer.putLong(((UUID)object).getLeastSignificantBits());
            object = Base64.encodeToString((byte[])byArray, (int)11);
        }
        if (object != null) {
            zzatp2.zzt((String)object);
            zzatp2.zzs(info.isLimitAdTrackingEnabled());
            zzatp2.zzu(zzatx.zzf);
        }
        return (zzaus)zzatp2.zzbn();
    }

    final /* synthetic */ zzaus zzd() throws Exception {
        zzfrx zzfrx2 = zzfrx2.zza;
        PackageInfo packageInfo = zzfrx2.getPackageManager().getPackageInfo(zzfrx2.getPackageName(), 0);
        zzfrx zzfrx3 = zzfrx2;
        return zzfrm.zza((Context)zzfrx3, zzfrx3.getPackageName(), Integer.toString(packageInfo.versionCode));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static zzfrx zze(@NonNull Context context, @NonNull Executor executor, @NonNull zzfre zzfre2, @NonNull zzfrg zzfrg2) {
        zzfrx zzfrx2 = new zzfrx(context, executor, zzfre2, zzfrg2, new zzfru(), new zzfrv());
        if (zzfrx2.zzd.zzd()) {
            zzfrx zzfrx3 = zzfrx2;
            zzfrx3.zzg = zzfrx3.zzh(new zzfrr(zzfrx3));
        } else {
            zzfrx2.zzg = Tasks.forResult((Object)((Object)zzfrx2.zze.zza()));
        }
        zzfrx zzfrx4 = zzfrx2;
        zzfrx4.zzh = zzfrx4.zzh(new zzfrs(zzfrx4));
        return zzfrx2;
    }

    private final Task zzh(@NonNull Callable object) {
        Task task = Tasks.call((Executor)this.zzb, (Callable)object);
        object = new zzfrt(this);
        return task.addOnFailureListener(this.zzb, (OnFailureListener)object);
    }

    @VisibleForTesting
    zzfrx(Context context, Executor executor, zzfre zzfre2, zzfrg zzfrg2, zzfru zzfru2, zzfrv zzfrv2) {
        this.zza = context;
        this.zzb = executor;
        this.zzc = zzfre2;
        this.zzd = zzfrg2;
        this.zze = zzfru2;
        this.zzf = zzfrv2;
    }

    final /* synthetic */ void zzf(Exception exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        this.zzc.zzc(2025, -1L, exception);
    }
}

