/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgsb;
import com.google.android.gms.internal.ads.zzgsd;
import com.google.android.gms.internal.ads.zzgse;
import com.google.android.gms.internal.ads.zzgsg;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import javax.annotation.Nullable;

public final class zzgsc {
    @Nullable
    private Integer zza = null;
    @Nullable
    private Integer zzb = null;
    private zzgsd zzc = null;
    private zzgse zzd = zzgse.zzd;

    public final zzgsc zza(zzgsd zzgsd2) {
        this.zzc = zzgsd2;
        return this;
    }

    public final zzgsc zzb(int n) throws GeneralSecurityException {
        this.zza = n;
        return this;
    }

    public final zzgsc zzc(int n) throws GeneralSecurityException {
        this.zzb = n;
        return this;
    }

    public final zzgsc zzd(zzgse zzgse2) {
        this.zzd = zzgse2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final zzgsg zze() throws GeneralSecurityException {
        Object[] objectArray;
        Object[] objectArray2 = objectArray.zza;
        if (objectArray2 == null) {
            throw new GeneralSecurityException("key size is not set");
        }
        if (objectArray.zzb == null) {
            throw new GeneralSecurityException("tag size is not set");
        }
        if (objectArray.zzc == null) {
            throw new GeneralSecurityException("hash type is not set");
        }
        if (objectArray.zzd == null) {
            throw new GeneralSecurityException("variant is not set");
        }
        if (objectArray2.intValue() < 16) {
            objectArray2 = new Object[]{objectArray.zza};
            throw new InvalidAlgorithmParameterException(String.format("Invalid key size in bytes %d; must be at least 16 bytes", objectArray2));
        }
        int n = objectArray.zzb;
        zzgsd zzgsd2 = objectArray.zzc;
        if (n < 10) {
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; must be at least 10 bytes", objectArray));
        }
        if (zzgsd2 == zzgsd.zza) {
            if (n <= 20) return new zzgsg(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 20 bytes for SHA1", objectArray));
        }
        if (zzgsd2 == zzgsd.zzb) {
            if (n <= 28) return new zzgsg(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 28 bytes for SHA224", objectArray));
        }
        if (zzgsd2 == zzgsd.zzc) {
            if (n <= 32) return new zzgsg(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 32 bytes for SHA256", objectArray));
        }
        if (zzgsd2 == zzgsd.zzd) {
            if (n <= 48) return new zzgsg(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 48 bytes for SHA384", objectArray));
        }
        if (zzgsd2 != zzgsd.zze) {
            throw new GeneralSecurityException("unknown hash type; must be SHA256, SHA384 or SHA512");
        }
        if (n <= 64) {
            return new zzgsg(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
        }
        objectArray = new Object[]{n};
        throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 64 bytes for SHA512", objectArray));
    }

    private zzgsc() {
    }

    /* synthetic */ zzgsc(zzgsb zzgsb2) {
    }
}

