/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.graphics.Point;
import android.media.MediaCodecInfo;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.internal.ads.zzan;
import com.google.android.gms.internal.ads.zzcg;
import com.google.android.gms.internal.ads.zzfk;
import com.google.android.gms.internal.ads.zzgd;
import com.google.android.gms.internal.ads.zziy;
import com.google.android.gms.internal.ads.zzt;
import com.google.android.gms.internal.ads.zztr;
import com.google.android.gms.internal.ads.zzud;
import com.google.android.gms.internal.ads.zzuj;

public final class zztp {
    public final String zza;
    public final String zzb;
    public final String zzc;
    @Nullable
    public final MediaCodecInfo.CodecCapabilities zzd;
    public final boolean zze;
    public final boolean zzf;
    public final boolean zzg;
    private final boolean zzh;

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    @RequiresApi(value=21)
    public final Point zza(int n, int n2) {
        zztp zztp2 = zztp2.zzd;
        if (zztp2 == null || (zztp2 = zztp2.getVideoCapabilities()) == null) {
            return null;
        }
        return zztp.zzi((MediaCodecInfo.VideoCapabilities)zztp2, n, n2);
    }

    @RequiresApi(value=21)
    private static Point zzi(MediaCodecInfo.VideoCapabilities videoCapabilities, int n, int n2) {
        int n3 = videoCapabilities.getWidthAlignment();
        int n4 = videoCapabilities.getHeightAlignment();
        return new Point((n + n3 + -1) / n3 * n3, (n2 + n4 + -1) / n4 * n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final zziy zzb(zzan zzan2, zzan zzan3) {
        Object object;
        block19: {
            int n;
            block18: {
                String string2;
                String string3;
                block17: {
                    n = true != zzgd.zzG(zzan2.zzn, zzan3.zzn) ? 8 : 0;
                    if (!((zztp)object).zzh) break block17;
                    if (zzan2.zzv != zzan3.zzv) {
                        n |= 0x400;
                    }
                    if (!(((zztp)object).zze || zzan2.zzs == zzan3.zzs && zzan2.zzt == zzan3.zzt)) {
                        n |= 0x200;
                    }
                    if (!(zzt.zzg(zzan2.zzz) && zzt.zzg(zzan3.zzz) || zzgd.zzG(zzan2.zzz, zzan3.zzz))) {
                        n |= 0x800;
                    }
                    String string4 = ((zztp)object).zza;
                    if (zzgd.zzd.startsWith("SM-T230") && "OMX.MARVELL.VIDEO.HW.CODA7542DECODER".equals(string4) && !zzan2.zzd(zzan3)) {
                        n |= 2;
                    }
                    if (n == 0) {
                        String string5 = ((zztp)object).zza;
                        int n2 = true != zzan2.zzd(zzan3) ? 2 : 3;
                        return new zziy(string5, zzan2, zzan3, n2, 0);
                    }
                    break block18;
                }
                if (zzan2.zzA != zzan3.zzA) {
                    n |= 0x1000;
                }
                if (zzan2.zzB != zzan3.zzB) {
                    n |= 0x2000;
                }
                if (zzan2.zzC != zzan3.zzC) {
                    n |= 0x4000;
                }
                if (n == 0 && "audio/mp4a-latm".equals(string3 = ((zztp)object).zzb)) {
                    string3 = zzuj.zza(zzan2);
                    Pair pair = zzuj.zza(zzan3);
                    if (string3 != null && pair != null) {
                        int n3 = (Integer)pair.first;
                        if ((Integer)((Pair)string3).first == 42 && n3 == 42) {
                            object = ((zztp)object).zza;
                            return new zziy((String)object, zzan2, zzan3, 3, 0);
                        }
                    }
                }
                if (!zzan2.zzd(zzan3)) {
                    n |= 0x20;
                }
                if ("audio/opus".equals(string2 = ((zztp)object).zzb)) {
                    n |= 2;
                }
                if (n == 0) break block19;
            }
            object = ((zztp)object).zza;
            return new zziy((String)object, zzan2, zzan3, 0, n);
        }
        object = ((zztp)object).zza;
        return new zziy((String)object, zzan2, zzan3, 1, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static zztp zzc(String string2, String string3, String string4, @Nullable MediaCodecInfo.CodecCapabilities codecCapabilities, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        bl4 = codecCapabilities != null ? (codecCapabilities.isFeatureSupported("adaptive-playback") ? (zzgd.zza <= 22 ? ("ODROID-XU3".equals(zzgd.zzd) || "Nexus 10".equals(zzgd.zzd) ? (!"OMX.Exynos.AVC.Decoder".equals(string2) ? !"OMX.Exynos.AVC.Decoder.secure".equals(string2) : false) : true) : true) : false) : false;
        boolean bl6 = codecCapabilities != null ? codecCapabilities.isFeatureSupported("tunneled-playback") : false;
        bl5 = !bl5 ? (codecCapabilities != null ? codecCapabilities.isFeatureSupported("secure-playback") : false) : true;
        return new zztp(string2, string3, string4, codecCapabilities, bl, bl2, bl3, bl4, bl6, bl5);
    }

    public final String toString() {
        return this.zza;
    }

    @VisibleForTesting
    zztp(String string2, String string3, String string4, @Nullable MediaCodecInfo.CodecCapabilities codecCapabilities, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        if (string2 == null) {
            throw null;
        }
        this.zza = string2;
        this.zzb = string3;
        this.zzc = string4;
        this.zzd = codecCapabilities;
        this.zzg = bl;
        this.zze = bl4;
        this.zzf = bl6;
        this.zzh = zzcg.zzh(string3);
    }

    private final void zzj(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NoSupport [");
        stringBuilder.append(string2);
        stringBuilder.append("] [");
        stringBuilder.append(((zztp)((Object)string3)).zza);
        stringBuilder.append(", ");
        stringBuilder.append(((zztp)((Object)string3)).zzb);
        stringBuilder.append("] [");
        stringBuilder.append(zzgd.zze);
        stringBuilder.append("]");
        String string3 = stringBuilder.toString();
        zzfk.zzb("MediaCodecInfo", string3);
    }

    @RequiresApi(value=21)
    private static boolean zzk(MediaCodecInfo.VideoCapabilities videoCapabilities, int n, int n2, double d) {
        Point point = zztp.zzi(videoCapabilities, n, n2);
        n = point.x;
        n2 = point.y;
        if (d == -1.0 || d < 1.0) {
            return videoCapabilities.isSizeSupported(n, n2);
        }
        return videoCapabilities.areSizeAndRateSupported(n, n2, Math.floor(d));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final boolean zzl(zzan object, boolean bl) {
        block35: {
            void var5_17;
            String string2;
            int n;
            int n2;
            block37: {
                block33: {
                    block36: {
                        Pair pair = zzuj.zza((zzan)object);
                        if (pair == null) break block35;
                        n2 = (Integer)pair.first;
                        n = (Integer)pair.second;
                        String string3 = ((zzan)object).zzn;
                        if (!"video/dolby-vision".equals(string3)) break block36;
                        String string4 = this.zzb;
                        if ("video/avc".equals(string4)) {
                            n = 8;
                            n2 = 0;
                            break block33;
                        } else {
                            String string5 = this.zzb;
                            if ("video/hevc".equals(string5)) {
                                n = 2;
                                n2 = 0;
                                break block33;
                            } else {
                                int n3 = n;
                                n = n2;
                                n2 = n3;
                            }
                        }
                        break block33;
                    }
                    int n4 = n;
                    n = n2;
                    n2 = n4;
                }
                if (this.zzh) break block37;
                if (n != 42) break block35;
                n = 42;
            }
            MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray = this.zzh();
            if (zzgd.zza <= 23 && "video/x-vnd.on2.vp9".equals(string2 = this.zzb) && codecProfileLevelArray.length == 0) {
                void var5_15;
                void var5_13;
                MediaCodecInfo.CodecCapabilities codecCapabilities = this.zzd;
                if (codecCapabilities != null) {
                    MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
                    if (videoCapabilities != null) {
                        int n5 = (Integer)videoCapabilities.getBitrateRange().getUpper();
                    } else {
                        boolean bl2 = false;
                    }
                } else {
                    boolean bl3 = false;
                }
                if (var5_13 >= 180000000) {
                    int n6 = 1024;
                } else if (var5_13 >= 120000000) {
                    int n7 = 512;
                } else if (var5_13 >= 60000000) {
                    int n8 = 256;
                } else if (var5_13 >= 30000000) {
                    int n9 = 128;
                } else if (var5_13 >= 18000000) {
                    int n10 = 64;
                } else if (var5_13 >= 12000000) {
                    int n11 = 32;
                } else if (var5_13 >= 0x6DDD00) {
                    int n12 = 16;
                } else if (var5_13 >= 3600000) {
                    int n13 = 8;
                } else if (var5_13 >= 1800000) {
                    int n14 = 4;
                } else if (var5_13 >= 800000) {
                    int n15 = 2;
                } else {
                    boolean bl4 = true;
                }
                string2 = new MediaCodecInfo.CodecProfileLevel();
                ((MediaCodecInfo.CodecProfileLevel)string2).profile = 1;
                ((MediaCodecInfo.CodecProfileLevel)string2).level = var5_15;
                MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray2 = new MediaCodecInfo.CodecProfileLevel[]{string2};
            }
            int n16 = ((void)var5_17).length;
            int n17 = 0;
            while (true) {
                String string6;
                if (n17 >= n16) {
                    object = ((zzan)object).zzk;
                    zztp zztp2 = this;
                    String string7 = zztp2.zzc;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("codec.profileLevel, ");
                    stringBuilder.append((String)object);
                    stringBuilder.append(", ");
                    stringBuilder.append(string7);
                    zztp2.zzj(stringBuilder.toString());
                    return false;
                }
                void var8_35 = var5_17[n17];
                if (var8_35.profile == n && (var8_35.level >= n2 || !bl) && (!"video/hevc".equals(string6 = this.zzb) || n != 2 || !"sailfish".equals(zzgd.zzb) && !"marlin".equals(zzgd.zzb))) break;
                ++n17;
            }
        }
        return true;
    }

    public final boolean zzd(zzan zzan2) {
        return this.zzm(zzan2) && this.zzl(zzan2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean zze(zzan zzan2) throws zzud {
        int n;
        int n2;
        block14: {
            int n3;
            block15: {
                block17: {
                    block18: {
                        block19: {
                            block20: {
                                block21: {
                                    block22: {
                                        block23: {
                                            block24: {
                                                block25: {
                                                    String string2;
                                                    String string3;
                                                    block16: {
                                                        if (!this.zzm(zzan2)) {
                                                            return false;
                                                        }
                                                        if (!this.zzl(zzan2, true)) {
                                                            return false;
                                                        }
                                                        if (this.zzh) {
                                                            if (zzan2.zzs <= 0) return true;
                                                            if (zzan2.zzt > 0) return this.zzg(zzan2.zzs, zzan2.zzt, zzan2.zzu);
                                                            return true;
                                                        }
                                                        n2 = zzan2.zzB;
                                                        if (n2 != -1) {
                                                            MediaCodecInfo.CodecCapabilities codecCapabilities = this.zzd;
                                                            if (codecCapabilities == null) {
                                                                this.zzj("sampleRate.caps");
                                                                return false;
                                                            }
                                                            MediaCodecInfo.AudioCapabilities audioCapabilities = codecCapabilities.getAudioCapabilities();
                                                            if (audioCapabilities == null) {
                                                                this.zzj("sampleRate.aCaps");
                                                                return false;
                                                            }
                                                            if (!audioCapabilities.isSampleRateSupported(n2)) {
                                                                StringBuilder stringBuilder = new StringBuilder();
                                                                stringBuilder.append("sampleRate.support, ");
                                                                stringBuilder.append(n2);
                                                                this.zzj(stringBuilder.toString());
                                                                return false;
                                                            }
                                                        }
                                                        if ((n2 = zzan2.zzA) == -1) {
                                                            return true;
                                                        }
                                                        zzan2 = this.zzd;
                                                        if (zzan2 == null) {
                                                            this.zzj("channelCount.caps");
                                                            return false;
                                                        }
                                                        if ((zzan2 = zzan2.getAudioCapabilities()) == null) {
                                                            this.zzj("channelCount.aCaps");
                                                            return false;
                                                        }
                                                        string3 = this.zza;
                                                        string2 = this.zzb;
                                                        n3 = zzan2.getMaxInputChannelCount();
                                                        if (n3 > 1) break block15;
                                                        if (zzgd.zza < 26 || n3 <= 0) break block16;
                                                        n = n3;
                                                        break block14;
                                                    }
                                                    if ("audio/mpeg".equals(string2)) break block17;
                                                    if ("audio/3gpp".equals(string2)) break block18;
                                                    if ("audio/amr-wb".equals(string2)) break block19;
                                                    if ("audio/mp4a-latm".equals(string2)) break block20;
                                                    if ("audio/vorbis".equals(string2)) break block21;
                                                    if ("audio/opus".equals(string2)) break block22;
                                                    if ("audio/raw".equals(string2)) break block23;
                                                    if ("audio/flac".equals(string2)) break block24;
                                                    if ("audio/g711-alaw".equals(string2)) break block25;
                                                    if (!"audio/g711-mlaw".equals(string2)) {
                                                        if ("audio/gsm".equals(string2)) {
                                                            n = n3;
                                                            break block14;
                                                        } else {
                                                            n = "audio/ac3".equals(string2) ? 6 : ("audio/eac3".equals(string2) ? 16 : 30);
                                                            StringBuilder stringBuilder = new StringBuilder();
                                                            stringBuilder.append("AssumedMaxChannelAdjustment: ");
                                                            stringBuilder.append(string3);
                                                            stringBuilder.append(", [");
                                                            stringBuilder.append(n3);
                                                            stringBuilder.append(" to ");
                                                            stringBuilder.append(n);
                                                            stringBuilder.append("]");
                                                            String string4 = stringBuilder.toString();
                                                            zzfk.zzf("MediaCodecInfo", string4);
                                                        }
                                                        break block14;
                                                    } else {
                                                        n = n3;
                                                    }
                                                    break block14;
                                                }
                                                n = n3;
                                                break block14;
                                            }
                                            n = n3;
                                            break block14;
                                        }
                                        n = n3;
                                        break block14;
                                    }
                                    n = n3;
                                    break block14;
                                }
                                n = n3;
                                break block14;
                            }
                            n = n3;
                            break block14;
                        }
                        n = n3;
                        break block14;
                    }
                    n = n3;
                    break block14;
                }
                n = n3;
                break block14;
            }
            n = n3;
        }
        if (n >= n2) return true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("channelCount.support, ");
        stringBuilder.append(n2);
        this.zzj(stringBuilder.toString());
        return false;
    }

    private final boolean zzm(zzan zzan2) {
        return this.zzb.equals(zzan2.zzn) || this.zzb.equals(zzuj.zzc(zzan2));
    }

    public final boolean zzf(zzan zzan2) {
        if (zztp2.zzh) {
            return zztp2.zze;
        }
        zztp zztp2 = zzuj.zza(zzan2);
        return zztp2 != null && (Integer)((Pair)zztp2).first == 42;
    }

    /*
     * Enabled aggressive block sorting
     */
    @RequiresApi(value=21)
    public final boolean zzg(int n, int n2, double d) {
        String string2;
        MediaCodecInfo.CodecCapabilities codecCapabilities = ((zztp)object).zzd;
        if (codecCapabilities == null) {
            ((zztp)object).zzj("sizeAndRate.caps");
            return false;
        }
        if ((codecCapabilities = codecCapabilities.getVideoCapabilities()) == null) {
            ((zztp)object).zzj("sizeAndRate.vCaps");
            return false;
        }
        if (zzgd.zza >= 29) {
            int n3 = zztr.zza((MediaCodecInfo.VideoCapabilities)codecCapabilities, n, n2, d);
            if (n3 == 2) {
                return true;
            }
            if (n3 == 1) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("sizeAndRate.cover, ");
                stringBuilder.append(n);
                stringBuilder.append("x");
                stringBuilder.append(n2);
                stringBuilder.append("@");
                stringBuilder.append(d);
                ((zztp)object).zzj(stringBuilder.toString());
                return false;
            }
        }
        if (zztp.zzk((MediaCodecInfo.VideoCapabilities)codecCapabilities, n, n2, d)) return true;
        if (!(n >= n2 || "OMX.MTK.VIDEO.DECODER.HEVC".equals(string2 = ((zztp)object).zza) && "mcv5a".equals(zzgd.zzb) || !zztp.zzk((MediaCodecInfo.VideoCapabilities)codecCapabilities, n2, n, d))) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("sizeAndRate.rotated, ");
            stringBuilder.append(n);
            stringBuilder.append("x");
            stringBuilder.append(n2);
            stringBuilder.append("@");
            stringBuilder.append(d);
            String string3 = stringBuilder.toString();
            String string4 = ((zztp)object).zza;
            Object object = ((zztp)object).zzb;
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("AssumedSupport [");
            stringBuilder2.append(string3);
            stringBuilder2.append("] [");
            stringBuilder2.append(string4);
            stringBuilder2.append(", ");
            stringBuilder2.append((String)object);
            stringBuilder2.append("] [");
            stringBuilder2.append(zzgd.zze);
            stringBuilder2.append("]");
            object = stringBuilder2.toString();
            zzfk.zzb("MediaCodecInfo", (String)object);
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sizeAndRate.support, ");
        stringBuilder.append(n);
        stringBuilder.append("x");
        stringBuilder.append(n2);
        stringBuilder.append("@");
        stringBuilder.append(d);
        ((zztp)object).zzj(stringBuilder.toString());
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final MediaCodecInfo.CodecProfileLevel[] zzh() {
        MediaCodecInfo.CodecCapabilities codecCapabilities = this.zzd;
        if (codecCapabilities == null) return new MediaCodecInfo.CodecProfileLevel[0];
        if (codecCapabilities.profileLevels != null) return this.zzd.profileLevels;
        return new MediaCodecInfo.CodecProfileLevel[0];
    }
}

