/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsSession;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.util.client.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.nonagon.signalgeneration.zze;
import com.google.android.gms.ads.query.QueryInfo;
import com.google.android.gms.ads.query.QueryInfoGenerationCallback;
import com.google.android.gms.internal.ads.zzbbn;
import com.google.android.gms.internal.ads.zzbbw;
import com.google.android.gms.internal.ads.zzbcu;
import com.google.android.gms.internal.ads.zzbcv;
import com.google.android.gms.internal.ads.zzbcw;
import com.google.android.gms.internal.ads.zzbdx;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbcx {
    private final ScheduledExecutorService zza;
    private final zze zzb;
    private Runnable zzc;
    private zzbcu zzd;
    private CustomTabsSession zze;
    private String zzf;
    private long zzg = 0L;
    private long zzh;
    private JSONArray zzi;
    private Context zzj;

    static /* bridge */ /* synthetic */ CustomTabsSession zza(zzbcx zzbcx2) {
        return zzbcx2.zze;
    }

    @Nullable
    public final CustomTabsSession zzb() {
        return this.zze;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final JSONObject zzc(String string2, String string3) throws JSONException {
        long l;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("paw_id", (Object)string2);
        jSONObject.put("error", (Object)string3);
        if (((Boolean)zzbdx.zza.zze()).booleanValue()) {
            string2 = zzbbw.zziX;
            l = (Long)zzba.zzc().zza((zzbbn)string2);
        } else {
            l = 0L;
        }
        jSONObject.put("sdk_ttl_ms", l);
        this.zzk(jSONObject);
        return jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final JSONObject zzd(String string2, String string3) throws JSONException {
        long l;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("paw_id", (Object)string2);
        jSONObject.put("signal", (Object)string3);
        if (((Boolean)zzbdx.zza.zze()).booleanValue()) {
            string2 = zzbbw.zziX;
            l = (Long)zzba.zzc().zza((zzbbn)string2);
        } else {
            l = 0L;
        }
        jSONObject.put("sdk_ttl_ms", l);
        this.zzk(jSONObject);
        return jSONObject;
    }

    public static /* synthetic */ void zze(zzbcx zzbcx2) {
        zzbcx2.zzj();
    }

    @VisibleForTesting
    public zzbcx(ScheduledExecutorService scheduledExecutorService, zze zze2) {
        this.zza = scheduledExecutorService;
        this.zzb = zze2;
    }

    final void zzf() {
        zzbbn zzbbn2 = zzbbw.zziS;
        this.zzg = zzu.zzB().elapsedRealtime() + (long)((Integer)zzba.zzc().zza(zzbbn2)).intValue();
        if (this.zzc == null) {
            this.zzc = new zzbcv(this);
        }
        this.zzj();
    }

    public final void zzg(@Nonnull Context context, @Nonnull CustomTabsClient customTabsClient, @Nonnull String string2, @Nullable CustomTabsCallback customTabsCallback) {
        if (context == null) {
            throw new IllegalArgumentException("App Context parameter is null");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Origin parameter is empty or null");
        }
        if (customTabsClient != null) {
            this.zzj = context;
            this.zzf = string2;
            this.zzd = new zzbcu(this, customTabsCallback);
            this.zze = customTabsClient.newSession((CustomTabsCallback)this.zzd);
            if (this.zze == null) {
                zzm.zzg((String)"CustomTabsClient failed to create new session.");
                return;
            }
        } else {
            throw new IllegalArgumentException("CustomTabsClient parameter is null");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzj() {
        block5: {
            block6: {
                zzbcu zzbcu2 = zzbcx2.zzd;
                if (zzbcu2 == null) {
                    zzm.zzg((String)"PACT callback is not present, please initialize the PawCustomTabsImpl.");
                    return;
                }
                if (zzbcu2.zza().booleanValue()) {
                    return;
                }
                if (zzbcx2.zzf == null || zzbcx2.zze == null || zzbcx2.zza == null) break block5;
                if (zzbcx2.zzg != 0L && zzu.zzB().elapsedRealtime() <= zzbcx2.zzg) break block6;
                zzbcu2 = zzbbw.zziT;
                if (!((Boolean)zzba.zzc().zza((zzbbn)zzbcu2)).booleanValue()) break block5;
            }
            zzbcx2.zze.requestPostMessageChannel(Uri.parse((String)zzbcx2.zzf));
            zzbcx zzbcx2 = zzbbw.zziU;
            zzbcx2.zza.schedule(zzbcx2.zzc, (long)((Long)zzba.zzc().zza((zzbbn)zzbcx2)), TimeUnit.MILLISECONDS);
            return;
        }
        com.google.android.gms.ads.internal.util.zze.zza("PACT max retry connection duration timed out");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzh(String string2) {
        try {
            CustomTabsSession customTabsSession = this.zze;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("gsppack", true);
            jSONObject.put("fpt", (Object)new Date(this.zzh).toString());
            this.zzk(jSONObject);
            customTabsSession.postMessage(jSONObject.toString(), null);
            zzbcw zzbcw2 = new zzbcw(this, string2);
            boolean bl = (Boolean)zzbdx.zza.zze();
            if (bl) {
                this.zzb.zzg(this.zze, zzbcw2);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("query_info_type", "requester_type_6");
            QueryInfo.generate((Context)this.zzj, (AdFormat)AdFormat.BANNER, (AdRequest)((AdRequest.Builder)new AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter.class, bundle)).build(), (QueryInfoGenerationCallback)zzbcw2);
            return;
        }
        catch (JSONException jSONException) {
            zzm.zzh((String)"Error creating JSON: ", (Throwable)jSONException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzk(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = this.zzi;
            if (jSONArray == null) {
                zzbbn zzbbn2 = zzbbw.zziW;
                Object object = zzba.zzc().zza(zzbbn2);
                this.zzi = jSONArray = new JSONArray((String)object);
            }
            jSONObject.put("eids", (Object)this.zzi);
            return;
        }
        catch (JSONException jSONException) {
            zzm.zzh((String)"Error fetching the PACT active eids JSON: ", (Throwable)jSONException);
            return;
        }
    }

    public final void zzi(long l) {
        this.zzh = l;
    }
}

