/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.internal.util.client.zzm;
import com.google.android.gms.internal.ads.zzcdx;
import com.google.android.gms.internal.ads.zzcdy;
import com.google.android.gms.internal.ads.zzdi;
import com.google.android.gms.internal.ads.zzfl;
import com.google.android.gms.internal.ads.zzfy;
import com.google.android.gms.internal.ads.zzgl;
import com.google.android.gms.internal.ads.zzgo;
import com.google.android.gms.internal.ads.zzgp;
import com.google.android.gms.internal.ads.zzgu;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class zzcdz
extends zzfl
implements zzgp {
    private static final Pattern zza = Pattern.compile("^bytes (\\d+)-(\\d+)/(\\d+)$");
    private final int zzb;
    private final int zzc;
    private final String zzd;
    private final zzgo zze;
    private zzfy zzf;
    private HttpURLConnection zzg;
    private final Queue zzh;
    private InputStream zzi;
    private boolean zzj;
    private int zzk;
    private long zzl;
    private long zzm;
    private long zzn;
    private long zzo;
    private long zzp;
    private final long zzq;
    private final long zzr;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int zza(byte[] byArray, int n, int n2) throws zzgl {
        if (n2 == 0) {
            return 0;
        }
        try {
            long l = this.zzl;
            long l2 = this.zzm;
            if (l - l2 == 0L) {
                return -1;
            }
            long l3 = this.zzn;
            l3 += l2;
            long l4 = n2;
            long l5 = this.zzr;
            long l6 = this.zzp;
            long l7 = l6 + 1L;
            if ((l3 = l3 + l4 + l5) > l7) {
                long l8 = this.zzo;
                if (l6 < l8) {
                    l3 = this.zzq;
                    l3 = l7 + l3;
                    l3 = Math.min(l8, Math.max(l3 - l5 + -1L, l7 + l4 + -1L));
                    this.zzk(l7, l3, 2);
                    this.zzp = l3;
                } else {
                    l3 = l6;
                }
            } else {
                l3 = l6;
            }
            ++l3;
            l = this.zzn;
            l3 -= l;
            l3 = Math.min(l4, l3 - this.zzm);
            n2 = (int)l3;
            int n3 = this.zzi.read(byArray, n, n2);
            if (n3 == -1) {
                throw new EOFException();
            }
            this.zzm += (long)n3;
            this.zzg(n3);
            return n3;
        }
        catch (IOException iOException) {
            throw new zzgl(iOException, this.zzf, 2000, 2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final long zzb(zzfy zzfy2) throws zzgl {
        long l;
        this.zzf = zzfy2;
        this.zzm = 0L;
        long l2 = zzfy2.zze;
        long l3 = zzfy2.zzf;
        long l4 = l3 == -1L ? this.zzq : Math.min(this.zzq, l3);
        long l5 = this.zzn = l2;
        this.zzg = this.zzk(l5, l5 + l4 + -1L, 1);
        String string2 = this.zzg.getHeaderField("Content-Range");
        if (TextUtils.isEmpty((CharSequence)string2)) throw new zzcdx(string2, zzfy2);
        Matcher matcher = zza.matcher(string2);
        if (!matcher.find()) throw new zzcdx(string2, zzfy2);
        try {
            Long.parseLong(matcher.group(1));
            l = Long.parseLong(matcher.group(2));
            l4 = Long.parseLong(matcher.group(3));
        }
        catch (NumberFormatException numberFormatException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unexpected Content-Range [");
            stringBuilder.append(string2);
            stringBuilder.append("]");
            com.google.android.gms.ads.internal.util.client.zzm.zzg((String)stringBuilder.toString());
            throw new zzcdx(string2, zzfy2);
        }
        l2 = zzfy2.zzf;
        if (l2 != -1L) {
            this.zzl = l2;
            this.zzo = Math.max(l, this.zzn + l2 + -1L);
        } else {
            this.zzl = l4 - this.zzn;
            this.zzo = l4 + -1L;
        }
        this.zzp = l;
        this.zzj = true;
        this.zzj(zzfy2);
        return this.zzl;
    }

    @Override
    @Nullable
    public final Uri zzc() {
        HttpURLConnection httpURLConnection = ((zzcdz)((Object)httpURLConnection)).zzg;
        if (httpURLConnection == null) {
            return null;
        }
        return Uri.parse((String)httpURLConnection.getURL().toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    final HttpURLConnection zzk(long l, long l2, int n) throws zzgl {
        int n2;
        Object object;
        HttpURLConnection httpURLConnection;
        Object object2 = ((zzcdz)object).zzf.zza.toString();
        try {
            boolean bl;
            httpURLConnection = (HttpURLConnection)new URL((String)object2).openConnection();
            httpURLConnection.setConnectTimeout(((zzcdz)object).zzb);
            httpURLConnection.setReadTimeout(((zzcdz)object).zzc);
            Object object3 = ((zzcdz)object).zze.zza().entrySet().iterator();
            while (bl = object3.hasNext()) {
                Map.Entry entry = object3.next();
                httpURLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("bytes=");
            stringBuilder.append(l);
            stringBuilder.append("-");
            stringBuilder.append(l2);
            object3 = stringBuilder.toString();
            httpURLConnection.setRequestProperty("Range", (String)object3);
            httpURLConnection.setRequestProperty("User-Agent", ((zzcdz)object).zzd);
            httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.connect();
            ((zzcdz)object).zzh.add(httpURLConnection);
        }
        catch (IOException iOException) {
            object2 = String.valueOf(object2);
            object = ((zzcdz)object).zzf;
            throw new zzgl("Unable to connect to ".concat((String)object2), iOException, (zzfy)object, 2000, n);
        }
        object2 = ((zzcdz)object).zzf.zza.toString();
        try {}
        catch (IOException iOException) {
            super.zzl();
            object2 = String.valueOf(object2);
            object = ((zzcdz)object).zzf;
            throw new zzgl("Unable to connect to ".concat((String)object2), iOException, (zzfy)object, 2000, n);
        }
        ((zzcdz)object).zzk = n2 = httpURLConnection.getResponseCode();
        if (n2 < 200 || n2 > 299) {
            object2 = httpURLConnection.getHeaderFields();
            super.zzl();
            throw new zzcdy(((zzcdz)object).zzk, (Map)object2, ((zzcdz)object).zzf, n);
        }
        try {
            object2 = httpURLConnection.getInputStream();
            InputStream inputStream = ((zzcdz)object).zzi;
            if (inputStream != null) {
                object2 = new SequenceInputStream(((zzcdz)object).zzi, (InputStream)object2);
            }
            ((zzcdz)object).zzi = object2;
            return httpURLConnection;
        }
        catch (IOException iOException) {
            super.zzl();
            throw new zzgl(iOException, ((zzcdz)object).zzf, 2000, n);
        }
    }

    @Override
    @Nullable
    public final Map zze() {
        HttpURLConnection httpURLConnection = ((zzcdz)((Object)httpURLConnection)).zzg;
        if (httpURLConnection == null) {
            return null;
        }
        return httpURLConnection.getHeaderFields();
    }

    zzcdz(String string2, zzgu zzgu2, int n, int n2, long l, long l2) {
        super(true);
        zzdi.zzc(string2);
        this.zzd = string2;
        this.zze = new zzgo();
        this.zzb = n;
        this.zzc = n2;
        this.zzh = new ArrayDeque();
        this.zzq = l;
        this.zzr = l2;
        if (zzgu2 != null) {
            this.zzf(zzgu2);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zzd() throws zzgl {
        var1_1 = this.zzi;
        if (var1_1 == null) ** GOTO lbl14
        var1_1.close();
        ** GOTO lbl14
        {
            catch (Throwable var1_2) {
                this.zzi = null;
                this.zzl();
                if (this.zzj) {
                    this.zzj = false;
                    this.zzh();
                }
                throw var1_2;
            }
lbl14:
            // 2 sources

            this.zzi = null;
            this.zzl();
            if (this.zzj) {
                this.zzj = false;
                this.zzh();
                return;
            }
            return;
            catch (IOException var1_3) {}
            {
                var3_5 = this.zzf;
                var2_4 = new zzgl(var1_3, var3_5, 2000, 3);
                throw var2_4;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzl() {
        while (true) {
            if (this.zzh.isEmpty()) {
                this.zzg = null;
                return;
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.zzh.remove();
            try {
                httpURLConnection.disconnect();
                continue;
            }
            catch (Exception exception) {
                com.google.android.gms.ads.internal.util.client.zzm.zzh((String)"Unexpected error while disconnecting", (Throwable)exception);
                continue;
            }
            break;
        }
    }
}

