/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgdo;
import com.google.android.gms.internal.ads.zzgdx;
import com.google.android.gms.internal.ads.zzgiq;
import com.google.android.gms.internal.ads.zzgjs;
import com.google.android.gms.internal.ads.zzgjy;
import com.google.android.gms.internal.ads.zzgkr;
import com.google.android.gms.internal.ads.zzgoa;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzgkj
implements zzgdo {
    private final byte[] zza;
    private final byte[] zzb;

    public static zzgdo zzb(zzgiq zzgiq2) throws GeneralSecurityException {
        return new zzgkj(zzgiq2.zzd().zzd(zzgdx.zza()), zzgiq2.zzc().zzc());
    }

    private zzgkj(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (!zzgkr.zza(1)) {
            throw new GeneralSecurityException("Can not use ChaCha20Poly1305 in FIPS-mode.");
        }
        if (!zzgkj.zzc()) {
            throw new GeneralSecurityException("JCE does not support algorithm: ChaCha20-Poly1305");
        }
        if (byArray.length != 32) {
            throw new InvalidKeyException("The key length in bytes must be 32.");
        }
        this.zza = byArray;
        this.zzb = byArray2;
    }

    public static boolean zzc() {
        return zzgjs.zzc() != null;
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray == null) {
            throw new NullPointerException("ciphertext is null");
        }
        int n = byArray.length;
        Object object = this.zzb;
        if (n < ((byte[])object).length + 40) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        if (!zzgoa.zzc(object, byArray)) {
            throw new GeneralSecurityException("Decryption failed (OutputPrefix mismatch).");
        }
        object = new byte[24];
        System.arraycopy(byArray, this.zzb.length, object, 0, 24);
        Object object2 = zzgjy.zzd(zzgjy.zze(this.zza), zzgjy.zze(object));
        ByteBuffer byteBuffer = ByteBuffer.allocate(((int[])object2).length * 4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asIntBuffer().put((int[])object2);
        object2 = byteBuffer.array();
        String string2 = "ChaCha20";
        SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object2, string2);
        object2 = new IvParameterSpec;
        byte[] byArray3 = new byte[12];
        System.arraycopy(object, 16, byArray3, 4, 8);
        object2(byArray3);
        object = zzgjs.zzc();
        object.init(2, (Key)secretKeySpec, (AlgorithmParameterSpec)object2);
        if (byArray2 != null && byArray2.length != 0) {
            object.updateAAD(byArray2);
        }
        int n2 = this.zzb.length;
        return object.doFinal(byArray, n2 + 24, n - n2 + -24);
    }
}

