/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgkr;
import com.google.android.gms.internal.ads.zzgpz;
import com.google.android.gms.internal.ads.zzgqi;
import com.google.android.gms.internal.ads.zzgup;
import com.google.android.gms.internal.ads.zzgvk;
import com.google.android.gms.internal.ads.zzgvp;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class zzgvl
implements zzgqi {
    private static final ThreadLocal zza = new zzgvk();
    private final SecretKey zzb;
    private final byte[] zzc;
    private final byte[] zzd;

    private static Cipher zzb() throws GeneralSecurityException {
        if (!zzgkr.zza(1)) {
            throw new GeneralSecurityException("Can not use AES-CMAC in FIPS-mode.");
        }
        return (Cipher)zza.get();
    }

    public zzgvl(byte[] byArray) throws GeneralSecurityException {
        zzgvp.zza(byArray.length);
        String string2 = "AES";
        this.zzb = new SecretKeySpec(byArray, string2);
        Cipher cipher = zzgvl.zzb();
        cipher.init(1, this.zzb);
        this.zzc = zzgpz.zza(cipher.doFinal(new byte[16]));
        this.zzd = zzgpz.zza(this.zzc);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final byte[] zza(byte[] byArray, int n) throws GeneralSecurityException {
        Object object;
        if (n > 16) {
            throw new InvalidAlgorithmParameterException("outputLength too large, max is 16 bytes");
        }
        SecretKey secretKey = ((zzgvl)object).zzb;
        Cipher cipher = zzgvl.zzb();
        cipher.init(1, secretKey);
        int n2 = byArray.length;
        int n3 = Math.max(1, (int)Math.ceil((double)n2 / 16.0));
        int n4 = n3 + -1;
        int n5 = n4 * 16;
        if (n3 * 16 == n2) {
            object = zzgup.zzd(byArray, n5, ((zzgvl)object).zzc, 0, 16);
        } else {
            byte[] byArray2 = Arrays.copyOfRange(byArray, n5, n2);
            if ((n5 = byArray2.length) >= 16) {
                throw new IllegalArgumentException("x must be smaller than a block.");
            }
            byte[] byArray3 = Arrays.copyOf(byArray2, 16);
            byArray3[n5] = -128;
            object = zzgup.zzc(byArray3, ((zzgvl)object).zzd);
        }
        byte[] byArray4 = new byte[16];
        n5 = 0;
        while (n5 < n4) {
            byArray4 = cipher.doFinal(zzgup.zzd(byArray4, 0, byArray, n5 * 16, 16));
            ++n5;
        }
        return Arrays.copyOf(cipher.doFinal(zzgup.zzc((byte[])object, byArray4)), n);
    }
}

