/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import com.google.android.gms.ads.internal.purchase.zzb;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzg;
import com.google.android.gms.ads.internal.purchase.zzh;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzfq;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zzhu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@zzgk
public class zzc
extends zzhq
implements ServiceConnection {
    private final Object zzpc = new Object();
    private boolean zzBO = false;
    private Context mContext;
    private zzfq zzBP;
    private zzb zzBQ;
    private zzh zzBR;
    private List<zzf> zzBS = null;
    private zzk zzBT;

    public zzc(Context context, zzfq zzfq2, zzk zzk2) {
        this(context, zzfq2, zzk2, new zzb(context), zzh.zzx(context.getApplicationContext()));
    }

    zzc(Context context, zzfq zzfq2, zzk zzk2, zzb zzb2, zzh zzh2) {
        this.mContext = context;
        this.zzBP = zzfq2;
        this.zzBT = zzk2;
        this.zzBQ = zzb2;
        this.zzBR = zzh2;
        this.zzBS = this.zzBR.zzf(10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzdG() {
        Object object = this.zzpc;
        synchronized (object) {
            Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
            intent.setPackage("com.android.vending");
            com.google.android.gms.common.stats.zzb.zzpD().zza(this.mContext, intent, (ServiceConnection)this, 1);
            this.zzd(SystemClock.elapsedRealtime());
            com.google.android.gms.common.stats.zzb.zzpD().zza(this.mContext, (ServiceConnection)this);
            this.zzBQ.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzpc;
        synchronized (object) {
            com.google.android.gms.common.stats.zzb.zzpD().zza(this.mContext, (ServiceConnection)this);
            this.zzBQ.destroy();
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        com.google.android.gms.ads.internal.util.client.zzb.zzaD("In-app billing service disconnected.");
        this.zzBQ.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName name, IBinder service) {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzBQ.zzM(service);
            this.zzfg();
            this.zzBO = true;
            this.zzpc.notify();
        }
    }

    protected void zzfg() {
        int n;
        Bundle bundle;
        if (this.zzBS.isEmpty()) {
            return;
        }
        HashMap<String, zzf> hashMap = new HashMap<String, zzf>();
        for (zzf object2 : this.zzBS) {
            hashMap.put(object2.zzCf, object2);
        }
        Object object3 = null;
        while ((bundle = this.zzBQ.zzj(this.mContext.getPackageName(), (String)object3)) != null && (n = zzp.zzbH().zzc(bundle)) == 0) {
            ArrayList arrayList = bundle.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList2 = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList3 = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            object3 = bundle.getString("INAPP_CONTINUATION_TOKEN");
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!hashMap.containsKey(arrayList.get(i))) continue;
                String string = (String)arrayList.get(i);
                String string2 = (String)arrayList2.get(i);
                String string3 = (String)arrayList3.get(i);
                zzf zzf2 = (zzf)hashMap.get(string);
                String string4 = zzp.zzbH().zzal(string2);
                if (!zzf2.zzCe.equals(string4)) continue;
                this.zza(zzf2, string2, string3);
                hashMap.remove(string);
            }
            if (object3 != null && !hashMap.isEmpty()) continue;
        }
        for (String string : hashMap.keySet()) {
            this.zzBR.zza((zzf)hashMap.get(string));
        }
    }

    protected void zza(final zzf zzf2, String string, String string2) {
        final Intent intent = new Intent();
        zzp.zzbH();
        intent.putExtra("RESPONSE_CODE", 0);
        zzp.zzbH();
        intent.putExtra("INAPP_PURCHASE_DATA", string);
        zzp.zzbH();
        intent.putExtra("INAPP_DATA_SIGNATURE", string2);
        zzhu.zzHK.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (zzc.this.zzBT.zza(zzf2.zzCe, -1, intent)) {
                        zzc.this.zzBP.zza(new zzg(zzc.this.mContext, zzf2.zzCf, true, -1, intent, zzf2));
                    } else {
                        zzc.this.zzBP.zza(new zzg(zzc.this.mContext, zzf2.zzCf, false, -1, intent, zzf2));
                    }
                }
                catch (RemoteException remoteException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzaE("Fail to verify and dispatch pending transaction");
                }
            }
        });
    }

    private void zzd(long l) {
        do {
            if (this.zze(l)) continue;
            com.google.android.gms.ads.internal.util.client.zzb.v("Timeout waiting for pending transaction to be processed.");
        } while (!this.zzBO);
    }

    private boolean zze(long l) {
        long l2 = 60000L - (SystemClock.elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzpc.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaE("waitWithTimeout_lock interrupted");
        }
        return true;
    }
}

