/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzdv;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzik;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzmn;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@zzgr
public class zzdy
extends zzdv {
    private static final Set<String> zzyk = Collections.synchronizedSet(new HashSet());
    private static final DecimalFormat zzyl = new DecimalFormat("#,###");
    private File zzym;
    private boolean zzyn;

    public zzdy(zziz zziz2) {
        super(zziz2);
        Context context = zziz2.getContext();
        File file = context.getCacheDir();
        if (file == null) {
            zzb.zzaH("Context.getCacheDir() returned null");
            return;
        }
        this.zzym = new File(file, "admobVideoStreams");
        if (!this.zzym.isDirectory() && !this.zzym.mkdirs()) {
            zzb.zzaH("Could not create preload cache directory at " + this.zzym.getAbsolutePath());
            this.zzym = null;
            return;
        }
        if (!this.zzym.setReadable(true, false) || !this.zzym.setExecutable(true, false)) {
            zzb.zzaH("Could not set cache file permissions at " + this.zzym.getAbsolutePath());
            this.zzym = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzab(String string2) {
        if (this.zzym == null) {
            this.zza(string2, null, "noCacheDir", null);
            return false;
        }
        while (this.zzdK() > zzby.zzuy.get()) {
            if (this.zzdL()) continue;
            zzb.zzaH("Unable to expire stream cache");
            this.zza(string2, null, "expireFailed", null);
            return false;
        }
        String string3 = this.zzac(string2);
        File file = new File(this.zzym, string3);
        File file2 = this.zza(file);
        if (file.isFile() && file2.isFile()) {
            int n = (int)file.length();
            zzb.zzaF("Stream cache hit at " + string2);
            this.zza(string2, file.getAbsolutePath(), n);
            return true;
        }
        String string4 = this.zzym.getAbsolutePath() + string2;
        Object object = zzyk;
        synchronized (object) {
            if (zzyk.contains(string4)) {
                zzb.zzaH("Stream cache already in progress at " + string2);
                this.zza(string2, file.getAbsolutePath(), "inProgress", null);
                return false;
            }
            zzyk.add(string4);
        }
        object = null;
        String string5 = "error";
        String string6 = null;
        try {
            int n;
            int n2;
            URLConnection uRLConnection = new URL(string2).openConnection();
            int n3 = zzby.zzuD.get();
            uRLConnection.setConnectTimeout(n3);
            uRLConnection.setReadTimeout(n3);
            if (uRLConnection instanceof HttpURLConnection && (n2 = ((HttpURLConnection)uRLConnection).getResponseCode()) >= 400) {
                string5 = "badUrl";
                string6 = "HTTP request failed. Code: " + Integer.toString(n2);
                throw new IOException("HTTP status code " + n2 + " at " + string2);
            }
            n2 = uRLConnection.getContentLength();
            if (n2 < 0) {
                zzb.zzaH("Stream cache aborted, missing content-length header at " + string2);
                this.zza(string2, file.getAbsolutePath(), "contentLengthMissing", null);
                zzyk.remove(string4);
                return false;
            }
            String string7 = zzyl.format(n2);
            int n4 = zzby.zzuz.get();
            if (n2 > n4) {
                zzb.zzaH("Content length " + string7 + " exceeds limit at " + string2);
                String string8 = "File too big for full file cache. Size: " + string7;
                this.zza(string2, file.getAbsolutePath(), "sizeExceeded", string8);
                zzyk.remove(string4);
                return false;
            }
            zzb.zzaF("Caching " + string7 + " bytes from " + string2);
            InputStream inputStream = uRLConnection.getInputStream();
            ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
            object = new FileOutputStream(file);
            FileChannel fileChannel = ((FileOutputStream)object).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            zzmn zzmn2 = zzp.zzbz();
            int n5 = 0;
            long l = zzmn2.currentTimeMillis();
            long l2 = zzby.zzuC.get();
            zzik zzik2 = new zzik(l2);
            long l3 = zzby.zzuB.get();
            while ((n = readableByteChannel.read(byteBuffer)) >= 0) {
                if ((n5 += n) > n4) {
                    string5 = "sizeExceeded";
                    string6 = "File too big for full file cache. Size: " + Integer.toString(n5);
                    throw new IOException("stream cache file size limit exceeded");
                }
                byteBuffer.flip();
                while (fileChannel.write(byteBuffer) > 0) {
                }
                byteBuffer.clear();
                long l4 = zzmn2.currentTimeMillis();
                if (l4 - l > l3 * 1000L) {
                    string5 = "downloadTimeout";
                    string6 = "Timeout exceeded. Limit: " + Long.toString(l3) + " sec";
                    throw new IOException("stream cache time limit exceeded");
                }
                if (this.zzyn) {
                    string5 = "externalAbort";
                    throw new IOException("abort requested");
                }
                if (!zzik2.tryAcquire()) continue;
                this.zza(string2, file.getAbsolutePath(), n5, n2, false);
            }
            ((FileOutputStream)object).close();
            if (zzb.zzN(3)) {
                String string9 = zzyl.format(n5);
                zzb.zzaF("Preloaded " + string9 + " bytes from " + string2);
            }
            file.setReadable(true, false);
            zzdy.zzb(file2);
            this.zza(string2, file.getAbsolutePath(), n5);
            zzyk.remove(string4);
            return true;
        }
        catch (IOException iOException) {
            try {
                ((FileOutputStream)object).close();
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
            if (this.zzyn) {
                zzb.zzaG("Preload aborted for URL \"" + string2 + "\"");
            } else {
                zzb.zzd("Preload failed for URL \"" + string2 + "\"", iOException);
            }
            if (file.exists() && !file.delete()) {
                zzb.zzaH("Could not delete partial cache file at " + file.getAbsolutePath());
            }
            this.zza(string2, file.getAbsolutePath(), string5, string6);
            zzyk.remove(string4);
            return false;
        }
    }

    @Override
    public void abort() {
        this.zzyn = true;
    }

    public int zzdK() {
        if (this.zzym == null) {
            return 0;
        }
        int n = 0;
        for (File file : this.zzym.listFiles()) {
            if (file.getName().endsWith(".done")) continue;
            ++n;
        }
        return n;
    }

    public boolean zzdL() {
        if (this.zzym == null) {
            return false;
        }
        File file = null;
        long l = Long.MAX_VALUE;
        for (File file2 : this.zzym.listFiles()) {
            long l2;
            if (file2.getName().endsWith(".done") || (l2 = file2.lastModified()) >= l) continue;
            file = file2;
            l = l2;
        }
        boolean bl = false;
        if (file != null) {
            bl = file.delete();
            File file3 = this.zza(file);
            if (file3.isFile()) {
                bl &= file3.delete();
            }
        }
        return bl;
    }

    private File zza(File file) {
        return new File(this.zzym, file.getName() + ".done");
    }

    private static void zzb(File file) {
        if (file.isFile()) {
            file.setLastModified(System.currentTimeMillis());
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

