/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzaz;
import com.google.android.gms.internal.zzcc;
import com.google.android.gms.internal.zzce;
import com.google.android.gms.internal.zzcf;
import com.google.android.gms.internal.zzcg;
import com.google.android.gms.internal.zzdv;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzje;
import com.google.android.gms.internal.zzmx;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzgr
class zzjd
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zziz {
    private final zza zzKm;
    private final Object zzpd = new Object();
    private final zzan zzwL;
    private final VersionInfoParcel zzpb;
    private final zzd zzow;
    private zzja zzKn;
    private com.google.android.gms.ads.internal.overlay.zzd zzKo;
    private AdSizeParcel zzzm;
    private boolean zzKp;
    private boolean zzKq;
    private boolean zzKr;
    private boolean zzKs;
    private Boolean zzHZ;
    private int zzKt;
    private boolean zzKu = true;
    private String zzBY = "";
    private zzce zzKv;
    private zzce zzKw;
    private zzce zzKx;
    private zzcf zzKy;
    private com.google.android.gms.ads.internal.overlay.zzd zzKz;
    private zzim zzqR;
    private int zzAE = -1;
    private int zzAD = -1;
    private int zzAG = -1;
    private int zzAH = -1;
    private Map<String, zzdv> zzKA;
    private final WindowManager zzri;

    static zzjd zzb(Context context, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzan zzan2, VersionInfoParcel versionInfoParcel, zzcg zzcg2, zzd zzd2) {
        zza zza2 = new zza(context);
        return new zzjd(zza2, adSizeParcel, bl, bl2, zzan2, versionInfoParcel, zzcg2, zzd2);
    }

    protected zzjd(zza zza2, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzan zzan2, VersionInfoParcel versionInfoParcel, zzcg zzcg2, zzd zzd2) {
        super((Context)zza2);
        this.zzKm = zza2;
        this.zzzm = adSizeParcel;
        this.zzKr = bl;
        this.zzKt = -1;
        this.zzwL = zzan2;
        this.zzpb = versionInfoParcel;
        this.zzow = zzd2;
        this.zzri = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(0);
        }
        zzp.zzbv().zza((Context)zza2, versionInfoParcel.zzJu, webSettings);
        zzp.zzbx().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzhz();
        if (zzmx.zzqz()) {
            this.addJavascriptInterface(new zzje(this), "googleAdsJsInterface");
        }
        this.zzqR = new zzim(this.zzKm.zzgZ(), this, null);
        this.zzd(zzcg2);
    }

    @Override
    public void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzja) {
            this.zzKn = (zzja)webViewClient;
        }
    }

    @Override
    public WebView getWebView() {
        return this;
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public zzd zzhb() {
        return this.zzow;
    }

    public boolean zzhx() {
        int n;
        int n2;
        if (!this.zzhe().zzbY()) {
            return false;
        }
        DisplayMetrics displayMetrics = zzp.zzbv().zza(this.zzri);
        int n3 = zzl.zzcF().zzb(displayMetrics, displayMetrics.widthPixels);
        int n4 = zzl.zzcF().zzb(displayMetrics, displayMetrics.heightPixels);
        Activity activity = this.zzgZ();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            int[] nArray = zzp.zzbv().zzg(activity);
            n2 = zzl.zzcF().zzb(displayMetrics, nArray[0]);
            n = zzl.zzcF().zzb(displayMetrics, nArray[1]);
        }
        if (this.zzAD == n3 && this.zzAE == n4 && this.zzAG == n2 && this.zzAH == n) {
            return false;
        }
        boolean bl = this.zzAD != n3 || this.zzAE != n4;
        this.zzAD = n3;
        this.zzAE = n4;
        this.zzAG = n2;
        this.zzAH = n;
        new zzfh(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzri.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public void zzb(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzp.zzbv().zzz(map);
        }
        catch (JSONException jSONException) {
            zzb.zzaH("Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateJavascript(String script, ValueCallback<String> resultCallback) {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzb.zzaH("The webview is destroyed. Ignoring action.");
                if (resultCallback != null) {
                    resultCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(script, resultCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzaL(String string2) {
        Object object = this.zzpd;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzb.zzaH("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUrl(String uri) {
        Object object = this.zzpd;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(uri);
                }
                catch (Throwable throwable) {
                    zzb.zzaH("Could not call loadUrl. " + throwable);
                }
            } else {
                zzb.zzaH("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaI(String string2) {
        Object object = this.zzpd;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Throwable throwable) {
                zzb.zzaH("Could not call loadUrl. " + throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(String data, String mimeType, String encoding) {
        Object object = this.zzpd;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(data, mimeType, encoding);
            } else {
                zzb.zzaH("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        Object object = this.zzpd;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
            } else {
                zzb.zzaH("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zza(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzpd;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.evaluateJavascript(string2, valueCallback);
            } else {
                zzb.zzaH("The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
            }
        }
    }

    protected void zzaM(String string2) {
        if (zzmx.zzqB()) {
            if (this.zzgs() == null) {
                this.zzhy();
            }
            if (this.zzgs().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
            } else {
                this.zzaL("javascript:" + string2);
            }
        } else {
            this.zzaL("javascript:" + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhy() {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzHZ = zzp.zzby().zzgs();
            if (this.zzHZ == null) {
                try {
                    String string2 = "(function(){})()";
                    this.evaluateJavascript(string2, null);
                    this.zzb(true);
                }
                catch (IllegalStateException illegalStateException) {
                    this.zzb(false);
                }
            }
        }
    }

    void zzb(Boolean bl) {
        this.zzHZ = bl;
        zzp.zzby().zzb(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean zzgs() {
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzHZ;
        }
    }

    @Override
    public void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zza(string2, string3);
    }

    @Override
    public void zza(String string2, String string3) {
        String string4 = string2 + "(" + string3 + ");";
        this.zzaM(string4);
    }

    @Override
    public void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        zzb.v("Dispatching AFMA event: " + stringBuilder.toString());
        this.zzaM(stringBuilder.toString());
    }

    @Override
    public void zzgY() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzpb.zzJu);
        this.zzb("onhide", hashMap);
    }

    @Override
    public void zzv(int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzpb.zzJu);
        this.zzb("onhide", hashMap);
    }

    @Override
    public void zzeJ() {
        if (this.zzKv != null) {
            zzcc.zza(this.zzKy.zzdm(), this.zzKx, "aes");
            this.zzKv = zzcc.zzb(this.zzKy.zzdm());
            this.zzKy.zza("native:view_show", this.zzKx);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzpb.zzJu);
        this.zzb("onshow", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzhc() {
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzKo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzhd() {
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzKz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdSizeParcel zzaN() {
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzzm;
        }
    }

    @Override
    public zzja zzhe() {
        return this.zzKn;
    }

    @Override
    public boolean zzhf() {
        return this.zzKp;
    }

    @Override
    public zzan zzhg() {
        return this.zzwL;
    }

    @Override
    public VersionInfoParcel zzhh() {
        return this.zzpb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzhi() {
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzKr;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            zzp.zzbv().zzb(this.getContext(), intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzb.zzaF("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.zzwL != null) {
            this.zzwL.zza(event);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzKr || this.zzzm.zzth || this.zzzm.zzti) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            if (this.zzzm.zztf) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzri.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n2 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n4 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n5 = Integer.MAX_VALUE;
            if (n == Integer.MIN_VALUE || n == 0x40000000) {
                n5 = n2;
            }
            int n6 = Integer.MAX_VALUE;
            if (n3 == Integer.MIN_VALUE || n3 == 0x40000000) {
                n6 = n4;
            }
            if (this.zzzm.widthPixels > n5 || this.zzzm.heightPixels > n6) {
                float f = this.zzKm.getResources().getDisplayMetrics().density;
                zzb.zzaH("Not enough space to show ad. Needs " + (int)((float)this.zzzm.widthPixels / f) + "x" + (int)((float)this.zzzm.heightPixels / f) + " dp, but only has " + (int)((float)n2 / f) + "x" + (int)((float)n4 / f) + " dp.");
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzzm.widthPixels, this.zzzm.heightPixels);
            }
        }
    }

    public void onGlobalLayout() {
        boolean bl = this.zzhx();
        com.google.android.gms.ads.internal.overlay.zzd zzd2 = this.zzhc();
        if (zzd2 != null && bl) {
            zzd2.zzeI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(Context context, AdSizeParcel adSizeParcel, zzcg zzcg2) {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzqR.zzgP();
            this.setContext(context);
            this.zzKo = null;
            this.zzzm = adSizeParcel;
            this.zzKr = false;
            this.zzKp = false;
            this.zzBY = "";
            this.zzKt = -1;
            zzp.zzbx().zzb(this);
            this.loadUrl("about:blank");
            this.zzKn.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
            this.zzKu = true;
            this.zzd(zzcg2);
        }
    }

    private void zzd(zzcg zzcg2) {
        this.zzhD();
        this.zzKy = new zzcf(new zzcg(true, "make_wv", this.zzzm.zzte));
        this.zzKy.zzdm().zzc(zzcg2);
        this.zzKw = zzcc.zzb(this.zzKy.zzdm());
        this.zzKy.zza("native:view_create", this.zzKw);
        this.zzKx = null;
        this.zzKv = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzKo = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzc(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzKz = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzzm = adSizeParcel;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzC(boolean bl) {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzKr = bl;
            this.zzhz();
        }
    }

    @Override
    public void zzho() {
        this.zzqR.zzgO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        Object object = this.zzpd;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzqR.onAttachedToWindow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.zzpd;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzqR.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
        }
    }

    @Override
    public void setContext(Context context) {
        this.zzKm.setBaseContext(context);
        this.zzqR.zzk(this.zzKm.zzgZ());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzD(boolean bl) {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzKo != null) {
                this.zzKo.zza(this.zzKn.zzbY(), bl);
            } else {
                this.zzKp = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation() {
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzKt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(int requestedOrientation) {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzKt = requestedOrientation;
            if (this.zzKo != null) {
                this.zzKo.setRequestedOrientation(this.zzKt);
            }
        }
    }

    @Override
    public Activity zzgZ() {
        return this.zzKm.zzgZ();
    }

    @Override
    public Context zzha() {
        return this.zzKm.zzha();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhz() {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzKr || this.zzzm.zztf) {
                if (Build.VERSION.SDK_INT < 14) {
                    zzb.zzaF("Disabling hardware acceleration on an overlay.");
                    this.zzhA();
                } else {
                    zzb.zzaF("Enabling hardware acceleration on an overlay.");
                    this.zzhB();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                zzb.zzaF("Disabling hardware acceleration on an AdView.");
                this.zzhA();
            } else {
                zzb.zzaF("Enabling hardware acceleration on an AdView.");
                this.zzhB();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhA() {
        Object object = this.zzpd;
        synchronized (object) {
            if (!this.zzKs) {
                zzp.zzbx().zzm((View)this);
            }
            this.zzKs = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhB() {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzKs) {
                zzp.zzbx().zzl((View)this);
            }
            this.zzKs = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzhD();
            this.zzqR.zzgP();
            if (this.zzKo != null) {
                this.zzKo.close();
                this.zzKo.onDestroy();
                this.zzKo = null;
            }
            this.zzKn.reset();
            if (this.zzKq) {
                return;
            }
            zzp.zzbI().zza(this);
            this.zzhC();
            this.zzKq = true;
            zzb.v("Initiating WebView self destruct sequence in 3...");
            this.zzKn.zzhs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzhj() {
        Object object = this.zzpd;
        synchronized (object) {
            zzb.v("Destroying WebView!");
            zzid.zzIE.post(new Runnable(){

                @Override
                public void run() {
                    zzjd.super.destroy();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzKq;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
    }

    @Override
    public void zzhp() {
        if (this.zzKx == null && !"about:blank".equals(this.getUrl())) {
            this.zzKx = zzcc.zzb(this.zzKy.zzdm());
            this.zzKy.zza("native:view_load", this.zzKx);
        }
    }

    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzmx.zzqu()) {
                super.onPause();
            }
        }
        catch (Exception exception) {
            zzb.zzb("Could not pause webview.", exception);
        }
    }

    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzmx.zzqu()) {
                super.onResume();
            }
        }
        catch (Exception exception) {
            zzb.zzb("Could not resume webview.", exception);
        }
    }

    @Override
    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
        }
        catch (Exception exception) {
            zzb.zzb("Could not stop loading webview.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzE(boolean bl) {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzKu = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzhk() {
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzKu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhC() {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzKA != null) {
                for (zzdv zzdv2 : this.zzKA.values()) {
                    zzdv2.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaJ(String string2) {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzBY = string2 == null ? "" : string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRequestId() {
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzBY;
        }
    }

    @Override
    public zziy zzhl() {
        return null;
    }

    @Override
    public zzce zzhm() {
        return this.zzKx;
    }

    @Override
    public zzcf zzhn() {
        return this.zzKy;
    }

    private void zzhD() {
        if (this.zzKy == null) {
            return;
        }
        zzcg zzcg2 = this.zzKy.zzdm();
        if (zzcg2 != null && zzp.zzby().zzgo() != null) {
            zzp.zzby().zzgo().zza(zzcg2);
        }
    }

    @Override
    public void zza(zzaz zzaz2, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zzb("onAdVisibilityChanged", hashMap);
    }

    @zzgr
    public static class zza
    extends MutableContextWrapper {
        private Activity zzJn;
        private Context zzqZ;
        private Context zzKC;

        public zza(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context base) {
            this.zzqZ = base.getApplicationContext();
            this.zzJn = base instanceof Activity ? (Activity)base : null;
            this.zzKC = base;
            super.setBaseContext(this.zzqZ);
        }

        public void startActivity(Intent intent) {
            if (this.zzJn != null && !zzmx.isAtLeastL()) {
                this.zzJn.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.zzqZ.startActivity(intent);
            }
        }

        public Activity zzgZ() {
            return this.zzJn;
        }

        public Object getSystemService(String service) {
            return this.zzKC.getSystemService(service);
        }

        public Context zzha() {
            return this.zzKC;
        }
    }
}

