/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzjy;
import java.util.Date;
import java.util.Set;

@zzha
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
zzjy {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    protected AdView zzaN;
    protected InterstitialAd zzaO;
    private AdLoader zzaP;

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string2;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string2 = (String)location.next();
                builder.addKeyword(string2);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            builder.addTestDevice(zzl.zzcN().zzS(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string2 = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string2);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzaN != null) {
            this.zzaN.destroy();
            this.zzaN = null;
        }
        if (this.zzaO != null) {
            this.zzaO = null;
        }
        if (this.zzaP != null) {
            this.zzaP = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzaN != null) {
            this.zzaN.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzaN != null) {
            this.zzaN.resume();
        }
    }

    public String getAdUnitId(Bundle serverParameters) {
        return serverParameters.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener bannerListener, Bundle serverParameters, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle extras) {
        this.zzaN = new AdView(context);
        this.zzaN.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzaN.setAdUnitId(this.getAdUnitId(serverParameters));
        this.zzaN.setAdListener(new zzc(this, bannerListener));
        this.zzaN.loadAd(this.zza(context, mediationAdRequest, extras, serverParameters));
    }

    @Override
    public View getBannerView() {
        return this.zzaN;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener interstitialListener, Bundle serverParameters, MediationAdRequest mediationAdRequest, Bundle extras) {
        this.zzaO = new InterstitialAd(context);
        this.zzaO.setAdUnitId(this.getAdUnitId(serverParameters));
        this.zzaO.setAdListener(new zzd(this, interstitialListener));
        this.zzaO.loadAd(this.zza(context, mediationAdRequest, extras, serverParameters));
    }

    @Override
    public void showInterstitial() {
        this.zzaO.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzS(1).zzie();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener listener, Bundle serverParameters, NativeMediationAdRequest mediationAdRequest, Bundle extras) {
        zze zze2 = new zze(this, listener);
        AdLoader.Builder builder = this.zza(context, serverParameters.getString(AD_UNIT_ID_PARAMETER)).withAdListener(zze2);
        NativeAdOptions nativeAdOptions = mediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (mediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zze2);
        }
        if (mediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zze2);
        }
        this.zzaP = builder.build();
        this.zzaP.loadAd(this.zza(context, mediationAdRequest, extras, serverParameters));
    }

    AdLoader.Builder zza(Context context, String string2) {
        return new AdLoader.Builder(context, string2);
    }

    static class zzb
    extends NativeContentAdMapper {
        private final NativeContentAd zzaR;

        public zzb(NativeContentAd nativeContentAd) {
            this.zzaR = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            this.setLogo(nativeContentAd.getLogo());
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
        }

        @Override
        public void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzaR);
            }
        }
    }

    static class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzaQ;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zzaQ = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            this.setStarRating(nativeAppInstallAd.getStarRating());
            this.setStore(nativeAppInstallAd.getStore().toString());
            this.setPrice(nativeAppInstallAd.getPrice().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
        }

        @Override
        public void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzaQ);
            }
        }
    }

    static final class zze
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzaS;
        final MediationNativeListener zzaV;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzaS = abstractAdViewAdapter;
            this.zzaV = mediationNativeListener;
        }

        @Override
        public void onAdLoaded() {
        }

        @Override
        public void onAdFailedToLoad(int errorCode) {
            this.zzaV.onAdFailedToLoad(this.zzaS, errorCode);
        }

        @Override
        public void onAdOpened() {
            this.zzaV.onAdOpened(this.zzaS);
        }

        @Override
        public void onAdClosed() {
            this.zzaV.onAdClosed(this.zzaS);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzaV.onAdLeftApplication(this.zzaS);
        }

        @Override
        public void onAdClicked() {
            this.zzaV.onAdClicked(this.zzaS);
        }

        @Override
        public void onAppInstallAdLoaded(NativeAppInstallAd ad) {
            this.zzaV.onAdLoaded(this.zzaS, new zza(ad));
        }

        @Override
        public void onContentAdLoaded(NativeContentAd ad) {
            this.zzaV.onAdLoaded(this.zzaS, new zzb(ad));
        }
    }

    static final class zzd
    extends AdListener
    implements com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzaS;
        final MediationInterstitialListener zzaU;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzaS = abstractAdViewAdapter;
            this.zzaU = mediationInterstitialListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzaU.onAdLoaded(this.zzaS);
        }

        @Override
        public void onAdFailedToLoad(int errorCode) {
            this.zzaU.onAdFailedToLoad(this.zzaS, errorCode);
        }

        @Override
        public void onAdOpened() {
            this.zzaU.onAdOpened(this.zzaS);
        }

        @Override
        public void onAdClosed() {
            this.zzaU.onAdClosed(this.zzaS);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzaU.onAdLeftApplication(this.zzaS);
        }

        @Override
        public void onAdClicked() {
            this.zzaU.onAdClicked(this.zzaS);
        }
    }

    static final class zzc
    extends AdListener
    implements com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzaS;
        final MediationBannerListener zzaT;

        public zzc(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzaS = abstractAdViewAdapter;
            this.zzaT = mediationBannerListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzaT.onAdLoaded(this.zzaS);
        }

        @Override
        public void onAdFailedToLoad(int errorCode) {
            this.zzaT.onAdFailedToLoad(this.zzaS, errorCode);
        }

        @Override
        public void onAdOpened() {
            this.zzaT.onAdOpened(this.zzaS);
        }

        @Override
        public void onAdClosed() {
            this.zzaT.onAdClosed(this.zzaS);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzaT.onAdLeftApplication(this.zzaS);
        }

        @Override
        public void onAdClicked() {
            this.zzaT.onAdClicked(this.zzaS);
        }
    }
}

