/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.internal.client.zzz;

public final class PublisherAdView
extends ViewGroup {
    private final zzz zzoy;

    public PublisherAdView(Context context) {
        super(context);
        this.zzoy = new zzz(this);
    }

    public PublisherAdView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.zzoy = new zzz(this, attrs, true);
    }

    public PublisherAdView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.zzoy = new zzz(this, attrs, true);
    }

    public void destroy() {
        this.zzoy.destroy();
    }

    public AdListener getAdListener() {
        return this.zzoy.getAdListener();
    }

    public AdSize getAdSize() {
        return this.zzoy.getAdSize();
    }

    public AdSize[] getAdSizes() {
        return this.zzoy.getAdSizes();
    }

    public String getAdUnitId() {
        return this.zzoy.getAdUnitId();
    }

    public AppEventListener getAppEventListener() {
        return this.zzoy.getAppEventListener();
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzoy.getOnCustomRenderedAdLoadedListener();
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zzoy.zza(publisherAdRequest.zzaG());
    }

    public void pause() {
        this.zzoy.pause();
    }

    public void setManualImpressionsEnabled(boolean manualImpressionsEnabled) {
        this.zzoy.setManualImpressionsEnabled(manualImpressionsEnabled);
    }

    public void recordManualImpression() {
        this.zzoy.recordManualImpression();
    }

    public void resume() {
        this.zzoy.resume();
    }

    public void setAdListener(AdListener adListener) {
        this.zzoy.setAdListener(adListener);
    }

    public void setAdSizes(AdSize ... adSizes) {
        if (adSizes == null || adSizes.length < 1) {
            throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
        }
        this.zzoy.zza(adSizes);
    }

    public void setAdUnitId(String adUnitId) {
        this.zzoy.setAdUnitId(adUnitId);
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        this.zzoy.setAppEventListener(appEventListener);
    }

    public void setCorrelator(Correlator correlator) {
        this.zzoy.setCorrelator(correlator);
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzoy.setOnCustomRenderedAdLoadedListener(onCustomRenderedAdLoadedListener);
    }

    public String getMediationAdapterClassName() {
        return this.zzoy.getMediationAdapterClassName();
    }

    public boolean isLoading() {
        return this.zzoy.isLoading();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n = view.getMeasuredWidth();
            int n2 = view.getMeasuredHeight();
            int n3 = (right - left - n) / 2;
            int n4 = (bottom - top - n2) / 2;
            view.layout(n3, n4, n3 + n, n4 + n2);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n = 0;
        int n2 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
            n = view.getMeasuredWidth();
            n2 = view.getMeasuredHeight();
        } else {
            AdSize adSize = this.getAdSize();
            if (adSize != null) {
                Context context = this.getContext();
                n = adSize.getWidthInPixels(context);
                n2 = adSize.getHeightInPixels(context);
            }
        }
        n = Math.max(n, this.getSuggestedMinimumWidth());
        n2 = Math.max(n2, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n, (int)widthMeasureSpec), View.resolveSize((int)n2, (int)heightMeasureSpec));
    }
}

