/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzb;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzh;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.client.zzs;
import com.google.android.gms.ads.internal.client.zzy;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.internal.zzcm;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzha;

@zzha
public class zzaa {
    private final zzev zzuu = new zzev();
    private final Context mContext;
    private final zzh zzoq;
    private AdListener zzto;
    private zza zztn;
    private zzs zzuw;
    private String zzpH;
    private String zzux;
    private AppEventListener zzub;
    private PlayStorePurchaseListener zzuA;
    private InAppPurchaseListener zzuz;
    private PublisherInterstitialAd zzuE;
    private OnCustomRenderedAdLoadedListener zzuB;
    private Correlator zzuC;

    public zzaa(Context context) {
        this(context, zzh.zzcJ(), null);
    }

    public zzaa(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zzh.zzcJ(), publisherInterstitialAd);
    }

    public zzaa(Context context, zzh zzh2, PublisherInterstitialAd publisherInterstitialAd) {
        this.mContext = context;
        this.zzoq = zzh2;
        this.zzuE = publisherInterstitialAd;
    }

    public AdListener getAdListener() {
        return this.zzto;
    }

    public String getAdUnitId() {
        return this.zzpH;
    }

    public AppEventListener getAppEventListener() {
        return this.zzub;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzuz;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzuB;
    }

    public boolean isLoaded() {
        try {
            if (this.zzuw == null) {
                return false;
            }
            return this.zzuw.isReady();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to check if ad is ready.", remoteException);
            return false;
        }
    }

    public boolean isLoading() {
        try {
            if (this.zzuw == null) {
                return false;
            }
            return this.zzuw.isLoading();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public void zza(zzy zzy2) {
        try {
            if (this.zzuw == null) {
                this.zzM("loadAd");
            }
            if (this.zzuw.zzb(this.zzoq.zza(this.mContext, zzy2))) {
                this.zzuu.zze(zzy2.zzcV());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to load ad.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.zzto = adListener;
            if (this.zzuw != null) {
                this.zzuw.zza(adListener != null ? new zzc(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(zza zza2) {
        try {
            this.zztn = zza2;
            if (this.zzuw != null) {
                this.zzuw.zza(zza2 != null ? new zzb(zza2) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdUnitId(String adUnitId) {
        if (this.zzpH != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zzpH = adUnitId;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzub = appEventListener;
            if (this.zzuw != null) {
                this.zzuw.zza(appEventListener != null ? new zzj(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzuA != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzuz = inAppPurchaseListener;
            if (this.zzuw != null) {
                this.zzuw.zza(inAppPurchaseListener != null ? new zzgh(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzuB = onCustomRenderedAdLoadedListener;
            if (this.zzuw != null) {
                this.zzuw.zza(onCustomRenderedAdLoadedListener != null ? new zzcm(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the OnCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        if (this.zzuz != null) {
            throw new IllegalStateException("In app purchase parameter has already been set.");
        }
        try {
            this.zzuA = playStorePurchaseListener;
            this.zzux = publicKey;
            if (this.zzuw != null) {
                this.zzuw.zza(playStorePurchaseListener != null ? new zzgl(playStorePurchaseListener) : null, publicKey);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public void setCorrelator(Correlator correlator) {
        this.zzuC = correlator;
        try {
            if (this.zzuw != null) {
                this.zzuw.zza(this.zzuC == null ? null : this.zzuC.zzaH());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set correlator.", remoteException);
        }
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzuw != null) {
                return this.zzuw.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public void show() {
        try {
            this.zzN("show");
            this.zzuw.showInterstitial();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to show interstitial.", remoteException);
        }
    }

    private void zzM(String string2) throws RemoteException {
        if (this.zzpH == null) {
            this.zzN(string2);
        }
        this.zzuw = zzl.zzcO().zzb(this.mContext, new AdSizeParcel(), this.zzpH, this.zzuu);
        if (this.zzto != null) {
            this.zzuw.zza(new zzc(this.zzto));
        }
        if (this.zztn != null) {
            this.zzuw.zza(new zzb(this.zztn));
        }
        if (this.zzub != null) {
            this.zzuw.zza(new zzj(this.zzub));
        }
        if (this.zzuz != null) {
            this.zzuw.zza(new zzgh(this.zzuz));
        }
        if (this.zzuA != null) {
            this.zzuw.zza(new zzgl(this.zzuA), this.zzux);
        }
        if (this.zzuB != null) {
            this.zzuw.zza(new zzcm(this.zzuB));
        }
        if (this.zzuC != null) {
            this.zzuw.zza(this.zzuC.zzaH());
        }
    }

    private void zzN(String string2) {
        if (this.zzuw == null) {
            throw new IllegalStateException("The ad unit ID must be set on InterstitialAd before " + string2 + " is called.");
        }
    }
}

