/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzfu;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjo;
import java.util.Collections;

@zzha
public class zzd
extends zzfu.zza
implements zzo {
    static final int zzDg = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzDh;
    zzjn zzps;
    zzc zzDi;
    zzm zzDj;
    boolean zzDk = false;
    FrameLayout zzDl;
    WebChromeClient.CustomViewCallback zzDm;
    boolean zzDn = false;
    boolean zzDo = false;
    RelativeLayout zzCm;
    boolean zzDp = false;
    int zzDq = 0;
    private boolean zzDr;
    private boolean zzDs = false;
    private boolean zzDt = true;

    public zzd(Activity activity) {
        this.mActivity = activity;
    }

    public void close() {
        this.zzDq = 2;
        this.mActivity.finish();
    }

    public void zzfa() {
        if (this.zzDh != null && this.zzDk) {
            this.setRequestedOrientation(this.zzDh.orientation);
        }
        if (this.zzDl != null) {
            this.mActivity.setContentView((View)this.zzCm);
            this.zzaF();
            this.zzDl.removeAllViews();
            this.zzDl = null;
        }
        if (this.zzDm != null) {
            this.zzDm.onCustomViewHidden();
            this.zzDm = null;
        }
        this.zzDk = false;
    }

    @Override
    public void zzfb() {
        this.zzDq = 1;
        this.mActivity.finish();
    }

    @Override
    public void onBackPressed() {
        this.zzDq = 0;
    }

    @Override
    public boolean zzfc() {
        this.zzDq = 0;
        if (this.zzps == null) {
            return true;
        }
        boolean bl = this.zzps.zzhI();
        if (!bl) {
            this.zzps.zzb("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.zzDn = savedInstanceState != null ? savedInstanceState.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzDh = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzDh == null) {
                throw new zza("Could not get info for ad overlay.");
            }
            if (this.zzDh.zzqR.zzLG > 7500000) {
                this.zzDq = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzDt = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzDo = this.zzDh.zzDL != null ? this.zzDh.zzDL.zzqa : false;
            if (zzbz.zzwI.get().booleanValue() && this.zzDo && this.zzDh.zzDL.zzqc != null) {
                new zzd().zzgX();
            }
            if (savedInstanceState == null) {
                if (this.zzDh.zzDB != null && this.zzDt) {
                    this.zzDh.zzDB.zzaY();
                }
                if (this.zzDh.zzDI != 1 && this.zzDh.zzDA != null) {
                    this.zzDh.zzDA.onAdClicked();
                }
            }
            this.zzCm = new zzb((Context)this.mActivity, this.zzDh.zzDK);
            switch (this.zzDh.zzDI) {
                case 1: {
                    this.zzx(false);
                    break;
                }
                case 2: {
                    this.zzDi = new zzc(this.zzDh.zzDC);
                    this.zzx(false);
                    break;
                }
                case 3: {
                    this.zzx(true);
                    break;
                }
                case 4: {
                    if (this.zzDn) {
                        this.zzDq = 3;
                        this.mActivity.finish();
                        break;
                    }
                    if (!zzp.zzbu().zza((Context)this.mActivity, this.zzDh.zzDz, this.zzDh.zzDH)) {
                        this.zzDq = 3;
                        this.mActivity.finish();
                    }
                    break;
                }
                default: {
                    throw new zza("Could not determine ad overlay type.");
                }
            }
        }
        catch (zza zza2) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH(zza2.getMessage());
            this.zzDq = 3;
            this.mActivity.finish();
        }
    }

    @Override
    public void onRestart() {
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onResume() {
        if (this.zzDh != null && this.zzDh.zzDI == 4) {
            if (this.zzDn) {
                this.zzDq = 3;
                this.mActivity.finish();
            } else {
                this.zzDn = true;
            }
        }
        if (this.zzps != null && !this.zzps.isDestroyed()) {
            zzp.zzbz().zzg(this.zzps);
        } else {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("The webview does not exit. Ignoring action.");
        }
    }

    @Override
    public void onPause() {
        this.zzfa();
        if (!(this.zzps == null || this.mActivity.isFinishing() && this.zzDi != null)) {
            zzp.zzbz().zzf(this.zzps);
        }
        this.zzfe();
    }

    @Override
    public void onSaveInstanceState(Bundle outBundle) {
        outBundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzDn);
    }

    @Override
    public void onStop() {
        this.zzfe();
    }

    @Override
    public void onDestroy() {
        if (this.zzps != null) {
            this.zzCm.removeView(this.zzps.getView());
        }
        this.zzfe();
    }

    public void zzw(boolean bl) {
        int n = bl ? 50 : 32;
        this.zzDj = new zzm((Context)this.mActivity, n, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zzDj.zza(bl, this.zzDh.zzDF);
        this.zzCm.addView((View)this.zzDj, (ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public void zzaF() {
        this.zzDr = true;
    }

    public void zza(boolean bl, boolean bl2) {
        if (this.zzDj != null) {
            this.zzDj.zza(bl, bl2);
        }
    }

    public void zzfd() {
        this.zzCm.removeView((View)this.zzDj);
        this.zzw(true);
    }

    public void setRequestedOrientation(int requestedOrientation) {
        this.mActivity.setRequestedOrientation(requestedOrientation);
    }

    public void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzDl = new FrameLayout((Context)this.mActivity);
        this.zzDl.setBackgroundColor(-16777216);
        this.zzDl.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzDl);
        this.zzaF();
        this.zzDm = customViewCallback;
        this.zzDk = true;
    }

    protected void zzx(boolean bl) throws zza {
        Window window;
        if (!this.zzDr) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zza("Invalid activity, no window available.");
        }
        if (!this.zzDo || this.zzDh.zzDL != null && this.zzDh.zzDL.zzqb) {
            window.setFlags(1024, 1024);
        }
        boolean bl2 = this.zzDh.zzDC.zzhC().zzcb();
        this.zzDp = false;
        if (bl2) {
            if (this.zzDh.orientation == zzp.zzbz().zzhd()) {
                this.zzDp = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzDh.orientation == zzp.zzbz().zzhe()) {
                this.zzDp = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        com.google.android.gms.ads.internal.util.client.zzb.zzaF("Delay onShow to next orientation change: " + this.zzDp);
        this.setRequestedOrientation(this.zzDh.orientation);
        if (zzp.zzbz().zza(window)) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaF("Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzDo) {
            this.zzCm.setBackgroundColor(-16777216);
        } else {
            this.zzCm.setBackgroundColor(zzDg);
        }
        this.mActivity.setContentView((View)this.zzCm);
        this.zzaF();
        if (bl) {
            this.zzps = zzp.zzby().zza((Context)this.mActivity, this.zzDh.zzDC.zzaP(), true, bl2, null, this.zzDh.zzqR);
            this.zzps.zzhC().zzb(null, null, this.zzDh.zzDD, this.zzDh.zzDH, true, this.zzDh.zzDJ, null, this.zzDh.zzDC.zzhC().zzhO(), null);
            this.zzps.zzhC().zza(new zzjo.zza(){

                @Override
                public void zza(zzjn zzjn2, boolean bl) {
                    zzjn2.zzfg();
                }
            });
            if (this.zzDh.url != null) {
                this.zzps.loadUrl(this.zzDh.url);
            } else if (this.zzDh.zzDG != null) {
                this.zzps.loadDataWithBaseURL(this.zzDh.zzDE, this.zzDh.zzDG, "text/html", "UTF-8", null);
            } else {
                throw new zza("No URL or HTML to display in ad overlay.");
            }
            if (this.zzDh.zzDC != null) {
                this.zzDh.zzDC.zzc(this);
            }
        } else {
            this.zzps = this.zzDh.zzDC;
            this.zzps.setContext((Context)this.mActivity);
        }
        this.zzps.zzb(this);
        ViewParent viewParent = this.zzps.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzps.getView());
        }
        if (this.zzDo) {
            this.zzps.setBackgroundColor(zzDg);
        }
        this.zzCm.addView(this.zzps.getView(), -1, -1);
        if (!bl && !this.zzDp) {
            this.zzfg();
        }
        this.zzw(bl2);
        if (this.zzps.zzhD()) {
            this.zza(bl2, true);
        }
    }

    protected void zzfe() {
        if (!this.mActivity.isFinishing() || this.zzDs) {
            return;
        }
        this.zzDs = true;
        if (this.zzps != null) {
            this.zzy(this.zzDq);
            this.zzCm.removeView(this.zzps.getView());
            if (this.zzDi != null) {
                this.zzps.setContext(this.zzDi.context);
                this.zzps.zzD(false);
                this.zzDi.zzDw.addView(this.zzps.getView(), this.zzDi.index, this.zzDi.zzDv);
                this.zzDi = null;
            }
            this.zzps = null;
        }
        if (this.zzDh != null && this.zzDh.zzDB != null) {
            this.zzDh.zzDB.zzaX();
        }
    }

    public void zzff() {
        if (this.zzDp) {
            this.zzDp = false;
            this.zzfg();
        }
    }

    protected void zzfg() {
        this.zzps.zzfg();
    }

    protected void zzy(int n) {
        this.zzps.zzy(n);
    }

    @zzha
    private class zzd
    extends zzil {
        private zzd() {
        }

        @Override
        public void zzbp() {
            Bitmap bitmap = zzp.zzbx().zze((Context)zzd.this.mActivity, zzd.this.zzDh.zzDL.zzqc);
            if (bitmap != null) {
                final Drawable drawable = zzp.zzbz().zza((Context)zzd.this.mActivity, bitmap, zzd.this.zzDh.zzDL.zzqd, zzd.this.zzDh.zzDL.zzqe);
                zzip.zzKO.post(new Runnable(){

                    @Override
                    public void run() {
                        zzd.this.mActivity.getWindow().setBackgroundDrawable(drawable);
                    }
                });
            }
        }

        @Override
        public void onStop() {
        }
    }

    @zzha
    static final class zzb
    extends RelativeLayout {
        zzis zzry;

        public zzb(Context context, String string2) {
            super(context);
            this.zzry = new zzis(context, string2);
        }

        public boolean onInterceptTouchEvent(MotionEvent event) {
            this.zzry.zze(event);
            return false;
        }
    }

    @zzha
    public static class zzc {
        public final int index;
        public final ViewGroup.LayoutParams zzDv;
        public final ViewGroup zzDw;
        public final Context context;

        public zzc(zzjn zzjn2) throws zza {
            this.zzDv = zzjn2.getLayoutParams();
            ViewParent viewParent = zzjn2.getParent();
            this.context = zzjn2.zzhy();
            if (viewParent == null || !(viewParent instanceof ViewGroup)) {
                throw new zza("Could not get the parent of the WebView for an overlay.");
            }
            this.zzDw = (ViewGroup)viewParent;
            this.index = this.zzDw.indexOfChild(zzjn2.getView());
            this.zzDw.removeView(zzjn2.getView());
            zzjn2.zzD(true);
        }
    }

    @zzha
    private static final class zza
    extends Exception {
        public zza(String string2) {
            super(string2);
        }
    }
}

