/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzq;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.internal.zzcf;
import com.google.android.gms.internal.zzch;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzjn;
import java.util.HashMap;

@zzha
public class zzk
extends FrameLayout
implements zzh {
    private final zzjn zzps;
    private final FrameLayout zzDM;
    private final zzq zzDN;
    private zzi zzDO;
    private boolean zzDP;
    private boolean zzDQ;
    private TextView zzDR;
    private long zzDS;
    private long zzDT;
    private String zzDU;
    private String zzzk;

    public static void zzd(zzjn zzjn2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzjn2.zzb("onVideoEvent", hashMap);
    }

    public zzk(Context context, zzjn zzjn2, int n, zzch zzch2, zzcf zzcf2) {
        super(context);
        this.zzps = zzjn2;
        this.zzDM = new FrameLayout(context);
        this.addView((View)this.zzDM, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzb.zzu((Object)zzjn2.zzhz());
        this.zzDO = zzjn2.zzhz().zzpn.zza(context, zzjn2, n, zzch2, zzcf2);
        if (this.zzDO != null) {
            this.zzDM.addView((View)this.zzDO, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        }
        this.zzDR = new TextView(context);
        this.zzDR.setBackgroundColor(-16777216);
        this.zzfv();
        this.zzDN = new zzq(this);
        this.zzDN.zzfD();
        if (this.zzDO != null) {
            this.zzDO.zza(this);
        }
        if (this.zzDO == null) {
            this.zzg("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3 + 2, n4 + 2);
        layoutParams.setMargins(n - 1, n2 - 1, 0, 0);
        this.zzDM.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public void setMimeType(String mimeType) {
        this.zzDU = mimeType;
    }

    public void zzao(String string2) {
        this.zzzk = string2;
    }

    public void zzfs() {
        if (this.zzDO == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzzk)) {
            this.zzDO.setMimeType(this.zzDU);
            this.zzDO.setVideoPath(this.zzzk);
        } else {
            this.zza("no_src", new String[0]);
        }
    }

    public void pause() {
        if (this.zzDO == null) {
            return;
        }
        this.zzDO.pause();
    }

    public void play() {
        if (this.zzDO == null) {
            return;
        }
        this.zzDO.play();
    }

    public void seekTo(int millis) {
        if (this.zzDO == null) {
            return;
        }
        this.zzDO.seekTo(millis);
    }

    public void zzeU() {
        if (this.zzDO == null) {
            return;
        }
        this.zzDO.zzeU();
    }

    public void zzeV() {
        if (this.zzDO == null) {
            return;
        }
        this.zzDO.zzeV();
    }

    public void zza(float f) {
        if (this.zzDO == null) {
            return;
        }
        this.zzDO.zza(f);
    }

    public void zzd(MotionEvent motionEvent) {
        if (this.zzDO == null) {
            return;
        }
        this.zzDO.dispatchTouchEvent(motionEvent);
    }

    public void zzft() {
        if (this.zzDO == null) {
            return;
        }
        Context context = this.zzDO.getContext();
        TextView textView = new TextView(context);
        textView.setText((CharSequence)("AdMob - " + this.zzDO.zzeO()));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzDM.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzDM.bringChildToFront((View)textView);
    }

    @Override
    public void zzfn() {
    }

    @Override
    public void zzfo() {
        if (this.zzDO == null) {
            return;
        }
        if (this.zzDT == 0L) {
            float f = (float)this.zzDO.getDuration() / 1000.0f;
            int n = this.zzDO.getVideoWidth();
            int n2 = this.zzDO.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public void zzfp() {
        this.zzfy();
    }

    @Override
    public void onPaused() {
        this.zza("pause", new String[0]);
        this.zzfz();
    }

    @Override
    public void zzfq() {
        this.zza("ended", new String[0]);
        this.zzfz();
    }

    @Override
    public void zzg(String string2, String string3) {
        this.zza("error", "what", string2, "extra", string3);
    }

    @Override
    public void zzfr() {
        this.zzfv();
        this.zzDT = this.zzDS;
    }

    public void destroy() {
        this.zzDN.cancel();
        if (this.zzDO != null) {
            this.zzDO.stop();
        }
        this.zzfz();
    }

    void zzfu() {
        if (this.zzDO == null) {
            return;
        }
        long l = this.zzDO.getCurrentPosition();
        if (this.zzDS != l && l > 0L) {
            this.zzfw();
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzDS = l;
        }
    }

    private void zzfv() {
        if (!this.zzfx()) {
            this.zzDM.addView((View)this.zzDR, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.zzDM.bringChildToFront((View)this.zzDR);
        }
    }

    private void zzfw() {
        if (this.zzfx()) {
            this.zzDM.removeView((View)this.zzDR);
        }
    }

    private boolean zzfx() {
        return this.zzDR.getParent() != null;
    }

    private void zza(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string2);
        String string3 = null;
        for (String string4 : stringArray) {
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            hashMap.put(string3, string4);
            string3 = null;
        }
        this.zzps.zzb("onVideoEvent", hashMap);
    }

    private void zzfy() {
        if (this.zzps.zzhx() == null) {
            return;
        }
        if (this.zzDP) {
            return;
        }
        WindowManager.LayoutParams layoutParams = this.zzps.zzhx().getWindow().getAttributes();
        boolean bl = this.zzDQ = (layoutParams.flags & 0x80) != 0;
        if (!this.zzDQ) {
            this.zzps.zzhx().getWindow().addFlags(128);
            this.zzDP = true;
        }
    }

    private void zzfz() {
        if (this.zzps.zzhx() == null) {
            return;
        }
        if (this.zzDP && !this.zzDQ) {
            this.zzps.zzhx().getWindow().clearFlags(128);
            this.zzDP = false;
        }
    }
}

