/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzaj;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzao;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzdj;
import com.google.android.gms.internal.zzdl;
import com.google.android.gms.internal.zzdt;
import com.google.android.gms.internal.zzdx;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zziw;
import com.google.android.gms.internal.zzjn;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzha
public final class zzdk {
    public static final zzdl zzyz = new zzdl(){

        @Override
        public void zza(zzjn zzjn2, Map<String, String> map) {
        }
    };
    public static final zzdl zzyA = new zzdl(){

        @Override
        public void zza(zzjn zzjn2, Map<String, String> map) {
            String string2 = map.get("urls");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                zzb.zzaH("URLs missing in canOpenURLs GMSG.");
                return;
            }
            String[] stringArray = string2.split(",");
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            PackageManager packageManager = zzjn2.getContext().getPackageManager();
            for (String string3 : stringArray) {
                String[] stringArray2 = string3.split(";", 2);
                String string4 = stringArray2[0].trim();
                String string5 = stringArray2.length > 1 ? stringArray2[1].trim() : "android.intent.action.VIEW";
                Uri uri = Uri.parse((String)string4);
                Intent intent = new Intent(string5, uri);
                ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
                hashMap.put(string3, resolveInfo != null);
            }
            zzjn2.zzb("openableURLs", hashMap);
        }
    };
    public static final zzdl zzyB = new zzdl(){

        @Override
        public void zza(zzjn zzjn2, Map<String, String> map) {
            JSONArray jSONArray;
            JSONObject jSONObject;
            PackageManager packageManager = zzjn2.getContext().getPackageManager();
            String string2 = map.get("data");
            try {
                jSONObject = new JSONObject(string2);
            }
            catch (JSONException jSONException) {
                zzjn2.zzb("openableIntents", new JSONObject());
                return;
            }
            try {
                jSONArray = jSONObject.getJSONArray("intents");
            }
            catch (JSONException jSONException) {
                zzjn2.zzb("openableIntents", new JSONObject());
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (int i = 0; i < jSONArray.length(); ++i) {
                ResolveInfo resolveInfo;
                JSONObject jSONObject3;
                try {
                    jSONObject3 = jSONArray.getJSONObject(i);
                }
                catch (JSONException jSONException) {
                    zzb.zzb("Error parsing the intent data.", jSONException);
                    continue;
                }
                String string3 = jSONObject3.optString("id");
                String string4 = jSONObject3.optString("u");
                String string5 = jSONObject3.optString("i");
                String string6 = jSONObject3.optString("m");
                String string7 = jSONObject3.optString("p");
                String string8 = jSONObject3.optString("c");
                String string9 = jSONObject3.optString("f");
                String string10 = jSONObject3.optString("e");
                Intent intent = new Intent();
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    intent.setData(Uri.parse((String)string4));
                }
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    intent.setAction(string5);
                }
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    intent.setType(string6);
                }
                if (!TextUtils.isEmpty((CharSequence)string7)) {
                    intent.setPackage(string7);
                }
                if (!TextUtils.isEmpty((CharSequence)string8) && ((ResolveInfo)(resolveInfo = string8.split("/", 2))).length == 2) {
                    intent.setComponent(new ComponentName((String)resolveInfo[0], (String)resolveInfo[1]));
                }
                boolean bl = (resolveInfo = packageManager.resolveActivity(intent, 65536)) != null;
                try {
                    jSONObject2.put(string3, bl);
                    continue;
                }
                catch (JSONException jSONException) {
                    zzb.zzb("Error constructing openable urls response.", jSONException);
                }
            }
            zzjn2.zzb("openableIntents", jSONObject2);
        }
    };
    public static final zzdl zzyC = new zzdl(){

        @Override
        public void zza(zzjn zzjn2, Map<String, String> map) {
            Object object;
            String string2 = map.get("u");
            if (string2 == null) {
                zzb.zzaH("URL missing from click GMSG.");
                return;
            }
            Uri uri = Uri.parse((String)string2);
            try {
                object = zzjn2.zzhE();
                if (object != null && ((zzan)object).zzb(uri)) {
                    uri = ((zzan)object).zza(uri, zzjn2.getContext());
                }
            }
            catch (zzao zzao2) {
                zzb.zzaH("Unable to append parameter to URL: " + string2);
            }
            string2 = uri.toString();
            object = new zziw(zzjn2.getContext(), zzjn2.zzhF().afmaVersion, string2);
            ((zzil)object).zzgX();
        }
    };
    public static final zzdl zzyD = new zzdl(){

        @Override
        public void zza(zzjn zzjn2, Map<String, String> map) {
            zzd zzd2 = zzjn2.zzhA();
            if (zzd2 != null) {
                zzd2.close();
            } else {
                zzd zzd3 = zzjn2.zzhB();
                if (zzd3 != null) {
                    zzd3.close();
                } else {
                    zzb.zzaH("A GMSG tried to close something that wasn't an overlay.");
                }
            }
        }
    };
    public static final zzdl zzyE = new zzdl(){

        @Override
        public void zza(zzjn zzjn2, Map<String, String> map) {
            zzjn2.zzE("1".equals(map.get("custom_close")));
        }
    };
    public static final zzdl zzyF = new zzdl(){

        @Override
        public void zza(zzjn zzjn2, Map<String, String> map) {
            String string2 = map.get("u");
            if (string2 == null) {
                zzb.zzaH("URL missing from httpTrack GMSG.");
                return;
            }
            zziw zziw2 = new zziw(zzjn2.getContext(), zzjn2.zzhF().afmaVersion, string2);
            zziw2.zzgX();
        }
    };
    public static final zzdl zzyG = new zzdl(){

        @Override
        public void zza(zzjn zzjn2, Map<String, String> map) {
            zzb.zzaG("Received log message: " + map.get("string"));
        }
    };
    public static final zzdl zzyH = new zzdl(){

        @Override
        public void zza(zzjn zzjn2, Map<String, String> map) {
            String string2 = map.get("tx");
            String string3 = map.get("ty");
            String string4 = map.get("td");
            try {
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(string3);
                int n3 = Integer.parseInt(string4);
                zzan zzan2 = zzjn2.zzhE();
                if (zzan2 != null) {
                    zzaj zzaj2 = zzan2.zzac();
                    zzaj2.zza(n, n2, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                zzb.zzaH("Could not parse touch parameters from gmsg.");
            }
        }
    };
    public static final zzdl zzyI = new zzdl(){

        @Override
        public void zza(zzjn zzjn2, Map<String, String> map) {
            if (!zzbz.zzwy.get().booleanValue()) {
                return;
            }
            String string2 = map.get("disabled");
            boolean bl = Boolean.parseBoolean(string2);
            zzjn2.zzF(!bl);
        }
    };
    public static final zzdl zzyJ = new zzdt();
    public static final zzdl zzyK = new zzdx();
    public static final zzdl zzyL = new zzdj();
}

