/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzem;
import com.google.android.gms.internal.zzen;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzer;
import com.google.android.gms.internal.zzew;
import com.google.android.gms.internal.zzex;
import com.google.android.gms.internal.zzey;
import com.google.android.gms.internal.zzez;
import com.google.android.gms.internal.zzfd;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzip;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzha
public final class zzeq
implements zzer.zza {
    private final String zzBd;
    private final zzew zzpd;
    private final long zzBe;
    private final zzen zzBf;
    private final zzem zzBg;
    private final AdRequestParcel zzqo;
    private final AdSizeParcel zzBh;
    private final Context mContext;
    private final Object zzpK = new Object();
    private final VersionInfoParcel zzpI;
    private final boolean zzrF;
    private final NativeAdOptionsParcel zzpE;
    private final List<String> zzpF;
    private zzex zzBi;
    private int zzBj = -2;
    private zzez zzBk;

    public zzeq(Context context, String string, zzew zzew2, zzen zzen2, zzem zzem2, AdRequestParcel adRequestParcel, AdSizeParcel adSizeParcel, VersionInfoParcel versionInfoParcel, boolean bl, NativeAdOptionsParcel nativeAdOptionsParcel, List<String> list) {
        this.mContext = context;
        this.zzpd = zzew2;
        this.zzBg = zzem2;
        this.zzBd = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string) ? this.zzen() : string;
        this.zzBf = zzen2;
        this.zzBe = zzen2.zzAP != -1L ? zzen2.zzAP : 10000L;
        this.zzqo = adRequestParcel;
        this.zzBh = adSizeParcel;
        this.zzpI = versionInfoParcel;
        this.zzrF = bl;
        this.zzpE = nativeAdOptionsParcel;
        this.zzpF = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.zzpK;
        synchronized (object) {
            try {
                if (this.zzBi != null) {
                    this.zzBi.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not destroy mediation adapter.", remoteException);
            }
            this.zzBj = -1;
            this.zzpK.notify();
        }
    }

    private String zzen() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzBg.zzAI)) {
                return this.zzpd.zzag(this.zzBg.zzAI) ? "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter" : "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzb.zzaH("Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzr(int n) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzBj = n;
            this.zzpK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(int n, zzez zzez2) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzBj = n;
            this.zzBk = zzez2;
            this.zzpK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzer zza(long l, long l2) {
        Object object = this.zzpK;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            final zzep zzep2 = new zzep();
            zzip.zzKO.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = zzeq.this.zzpK;
                    synchronized (object) {
                        if (zzeq.this.zzBj != -2) {
                            return;
                        }
                        zzeq.this.zzBi = zzeq.this.zzep();
                        if (zzeq.this.zzBi == null) {
                            zzeq.this.zzr(4);
                            return;
                        }
                        if (zzeq.this.zzeq() && !zzeq.this.zzs(1)) {
                            zzb.zzaH("Ignoring adapter " + zzeq.this.zzBd + " as delayed" + " impression is not supported");
                            zzeq.this.zzr(2);
                            return;
                        }
                        zzep2.zza(zzeq.this);
                        zzeq.this.zza(zzep2);
                    }
                }
            });
            this.zza(l3, this.zzBe, l, l2);
            return new zzer(this.zzBg, this.zzBi, this.zzBd, zzep2, this.zzBj, this.zzeo());
        }
    }

    private zzez zzeo() {
        if (this.zzBj != 0 || !this.zzeq()) {
            return null;
        }
        try {
            if (this.zzs(4) && this.zzBk != null && this.zzBk.zzes() != 0) {
                return this.zzBk;
            }
        }
        catch (RemoteException remoteException) {
            zzb.zzaH("Could not get cpm value from MediationResponseMetadata");
        }
        return zzeq.zzt(this.zzer());
    }

    private zzex zzep() {
        zzb.zzaG("Instantiating mediation adapter: " + this.zzBd);
        if (zzbz.zzwA.get().booleanValue()) {
            if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzBd)) {
                return new zzfd(new AdMobAdapter());
            }
            if ("com.google.ads.mediation.AdUrlAdapter".equals(this.zzBd)) {
                return new zzfd(new AdUrlAdapter());
            }
        }
        try {
            return this.zzpd.zzaf(this.zzBd);
        }
        catch (RemoteException remoteException) {
            zzb.zza("Could not instantiate mediation adapter: " + this.zzBd, remoteException);
            return null;
        }
    }

    private void zza(zzep zzep2) {
        String string;
        if ("com.google.ads.mediation.AdUrlAdapter".equals(this.zzBd)) {
            string = this.zzqo.zztA.getBundle(this.zzBd);
            if (string == null) {
                string = new Bundle();
            }
            string.putString("sdk_less_network_id", this.zzBg.zzAF);
            this.zzqo.zztA.putBundle(this.zzBd, (Bundle)string);
        }
        string = this.zzae(this.zzBg.zzAL);
        try {
            if (this.zzpI.zzLG < 4100000) {
                if (this.zzBh.zztW) {
                    this.zzBi.zza(zze.zzB((Object)this.mContext), this.zzqo, string, zzep2);
                } else {
                    this.zzBi.zza(zze.zzB((Object)this.mContext), this.zzBh, this.zzqo, string, (zzey)zzep2);
                }
            } else if (this.zzrF) {
                this.zzBi.zza(zze.zzB((Object)this.mContext), this.zzqo, string, this.zzBg.zzAE, zzep2, this.zzpE, this.zzpF);
            } else if (this.zzBh.zztW) {
                this.zzBi.zza(zze.zzB((Object)this.mContext), this.zzqo, string, this.zzBg.zzAE, (zzey)zzep2);
            } else {
                this.zzBi.zza(zze.zzB((Object)this.mContext), this.zzBh, this.zzqo, string, this.zzBg.zzAE, zzep2);
            }
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not request ad from mediation adapter.", remoteException);
            this.zzr(5);
        }
    }

    private void zza(long l, long l2, long l3, long l4) {
        while (this.zzBj == -2) {
            this.zzb(l, l2, l3, l4);
        }
        return;
    }

    private void zzb(long l, long l2, long l3, long l4) {
        long l5 = SystemClock.elapsedRealtime();
        long l6 = l2 - (l5 - l);
        long l7 = l4 - (l5 - l3);
        if (l6 <= 0L || l7 <= 0L) {
            zzb.zzaG("Timed out waiting for adapter.");
            this.zzBj = 3;
            return;
        }
        try {
            this.zzpK.wait(Math.min(l6, l7));
        }
        catch (InterruptedException interruptedException) {
            this.zzBj = -1;
        }
    }

    private boolean zzs(int n) {
        Bundle bundle = null;
        try {
            bundle = this.zzrF ? this.zzBi.zzex() : (this.zzBh.zztW ? this.zzBi.getInterstitialAdapterInfo() : this.zzBi.zzew());
        }
        catch (RemoteException remoteException) {
            zzb.zzaH("Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private boolean zzeq() {
        return this.zzBf.zzAX != -1;
    }

    private String zzae(String string) {
        if (string == null || !this.zzeq() || this.zzs(2)) {
            return string;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzb.zzaH("Could not remove field. Returning the original value");
            return string;
        }
    }

    private int zzer() {
        JSONObject jSONObject;
        if (this.zzBg.zzAL == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzBg.zzAL);
        }
        catch (JSONException jSONException) {
            zzb.zzaH("Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzBd)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzs(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static zzez zzt(final int n) {
        return new zzez.zza(){

            @Override
            public int zzes() throws RemoteException {
                return n;
            }
        };
    }
}

