/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzbr;
import com.google.android.gms.internal.zzfr;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzjn;
import java.util.Map;

@zzha
public class zzfo
extends zzfr {
    private final Map<String, String> zzxc;
    private final Context mContext;

    public zzfo(zzjn zzjn2, Map<String, String> map) {
        super(zzjn2, "storePicture");
        this.zzxc = map;
        this.mContext = zzjn2.zzhx();
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzal("Activity context is not available");
            return;
        }
        zzbr zzbr2 = zzp.zzbx().zzN(this.mContext);
        if (!zzbr2.zzdf()) {
            this.zzal("Feature is not supported by the device.");
            return;
        }
        final String string2 = this.zzxc.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzal("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            this.zzal("Invalid image url: " + string2);
            return;
        }
        final String string3 = this.zzak(string2);
        if (!zzp.zzbx().zzaB(string3)) {
            this.zzal("Image type not recognized: " + string3);
            return;
        }
        AlertDialog.Builder builder = zzp.zzbx().zzM(this.mContext);
        builder.setTitle((CharSequence)zzp.zzbA().zzf(R.string.store_picture_title, "Save image"));
        builder.setMessage((CharSequence)zzp.zzbA().zzf(R.string.store_picture_message, "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)zzp.zzbA().zzf(R.string.accept, "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                DownloadManager downloadManager = (DownloadManager)zzfo.this.mContext.getSystemService("download");
                try {
                    DownloadManager.Request request = zzfo.this.zzf(string2, string3);
                    downloadManager.enqueue(request);
                }
                catch (IllegalStateException illegalStateException) {
                    zzfo.this.zzal("Could not store picture.");
                }
            }
        });
        builder.setNegativeButton((CharSequence)zzp.zzbA().zzf(R.string.decline, "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzfo.this.zzal("User canceled the download.");
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    DownloadManager.Request zzf(String string2, String string3) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_PICTURES, string3);
        zzp.zzbz().zza(request);
        return request;
    }

    String zzak(String string2) {
        Uri uri = Uri.parse((String)string2);
        return uri.getLastPathSegment();
    }
}

