/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.formats.zzc;
import com.google.android.gms.ads.internal.formats.zzf;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.zzn;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzbb;
import com.google.android.gms.internal.zzbc;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzcz;
import com.google.android.gms.internal.zzdl;
import com.google.android.gms.internal.zzgw;
import com.google.android.gms.internal.zzgx;
import com.google.android.gms.internal.zzgy;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzie;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzjc;
import com.google.android.gms.internal.zzjd;
import com.google.android.gms.internal.zzje;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zznt;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzha
public class zzgv
implements Callable<zzie> {
    private static final long zzFC = TimeUnit.SECONDS.toMillis(60L);
    private final Context mContext;
    private final zziu zzFD;
    private final zzn zzFE;
    private final zzan zzxV;
    private final zzbc zzFF;
    private final Object zzpK = new Object();
    private final zzie.zza zzFc;
    private boolean zzFG;
    private int zzFt;
    private List<String> zzFH;
    private JSONObject zzFI;

    public zzgv(Context context, zzn zzn2, zzbc zzbc2, zziu zziu2, zzan zzan2, zzie.zza zza2) {
        this.mContext = context;
        this.zzFE = zzn2;
        this.zzFD = zziu2;
        this.zzFF = zzbc2;
        this.zzFc = zza2;
        this.zzxV = zzan2;
        this.zzFG = false;
        this.zzFt = -2;
        this.zzFH = null;
    }

    public zzie zzfY() {
        try {
            zzbb zzbb2 = this.zzfZ();
            JSONObject jSONObject = this.zzb(zzbb2);
            zza zza2 = this.zzd(jSONObject);
            zzh.zza zza3 = this.zza(zzbb2, zza2, jSONObject);
            this.zza(zza3, zzbb2);
            zzie zzie2 = this.zza(zza3);
            return zzie2;
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Malformed native JSON response.", jSONException);
        }
        catch (TimeoutException timeoutException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Timeout when loading native ad.", timeoutException);
        }
        if (!this.zzFG) {
            this.zzF(0);
        }
        return this.zza(null);
    }

    private zzbb zzfZ() throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        if (this.zzga()) {
            return null;
        }
        String string2 = zzbz.zzwh.get();
        String string3 = this.zzFc.zzJL.zzDE.indexOf("https") == 0 ? "https:" : "http:";
        String string4 = string3 + string2;
        zzbb zzbb2 = this.zzFF.zza(this.mContext, this.zzFc.zzJK.zzqR, string4, this.zzxV).get(zzFC, TimeUnit.MILLISECONDS);
        zzbb2.zza(this.zzFE, this.zzFE, this.zzFE, this.zzFE, false, null, null, null, null);
        return zzbb2;
    }

    private JSONObject zzb(final zzbb zzbb2) throws TimeoutException, JSONException {
        zzdl zzdl2;
        if (this.zzga()) {
            return null;
        }
        final zzjb zzjb2 = new zzjb();
        final zzb zzb2 = new zzb();
        zzb2.zzFY = zzdl2 = new zzdl(){

            @Override
            public void zza(zzjn zzjn2, Map<String, String> map) {
                zzbb2.zzb("/nativeAdPreProcess", zzb2.zzFY);
                try {
                    String string2 = map.get("success");
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        zzjb2.zzf(new JSONObject(string2).getJSONArray("ads").getJSONObject(0));
                        return;
                    }
                }
                catch (JSONException jSONException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("Malformed native JSON response.", jSONException);
                }
                zzgv.this.zzF(0);
                zzx.zza((boolean)zzgv.this.zzga(), (Object)"Unable to set the ad state error!");
                zzjb2.zzf(null);
            }
        };
        zzbb2.zza("/nativeAdPreProcess", zzdl2);
        JSONObject jSONObject = new JSONObject(this.zzFc.zzJL.body);
        zzbb2.zza("google.afma.nativeAds.preProcessJsonGmsg", jSONObject);
        return (JSONObject)zzjb2.get(zzFC, TimeUnit.MILLISECONDS);
    }

    protected zza zzd(JSONObject jSONObject) throws JSONException, TimeoutException {
        boolean bl;
        if (this.zzga()) {
            return null;
        }
        String string2 = jSONObject.getString("template_id");
        boolean bl2 = this.zzFc.zzJK.zzrj != null ? this.zzFc.zzJK.zzrj.zzyc : false;
        boolean bl3 = bl = this.zzFc.zzJK.zzrj != null ? this.zzFc.zzJK.zzrj.zzye : false;
        if ("2".equals(string2)) {
            return new zzgw(bl2, bl);
        }
        if ("1".equals(string2)) {
            return new zzgx(bl2, bl);
        }
        if ("3".equals(string2)) {
            final String string3 = jSONObject.getString("custom_template_id");
            final zzjb zzjb2 = new zzjb();
            zzip.zzKO.post(new Runnable(){

                @Override
                public void run() {
                    zzjb2.zzf(zzgv.this.zzFE.zzbq().get((Object)string3));
                }
            });
            if (zzjb2.get(zzFC, TimeUnit.MILLISECONDS) != null) {
                return new zzgy(bl2);
            }
            com.google.android.gms.ads.internal.util.client.zzb.e("No handler for custom template: " + jSONObject.getString("custom_template_id"));
        } else {
            this.zzF(0);
        }
        return null;
    }

    private void zza(zzh.zza zza2, zzbb zzbb2) {
        zzdl zzdl2;
        if (!(zza2 instanceof zzf)) {
            return;
        }
        final zzf zzf2 = (zzf)zza2;
        zzb zzb2 = new zzb();
        zzb2.zzFY = zzdl2 = new zzdl(){

            @Override
            public void zza(zzjn zzjn2, Map<String, String> map) {
                String string2 = map.get("asset");
                zzgv.this.zzb(zzf2, string2);
            }
        };
        zzbb2.zza("/nativeAdCustomClick", zzdl2);
    }

    private void zzb(zzcv zzcv2, String string2) {
        try {
            zzcz zzcz2 = this.zzFE.zzr(zzcv2.getCustomTemplateId());
            if (zzcz2 != null) {
                zzcz2.zza(zzcv2, string2);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call onCustomClick for asset " + string2 + ".", remoteException);
        }
    }

    private zzh.zza zza(zzbb zzbb2, zza zza2, JSONObject jSONObject) throws ExecutionException, InterruptedException, JSONException {
        if (this.zzga()) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("tracking_urls_and_actions");
        String[] stringArray = this.zzc(jSONObject2, "impression_tracking_urls");
        this.zzFH = stringArray == null ? null : Arrays.asList(stringArray);
        this.zzFI = jSONObject2.optJSONObject("active_view");
        Object t = zza2.zza(this, jSONObject);
        if (t == null) {
            com.google.android.gms.ads.internal.util.client.zzb.e("Failed to retrieve ad assets.");
            return null;
        }
        t.zzb(new zzh(this.mContext, this.zzFE, zzbb2, this.zzxV, jSONObject, (zzh.zza)t, this.zzFc.zzJK.zzqR));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzie zza(zzh.zza zza2) {
        int n;
        Object object = this.zzpK;
        synchronized (object) {
            n = this.zzFt;
            if (zza2 == null && this.zzFt == -2) {
                n = 0;
            }
        }
        if (n != -2) {
            zza2 = null;
        }
        return new zzie(this.zzFc.zzJK.zzGq, null, this.zzFc.zzJL.zzAQ, n, this.zzFc.zzJL.zzAR, this.zzFH, this.zzFc.zzJL.orientation, this.zzFc.zzJL.zzAU, this.zzFc.zzJK.zzGt, false, null, null, null, null, null, 0L, this.zzFc.zzqV, this.zzFc.zzJL.zzGM, this.zzFc.zzJH, this.zzFc.zzJI, this.zzFc.zzJL.zzGS, this.zzFI, zza2);
    }

    public zzje<com.google.android.gms.ads.internal.formats.zza> zze(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject("attribution");
        if (jSONObject2 == null) {
            return new zzjc<Object>(null);
        }
        final String string2 = jSONObject2.optString("text");
        final int n = jSONObject2.optInt("text_size", -1);
        final Integer n2 = this.zzb(jSONObject2, "text_color");
        final Integer n3 = this.zzb(jSONObject2, "bg_color");
        final int n4 = jSONObject2.optInt("animation_ms", 1000);
        final int n5 = jSONObject2.optInt("presentation_ms", 4000);
        ArrayList arrayList = new ArrayList<zzje<zzc>>();
        if (jSONObject2.optJSONArray("images") != null) {
            arrayList = this.zza(jSONObject2, "images", false, false, true);
        } else {
            arrayList.add(this.zza(jSONObject2, "image", false, false));
        }
        zzje zzje2 = zzjd.zzj(arrayList);
        return zzjd.zza(zzje2, new zzjd.zza<List<zzc>, com.google.android.gms.ads.internal.formats.zza>(){

            public com.google.android.gms.ads.internal.formats.zza zzh(List<zzc> list) {
                try {
                    return list == null || list.isEmpty() ? null : new com.google.android.gms.ads.internal.formats.zza(string2, zzgv.zzf(list), n3, n2, n > 0 ? Integer.valueOf(n) : null, n5 + n4);
                }
                catch (RemoteException remoteException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("Could not get attribution icon", remoteException);
                    return null;
                }
            }

            @Override
            public /* synthetic */ Object zze(Object object) {
                return this.zzh((List)object);
            }
        });
    }

    private Integer zzb(JSONObject jSONObject, String string2) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            int n = jSONObject2.getInt("r");
            int n2 = jSONObject2.getInt("g");
            int n3 = jSONObject2.getInt("b");
            return Color.rgb((int)n, (int)n2, (int)n3);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Future<zzc> zza(JSONObject jSONObject, String string2, boolean bl) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
        boolean bl2 = jSONObject2.optBoolean("require", true);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl2, bl);
    }

    public zzje<zzc> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2) throws JSONException {
        JSONObject jSONObject2 = bl ? jSONObject.getJSONObject(string2) : jSONObject.optJSONObject(string2);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl, bl2);
    }

    public List<zzje<zzc>> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2, boolean bl3) throws JSONException {
        JSONArray jSONArray = bl ? jSONObject.getJSONArray(string2) : jSONObject.optJSONArray(string2);
        ArrayList<zzje<zzc>> arrayList = new ArrayList<zzje<zzc>>();
        if (jSONArray == null || jSONArray.length() == 0) {
            this.zza(0, bl);
            return arrayList;
        }
        int n = bl3 ? jSONArray.length() : 1;
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
            arrayList.add(this.zza(jSONObject2, bl, bl2));
        }
        return arrayList;
    }

    private zzje<zzc> zza(JSONObject jSONObject, final boolean bl, boolean bl2) throws JSONException {
        final String string2 = bl ? jSONObject.getString("url") : jSONObject.optString("url");
        final double d = jSONObject.optDouble("scale", 1.0);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zza(0, bl);
            return new zzjc<Object>(null);
        }
        if (bl2) {
            return new zzjc<zzc>(new zzc(null, Uri.parse((String)string2), d));
        }
        return this.zzFD.zza(string2, new zziu.zza<zzc>(){

            public zzc zzgb() {
                zzgv.this.zza(2, bl);
                return null;
            }

            public zzc zzg(InputStream inputStream) {
                byte[] byArray = null;
                try {
                    byArray = zznt.zzk((InputStream)inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (byArray == null) {
                    zzgv.this.zza(2, bl);
                    return null;
                }
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                if (bitmap == null) {
                    zzgv.this.zza(2, bl);
                    return null;
                }
                bitmap.setDensity((int)(160.0 * d));
                return new zzc((Drawable)new BitmapDrawable(Resources.getSystem(), bitmap), Uri.parse((String)string2), d);
            }

            @Override
            public /* synthetic */ Object zzgc() {
                return this.zzgb();
            }

            @Override
            public /* synthetic */ Object zzh(InputStream inputStream) {
                return this.zzg(inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzga() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzFG;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzF(int n) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzFG = true;
            this.zzFt = n;
        }
    }

    public void zza(int n, boolean bl) {
        if (bl) {
            this.zzF(n);
        }
    }

    private String[] zzc(JSONObject jSONObject, String string2) throws JSONException {
        JSONArray jSONArray = jSONObject.optJSONArray(string2);
        if (jSONArray == null) {
            return null;
        }
        String[] stringArray = new String[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            stringArray[i] = jSONArray.getString(i);
        }
        return stringArray;
    }

    private static List<Drawable> zzf(List<zzc> list) throws RemoteException {
        ArrayList<Drawable> arrayList = new ArrayList<Drawable>();
        for (zzc zzc2 : list) {
            arrayList.add((Drawable)zze.zzp((zzd)zzc2.zzdC()));
        }
        return arrayList;
    }

    @Override
    public /* synthetic */ Object call() throws Exception {
        return this.zzfY();
    }

    class zzb {
        public zzdl zzFY;

        zzb() {
        }
    }

    public static interface zza<T extends zzh.zza> {
        public T zza(zzgv var1, JSONObject var2) throws JSONException, InterruptedException, ExecutionException;
    }
}

