/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.PopupWindow;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.doubleclick.PublisherAdView;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.ads.search.SearchAdView;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzbr;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zziw;
import com.google.android.gms.internal.zzjn;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzha
public class zzip {
    private static final String zzKI = AdView.class.getName();
    private static final String zzKJ = InterstitialAd.class.getName();
    private static final String zzKK = PublisherAdView.class.getName();
    private static final String zzKL = PublisherInterstitialAd.class.getName();
    private static final String zzKM = SearchAdView.class.getName();
    private static final String zzKN = AdLoader.class.getName();
    public static final Handler zzKO = new zzim(Looper.getMainLooper());
    private final Object zzpK = new Object();
    private boolean zzKP = true;
    private String zzKi;
    private boolean zzKQ = false;

    public void zza(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection) {
        this.zza(context, string2, bl, httpURLConnection, false);
    }

    public void zza(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection, boolean bl2) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(bl);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.setRequestProperty("User-Agent", this.zzd(context, string2));
        httpURLConnection.setUseCaches(bl2);
    }

    public void zza(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection, String string3) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(bl);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.setRequestProperty("User-Agent", string3);
        httpURLConnection.setUseCaches(false);
    }

    public boolean zzJ(Context context) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        PackageManager packageManager = context.getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
        boolean bl = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            zzb.zzaH("Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl = false;
        } else {
            String string2 = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                zzb.zzaH(String.format(string2, "keyboard"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                zzb.zzaH(String.format(string2, "keyboardHidden"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                zzb.zzaH(String.format(string2, "orientation"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                zzb.zzaH(String.format(string2, "screenLayout"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                zzb.zzaH(String.format(string2, "uiMode"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                zzb.zzaH(String.format(string2, "screenSize"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                zzb.zzaH(String.format(string2, "smallestScreenSize"));
                bl = false;
            }
        }
        return bl;
    }

    public boolean zza(PackageManager packageManager, String string2, String string3) {
        return packageManager.checkPermission(string3, string2) == 0;
    }

    public boolean zzgY() {
        return this.zzKP;
    }

    public void zza(Context context, String string2, List<String> list) {
        for (String string3 : list) {
            new zziw(context, string2, string3).zzgX();
        }
    }

    public void zzc(Context context, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        this.zza(context, string2, arrayList);
    }

    public void zza(Context context, String string2, List<String> list, String string3) {
        for (String string4 : list) {
            new zziw(context, string2, string4, string3).zzgX();
        }
    }

    public String zza(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8192);
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public boolean zzK(Context context) {
        if (this.zzKQ) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zza(), intentFilter);
        this.zzKQ = true;
        return true;
    }

    public void zza(Context context, String string2, WebSettings webSettings) {
        webSettings.setUserAgentString(this.zzd(context, string2));
    }

    String zzgZ() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuffer.append(" ").append(Build.VERSION.RELEASE);
        }
        stringBuffer.append("; ").append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuffer.append("; ").append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuffer.append(" Build/").append(Build.DISPLAY);
            }
        }
        stringBuffer.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzd(final Context context, String string2) {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzKi != null) {
                return this.zzKi;
            }
            try {
                this.zzKi = zzp.zzbz().getDefaultUserAgent(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (TextUtils.isEmpty((CharSequence)this.zzKi)) {
                if (!zzl.zzcN().zzhr()) {
                    this.zzKi = null;
                    zzKO.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = zzip.this.zzpK;
                            synchronized (object) {
                                zzip.this.zzKi = zzip.this.zzL(context);
                                zzip.this.zzpK.notifyAll();
                            }
                        }
                    });
                    while (this.zzKi == null) {
                        try {
                            this.zzpK.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.zzKi = this.zzgZ();
                            zzb.zzaH("Interrupted, use default user agent: " + this.zzKi);
                        }
                    }
                } else {
                    try {
                        this.zzKi = this.zzL(context);
                    }
                    catch (Exception exception) {
                        this.zzKi = this.zzgZ();
                    }
                }
            }
            this.zzKi = this.zzKi + " (Mobile; " + string2 + ")";
            return this.zzKi;
        }
    }

    protected String zzL(Context context) {
        return new WebView(context).getSettings().getUserAgentString();
    }

    public boolean zza(ClassLoader classLoader, Class<?> clazz, String string2) {
        try {
            Class<?> clazz2 = Class.forName(string2, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String zzaz(String string2) {
        return Uri.parse((String)string2).buildUpon().query(null).build().toString();
    }

    public JSONObject zzz(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string2 : map.keySet()) {
                this.zza(jSONObject, string2, map.get(string2));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            throw new JSONException("Could not convert map to JSON: " + classCastException.getMessage());
        }
    }

    private JSONObject zzf(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            this.zza(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    private JSONArray zza(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            this.zza(jSONArray, obj);
        }
        return jSONArray;
    }

    JSONArray zza(Object[] objectArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object object : objectArray) {
            this.zza(jSONArray, object);
        }
        return jSONArray;
    }

    private void zza(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zzf((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)this.zzz(map));
        } else if (object instanceof Collection) {
            jSONArray.put((Object)this.zza((Collection)object));
        } else if (object instanceof Object[]) {
            jSONArray.put((Object)this.zza((Object[])object));
        } else {
            jSONArray.put(object);
        }
    }

    private void zza(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)this.zzf((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string2, (Object)this.zzz(map));
        } else if (object instanceof Collection) {
            jSONObject.put(string2 != null ? string2 : "null", (Object)this.zza((Collection)object));
        } else if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)this.zza(Arrays.asList((Object[])object)));
        } else {
            jSONObject.put(string2, object);
        }
    }

    public Map<String, String> zze(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set<String> set = zzp.zzbz().zzf(uri);
        for (String string2 : set) {
            hashMap.put(string2, uri.getQueryParameter(string2));
        }
        return hashMap;
    }

    public String zzha() {
        UUID uUID = UUID.randomUUID();
        byte[] byArray = BigInteger.valueOf(uUID.getLeastSignificantBits()).toByteArray();
        byte[] byArray2 = BigInteger.valueOf(uUID.getMostSignificantBits()).toByteArray();
        String string2 = new BigInteger(1, byArray).toString();
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(byArray);
                messageDigest.update(byArray2);
                byte[] byArray3 = new byte[8];
                System.arraycopy(messageDigest.digest(), 0, byArray3, 0, 8);
                string2 = new BigInteger(1, byArray3).toString();
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return string2;
    }

    public int zzaA(String string2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            zzb.zzaH("Could not parse value:" + numberFormatException);
            return 0;
        }
    }

    public String zzhb() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        return string2.startsWith(string3) ? string2 : string3 + " " + string2;
    }

    protected int[] zzhc() {
        return new int[]{0, 0};
    }

    public int[] zzg(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getWidth(), view.getHeight()};
        }
        return this.zzhc();
    }

    public int[] zzh(Activity activity) {
        int[] nArray = this.zzg(activity);
        return new int[]{zzl.zzcN().zzc((Context)activity, nArray[0]), zzl.zzcN().zzc((Context)activity, nArray[1])};
    }

    public int[] zzi(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getTop(), view.getBottom()};
        }
        return this.zzhc();
    }

    public int[] zzj(Activity activity) {
        int[] nArray = this.zzi(activity);
        return new int[]{zzl.zzcN().zzc((Context)activity, nArray[0]), zzl.zzcN().zzc((Context)activity, nArray[1])};
    }

    public boolean zzaB(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.matches("([^\\s]+(\\.(?i)(jpg|png|gif|bmp|webp))$)");
    }

    public void zza(Activity activity, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
        }
    }

    public void zza(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public void zzb(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public DisplayMetrics zza(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = windowManager.getDefaultDisplay();
        display.getMetrics(displayMetrics);
        return displayMetrics;
    }

    public AlertDialog.Builder zzM(Context context) {
        return new AlertDialog.Builder(context);
    }

    public zzbr zzN(Context context) {
        return new zzbr(context);
    }

    public Bitmap zzl(View view) {
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public PopupWindow zza(View view, int n, int n2, boolean bl) {
        return new PopupWindow(view, n, n2, bl);
    }

    public String zzO(Context context) {
        try {
            ActivityManager.RunningTaskInfo runningTaskInfo;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return null;
            }
            List list = activityManager.getRunningTasks(1);
            if (list != null && !list.isEmpty() && (runningTaskInfo = (ActivityManager.RunningTaskInfo)list.get(0)) != null && runningTaskInfo.topActivity != null) {
                return runningTaskInfo.topActivity.getClassName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String zza(Context context, View view, AdSizeParcel adSizeParcel) {
        if (!zzbz.zzwe.get().booleanValue()) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("width", adSizeParcel.width);
            jSONObject2.put("height", adSizeParcel.height);
            jSONObject.put("size", (Object)jSONObject2);
            jSONObject.put("activity", (Object)this.zzO(context));
            if (!adSizeParcel.zztW) {
                JSONArray jSONArray = new JSONArray();
                View view2 = view;
                while (view2 != null) {
                    ViewParent viewParent = view2.getParent();
                    if (viewParent != null) {
                        int n = -1;
                        if (viewParent instanceof ViewGroup) {
                            n = ((ViewGroup)viewParent).indexOfChild(view2);
                        }
                        JSONObject jSONObject3 = new JSONObject();
                        jSONObject3.put("type", (Object)viewParent.getClass().getName());
                        jSONObject3.put("index_of_child", n);
                        jSONArray.put((Object)jSONObject3);
                    }
                    if (viewParent != null && viewParent instanceof View) {
                        view2 = (View)viewParent;
                        continue;
                    }
                    view2 = null;
                }
                if (jSONArray.length() > 0) {
                    jSONObject.put("parents", (Object)jSONArray);
                }
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzb.zzd("Fail to get view hierarchy json", jSONException);
            return null;
        }
    }

    public String zza(zzjn zzjn2, String string2) {
        return this.zza(zzjn2.getContext(), zzjn2.zzhE(), string2);
    }

    public String zza(Context context, zzan zzan2, String string2) {
        if (zzan2 == null) {
            return string2;
        }
        try {
            Uri uri = Uri.parse((String)string2);
            if (zzan2.zzc(uri)) {
                uri = zzan2.zza(uri, context);
            }
            return uri.toString();
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public boolean zzP(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzs(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean zzs(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    public void zza(Context context, String string2, String string3, Bundle bundle, boolean bl) {
        Context context2;
        if (bl) {
            context2 = context.getApplicationContext();
            if (context2 == null) {
                context2 = context;
            }
            bundle.putString("os", Build.VERSION.RELEASE);
            bundle.putString("api", String.valueOf(Build.VERSION.SDK_INT));
            bundle.putString("device", zzp.zzbx().zzhb());
            bundle.putString("appid", context2.getPackageName());
            bundle.putString("eids", TextUtils.join((CharSequence)",", zzbz.zzdl()));
            if (string2 != null) {
                bundle.putString("js", string2);
            } else {
                bundle.putString("gmscore_version", Integer.toString(GooglePlayServicesUtil.zzan((Context)context)));
            }
        }
        context2 = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", string3);
        for (String string4 : bundle.keySet()) {
            context2.appendQueryParameter(string4, bundle.getString(string4));
        }
        zzp.zzbx().zzc(context, string2, context2.toString());
    }

    public void zzb(Context context, String string2, String string3, Bundle bundle, boolean bl) {
        if (zzbz.zzws.get().booleanValue()) {
            this.zza(context, string2, string3, bundle, bl);
        }
    }

    public String zza(StackTraceElement[] stackTraceElementArray, String string2) {
        if (zzbz.zzwx.get().booleanValue()) {
            String string3 = null;
            int n = 0;
            while (n + 1 < stackTraceElementArray.length) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n];
                String string4 = stackTraceElement.getClassName();
                String string5 = stackTraceElement.getMethodName();
                if ("loadAd".equalsIgnoreCase(string5) && (zzKI.equalsIgnoreCase(string4) || zzKJ.equalsIgnoreCase(string4) || zzKK.equalsIgnoreCase(string4) || zzKL.equalsIgnoreCase(string4) || zzKM.equalsIgnoreCase(string4) || zzKN.equalsIgnoreCase(string4))) {
                    string3 = stackTraceElementArray[n + 1].getClassName();
                    break;
                }
                ++n;
            }
            if (string2 != null) {
                String string6 = zzip.zzb(string2, ".", 3);
                if (string3 != null && !string3.contains(string6)) {
                    return string3;
                }
            }
        }
        return null;
    }

    static String zzb(String string2, String string3, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        StringBuilder stringBuilder = new StringBuilder();
        if (n-- > 0 && stringTokenizer.hasMoreElements()) {
            stringBuilder.append(stringTokenizer.nextToken());
        } else {
            return string2;
        }
        while (n-- > 0 && stringTokenizer.hasMoreElements()) {
            stringBuilder.append(".").append(stringTokenizer.nextToken());
        }
        return stringBuilder.toString();
    }

    public static void runOnUiThread(Runnable runnable) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            zzKO.post(runnable);
        }
    }

    public Bitmap zzQ(Context context) {
        if (!(context instanceof Activity)) {
            return null;
        }
        try {
            View view = ((Activity)context).getWindow().getDecorView();
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            view.layout(0, 0, view.getWidth(), view.getHeight());
            view.draw(canvas);
            return bitmap;
        }
        catch (RuntimeException runtimeException) {
            zzb.zzb("Fail to capture screen shot", runtimeException);
            return null;
        }
    }

    public boolean zza(Context context, Bitmap bitmap, String string2) {
        zzx.zzcy((String)"saveImageToFile must not be called on the main UI thread.");
        try {
            FileOutputStream fileOutputStream = context.openFileOutput(string2, 0);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            bitmap.recycle();
            return true;
        }
        catch (Exception exception) {
            zzb.zzb("Fail to save file", exception);
            return false;
        }
    }

    public Bitmap zze(Context context, String string2) {
        zzx.zzcy((String)"getBackgroundImage must not be called on the main UI thread.");
        try {
            FileInputStream fileInputStream = context.openFileInput(string2);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)fileInputStream);
            fileInputStream.close();
            return bitmap;
        }
        catch (Exception exception) {
            zzb.e("Fail to get background image");
            return null;
        }
    }

    public void zzf(Context context, String string2) {
        zzx.zzcy((String)"deleteFile must not be called on the main UI thread.");
        context.deleteFile(string2);
    }

    public void zzb(Context context, Intent intent) {
        try {
            context.startActivity(intent);
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    private final class zza
    extends BroadcastReceiver {
        private zza() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                zzip.this.zzKP = true;
            } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                zzip.this.zzKP = false;
            }
        }
    }
}

