/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzt;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzir;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzhb
@TargetApi(value=14)
public class zzc
extends zzi
implements AudioManager.OnAudioFocusChangeListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzDN = new HashMap<Integer, String>();
    private final zzt zzDO;
    private int zzDP = 0;
    private int zzDQ = 0;
    private MediaPlayer zzDR;
    private Uri zzDS;
    private int zzDT;
    private int zzDU;
    private int zzDV;
    private int zzDW;
    private int zzDX;
    private float zzDY = 1.0f;
    private boolean zzDZ;
    private boolean zzEa;
    private int zzEb;
    private zzh zzEc;

    public zzc(Context context, zzt zzt2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzDO = zzt2;
        this.zzDO.zza(this);
    }

    @Override
    public String zzeZ() {
        return "MediaPlayer";
    }

    @Override
    public void zza(zzh zzh2) {
        this.zzEc = zzh2;
    }

    @Override
    public void setMimeType(String mimeType) {
    }

    @Override
    public void setVideoPath(String path) {
        this.setVideoURI(Uri.parse((String)path));
    }

    public void setVideoURI(Uri uri) {
        this.zzDS = uri;
        this.zzEb = 0;
        this.zzfa();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void stop() {
        zzin.v("AdMediaPlayerView stop");
        if (this.zzDR != null) {
            this.zzDR.stop();
            this.zzDR.release();
            this.zzDR = null;
            this.zzw(0);
            this.zzx(0);
            this.zzfd();
        }
        this.zzDO.onStop();
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        zzin.v("AdMediaPlayerView size changed: " + width + " x " + height);
        this.zzDT = mp.getVideoWidth();
        this.zzDU = mp.getVideoHeight();
        if (this.zzDT != 0 && this.zzDU != 0) {
            this.requestLayout();
        }
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        zzin.v("AdMediaPlayerView prepared");
        this.zzw(2);
        this.zzDO.zzfz();
        zzir.zzMc.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzEc != null) {
                    zzc.this.zzEc.zzfz();
                }
            }
        });
        this.zzDT = mediaPlayer.getVideoWidth();
        this.zzDU = mediaPlayer.getVideoHeight();
        if (this.zzEb != 0) {
            this.seekTo(this.zzEb);
        }
        this.zzfb();
        zzin.zzaJ("AdMediaPlayerView stream dimensions: " + this.zzDT + " x " + this.zzDU);
        if (this.zzDQ == 3) {
            this.play();
        }
        this.zzfc();
        this.zzfj();
    }

    public void onCompletion(MediaPlayer mp) {
        zzin.v("AdMediaPlayerView completion");
        this.zzw(5);
        this.zzx(5);
        zzir.zzMc.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzEc != null) {
                    zzc.this.zzEc.zzfB();
                }
            }
        });
    }

    public boolean onInfo(MediaPlayer mp, int what, int extra) {
        String string2 = zzDN.get(what);
        String string3 = zzDN.get(extra);
        zzin.v("AdMediaPlayerView MediaPlayer info: " + string2 + ":" + string3);
        return true;
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        final String string2 = zzDN.get(what);
        final String string3 = zzDN.get(extra);
        zzin.zzaK("AdMediaPlayerView MediaPlayer error: " + string2 + ":" + string3);
        this.zzw(-1);
        this.zzx(-1);
        zzir.zzMc.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzEc != null) {
                    zzc.this.zzEc.zzg(string2, string3);
                }
            }
        });
        return true;
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        this.zzDV = percent;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        zzin.v("AdMediaPlayerView surface created");
        this.zzfa();
        zzir.zzMc.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzEc != null) {
                    zzc.this.zzEc.zzfy();
                }
            }
        });
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int w, int h) {
        boolean bl;
        zzin.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzDQ == 3;
        boolean bl3 = bl = this.zzDT == w && this.zzDU == h;
        if (this.zzDR != null && bl2 && bl) {
            if (this.zzEb != 0) {
                this.seekTo(this.zzEb);
            }
            this.play();
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        zzin.v("AdMediaPlayerView surface destroyed");
        if (this.zzDR != null && this.zzEb == 0) {
            this.zzEb = this.zzDR.getCurrentPosition();
        }
        zzir.zzMc.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzEc != null) {
                    zzc.this.zzEc.onPaused();
                    zzc.this.zzEc.zzfC();
                }
            }
        });
        this.zzv(true);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        this.zzDO.zzb(this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n = zzc.getDefaultSize((int)this.zzDT, (int)widthMeasureSpec);
        int n2 = zzc.getDefaultSize((int)this.zzDU, (int)heightMeasureSpec);
        if (this.zzDT > 0 && this.zzDU > 0) {
            int n3 = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n4 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n5 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n6 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (n3 == 0x40000000 && n5 == 0x40000000) {
                n2 = n6;
                n = n4;
                if (this.zzDT * n2 < n * this.zzDU) {
                    n = n2 * this.zzDT / this.zzDU;
                } else if (this.zzDT * n2 > n * this.zzDU) {
                    n2 = n * this.zzDU / this.zzDT;
                }
            } else if (n3 == 0x40000000) {
                n = n4;
                n2 = n * this.zzDU / this.zzDT;
                if (n5 == Integer.MIN_VALUE && n2 > n6) {
                    n2 = n6;
                }
            } else if (n5 == 0x40000000) {
                n2 = n6;
                n = n2 * this.zzDT / this.zzDU;
                if (n3 == Integer.MIN_VALUE && n > n4) {
                    n = n4;
                }
            } else {
                n = this.zzDT;
                n2 = this.zzDU;
                if (n5 == Integer.MIN_VALUE && n2 > n6) {
                    n2 = n6;
                    n = n2 * this.zzDT / this.zzDU;
                }
                if (n3 == Integer.MIN_VALUE && n > n4) {
                    n = n4;
                    n2 = n * this.zzDU / this.zzDT;
                }
            }
        }
        this.setMeasuredDimension(n, n2);
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzDW > 0 && this.zzDW != n || this.zzDX > 0 && this.zzDX != n2) {
                this.zzfb();
            }
            this.zzDW = n;
            this.zzDX = n2;
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
    }

    private void zzfa() {
        zzin.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzDS == null || surfaceTexture == null) {
            return;
        }
        this.zzv(false);
        try {
            this.zzDR = new MediaPlayer();
            this.zzDR.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzDR.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzDR.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzDR.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzDR.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzDR.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzDV = 0;
            this.zzDR.setDataSource(this.getContext(), this.zzDS);
            this.zzDR.setSurface(new Surface(surfaceTexture));
            this.zzDR.setAudioStreamType(3);
            this.zzDR.setScreenOnWhilePlaying(true);
            this.zzDR.prepareAsync();
            this.zzw(1);
        }
        catch (IOException | IllegalArgumentException exception) {
            zzin.zzd("Failed to initialize MediaPlayer at " + this.zzDS, exception);
            this.onError(this.zzDR, 1, 0);
        }
    }

    private void zzfb() {
        if (this.zzfe() && this.zzDR.getCurrentPosition() > 0 && this.zzDQ != 3) {
            long l;
            zzin.v("AdMediaPlayerView nudging MediaPlayer");
            this.zzb(0.0f);
            this.zzDR.start();
            int n = this.zzDR.getCurrentPosition();
            long l2 = zzr.zzbG().currentTimeMillis();
            while (this.zzfe() && this.zzDR.getCurrentPosition() == n && (l = zzr.zzbG().currentTimeMillis()) - l2 <= 250L) {
            }
            this.zzDR.pause();
            this.zzfj();
        }
    }

    private void zzfc() {
        AudioManager audioManager = this.zzfk();
        if (audioManager != null && !this.zzEa) {
            int n = audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 2);
            if (n == 1) {
                this.zzfh();
            } else {
                zzin.zzaK("AdMediaPlayerView audio focus request failed");
            }
        }
    }

    private void zzfd() {
        zzin.v("AdMediaPlayerView abandon audio focus");
        AudioManager audioManager = this.zzfk();
        if (audioManager != null && this.zzEa) {
            int n = audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
            if (n == 1) {
                this.zzEa = false;
            } else {
                zzin.zzaK("AdMediaPlayerView abandon audio focus failed");
            }
        }
    }

    private void zzv(boolean bl) {
        zzin.v("AdMediaPlayerView release");
        if (this.zzDR != null) {
            this.zzDR.reset();
            this.zzDR.release();
            this.zzDR = null;
            this.zzw(0);
            if (bl) {
                this.zzDQ = 0;
                this.zzx(0);
            }
            this.zzfd();
        }
    }

    @Override
    public void play() {
        zzin.v("AdMediaPlayerView play");
        if (this.zzfe()) {
            this.zzDR.start();
            this.zzw(3);
            zzir.zzMc.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzEc != null) {
                        zzc.this.zzEc.zzfA();
                    }
                }
            });
        }
        this.zzx(3);
    }

    @Override
    public void pause() {
        zzin.v("AdMediaPlayerView pause");
        if (this.zzfe() && this.zzDR.isPlaying()) {
            this.zzDR.pause();
            this.zzw(4);
            zzir.zzMc.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzEc != null) {
                        zzc.this.zzEc.onPaused();
                    }
                }
            });
        }
        this.zzx(4);
    }

    @Override
    public int getDuration() {
        if (this.zzfe()) {
            return this.zzDR.getDuration();
        }
        return -1;
    }

    @Override
    public int getCurrentPosition() {
        if (this.zzfe()) {
            return this.zzDR.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public void seekTo(int millis) {
        zzin.v("AdMediaPlayerView seek " + millis);
        if (this.zzfe()) {
            this.zzDR.seekTo(millis);
            this.zzEb = 0;
        } else {
            this.zzEb = millis;
        }
    }

    private boolean zzfe() {
        return this.zzDR != null && this.zzDP != -1 && this.zzDP != 0 && this.zzDP != 1;
    }

    public void onAudioFocusChange(int focusChange) {
        if (focusChange > 0) {
            this.zzfh();
        } else if (focusChange < 0) {
            this.zzfi();
        }
    }

    @Override
    public void zzff() {
        this.zzDZ = true;
        this.zzfj();
    }

    @Override
    public void zzfg() {
        this.zzDZ = false;
        this.zzfj();
    }

    @Override
    public void zza(float f) {
        this.zzDY = f;
        this.zzfj();
    }

    @Override
    public int getVideoWidth() {
        if (this.zzDR != null) {
            return this.zzDR.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.zzDR != null) {
            return this.zzDR.getVideoHeight();
        }
        return 0;
    }

    private void zzfh() {
        zzin.v("AdMediaPlayerView audio focus gained");
        this.zzEa = true;
        this.zzfj();
    }

    private void zzfi() {
        zzin.v("AdMediaPlayerView audio focus lost");
        this.zzEa = false;
        this.zzfj();
    }

    private void zzfj() {
        if (!this.zzDZ && this.zzEa) {
            this.zzb(this.zzDY);
        } else {
            this.zzb(0.0f);
        }
    }

    private void zzb(float f) {
        if (this.zzDR != null) {
            try {
                this.zzDR.setVolume(f, f);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            zzin.zzaK("AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
        }
    }

    private AudioManager zzfk() {
        Context context = this.getContext();
        return (AudioManager)context.getSystemService("audio");
    }

    private void zzw(int n) {
        if (n == 3) {
            this.zzDO.zzfO();
        } else if (this.zzDP == 3 && n != 3) {
            this.zzDO.zzfP();
        }
        this.zzDP = n;
    }

    private void zzx(int n) {
        this.zzDQ = n;
    }

    static {
        zzDN.put(-1004, "MEDIA_ERROR_IO");
        zzDN.put(-1007, "MEDIA_ERROR_MALFORMED");
        zzDN.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
        zzDN.put(-110, "MEDIA_ERROR_TIMED_OUT");
        zzDN.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzDN.put(1, "MEDIA_ERROR_UNKNOWN");
        zzDN.put(1, "MEDIA_INFO_UNKNOWN");
        zzDN.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzDN.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        zzDN.put(701, "MEDIA_INFO_BUFFERING_START");
        zzDN.put(702, "MEDIA_INFO_BUFFERING_END");
        zzDN.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzDN.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzDN.put(802, "MEDIA_INFO_METADATA_UPDATE");
        zzDN.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
        zzDN.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
    }
}

