/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.TextureView;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzbx;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzcb;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zziv;
import java.util.concurrent.TimeUnit;

@zzhb
public class zzt {
    private final Context mContext;
    private final String zzEY;
    private final VersionInfoParcel zzEZ;
    @Nullable
    private final zzbz zzFa;
    @Nullable
    private final zzcb zzFb;
    private final zziv zzFc = new zziv.zzb().zza("min_1", Double.MIN_VALUE, 1.0).zza("1_5", 1.0, 5.0).zza("5_10", 5.0, 10.0).zza("10_20", 10.0, 20.0).zza("20_30", 20.0, 30.0).zza("30_max", 30.0, Double.MAX_VALUE).zzhA();
    private final long[] zzFd;
    private final String[] zzFe;
    @Nullable
    private zzbz zzFf;
    @Nullable
    private zzbz zzFg;
    @Nullable
    private zzbz zzFh;
    @Nullable
    private zzbz zzFi;
    private boolean zzFj;
    private zzi zzFk;
    private boolean zzFl;
    private boolean zzFm;
    private long zzFn = -1L;

    public zzt(Context context, VersionInfoParcel versionInfoParcel, String string2, @Nullable zzcb zzcb2, @Nullable zzbz zzbz2) {
        this.mContext = context;
        this.zzEZ = versionInfoParcel;
        this.zzEY = string2;
        this.zzFb = zzcb2;
        this.zzFa = zzbz2;
        String string3 = zzbt.zzvV.get();
        if (string3 == null) {
            this.zzFe = new String[0];
            this.zzFd = new long[0];
            return;
        }
        String[] stringArray = TextUtils.split((String)string3, (String)",");
        this.zzFe = new String[stringArray.length];
        this.zzFd = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.zzFd[i] = Long.parseLong(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                zzin.zzd("Unable to parse frame hash target time number.", numberFormatException);
                this.zzFd[i] = -1L;
            }
        }
    }

    public void zza(zzi zzi2) {
        zzbx.zza(this.zzFb, this.zzFa, "vpc");
        this.zzFf = zzbx.zzb(this.zzFb);
        this.zzFk = zzi2;
    }

    public void zzfz() {
        if (this.zzFf == null || this.zzFg != null) {
            return;
        }
        zzbx.zza(this.zzFb, this.zzFf, "vfr");
        this.zzFg = zzbx.zzb(this.zzFb);
    }

    public void onStop() {
        if (zzbt.zzvU.get().booleanValue() && !this.zzFl) {
            Bundle bundle = new Bundle();
            bundle.putString("type", "native-player-metrics");
            bundle.putString("request", this.zzEY);
            bundle.putString("player", this.zzFk.zzeZ());
            for (zziv.zza object : this.zzFc.getBuckets()) {
                bundle.putString("fps_c_" + object.name, Integer.toString(object.count));
                bundle.putString("fps_p_" + object.name, Double.toString(object.zzMu));
            }
            for (int i = 0; i < this.zzFd.length; ++i) {
                String string2 = this.zzFe[i];
                if (string2 == null) continue;
                bundle.putString("fh_" + Long.valueOf(this.zzFd[i]), string2);
            }
            zzr.zzbC().zza(this.mContext, this.zzEZ.afmaVersion, "gmob-apps", bundle, true);
            this.zzFl = true;
        }
    }

    public void zzb(zzi zzi2) {
        this.zzfN();
        this.zzc(zzi2);
    }

    private void zzfN() {
        if (this.zzFh != null && this.zzFi == null) {
            zzbx.zza(this.zzFb, this.zzFh, "vff");
            zzbx.zza(this.zzFb, this.zzFa, "vtt");
            this.zzFi = zzbx.zzb(this.zzFb);
        }
        long l = zzr.zzbG().nanoTime();
        if (this.zzFj && this.zzFm && this.zzFn != -1L) {
            double d = (double)TimeUnit.SECONDS.toNanos(1L) / (double)(l - this.zzFn);
            this.zzFc.zza(d);
        }
        this.zzFm = this.zzFj;
        this.zzFn = l;
    }

    private void zzc(zzi zzi2) {
        long l = zzbt.zzvW.get();
        long l2 = zzi2.getCurrentPosition();
        for (int i = 0; i < this.zzFe.length; ++i) {
            long l3;
            if (this.zzFe[i] != null || l <= Math.abs(l2 - (l3 = this.zzFd[i]))) continue;
            this.zzFe[i] = this.zza((TextureView)zzi2);
            break;
        }
    }

    String zza(TextureView textureView) {
        Bitmap bitmap = textureView.getBitmap(8, 8);
        long l = 0L;
        long l2 = 63L;
        for (int i = 0; i < 8; ++i) {
            int n = 0;
            while (n < 8) {
                int n2 = bitmap.getPixel(n, i);
                int n3 = Color.blue((int)n2) + Color.red((int)n2) + Color.green((int)n2);
                long l3 = n3 > 128 ? 1L : 0L;
                l |= l3 << (int)l2;
                ++n;
                --l2;
            }
        }
        return String.format("%016X", l);
    }

    public void zzfO() {
        this.zzFj = true;
        if (this.zzFg != null && this.zzFh == null) {
            zzbx.zza(this.zzFb, this.zzFg, "vfp");
            this.zzFh = zzbx.zzb(this.zzFb);
        }
    }

    public void zzfP() {
        this.zzFj = false;
    }
}

