/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import com.google.android.gms.ads.internal.purchase.zzb;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzg;
import com.google.android.gms.ads.internal.purchase.zzh;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzir;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@zzhb
public class zzc
extends zzim
implements ServiceConnection {
    private final Object zzpV = new Object();
    private boolean zzFB = false;
    private Context mContext;
    private zzgh zzAK;
    private zzb zzFC;
    private zzh zzFD;
    private List<zzf> zzFE = null;
    private zzk zzFF;

    public zzc(Context context, zzgh zzgh2, zzk zzk2) {
        this(context, zzgh2, zzk2, new zzb(context), zzh.zzy(context.getApplicationContext()));
    }

    zzc(Context context, zzgh zzgh2, zzk zzk2, zzb zzb2, zzh zzh2) {
        this.mContext = context;
        this.zzAK = zzgh2;
        this.zzFF = zzk2;
        this.zzFC = zzb2;
        this.zzFD = zzh2;
        this.zzFE = this.zzFD.zzg(10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbr() {
        Object object = this.zzpV;
        synchronized (object) {
            Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
            intent.setPackage("com.android.vending");
            com.google.android.gms.common.stats.zzb.zzrP().zza(this.mContext, intent, (ServiceConnection)this, 1);
            this.zze(SystemClock.elapsedRealtime());
            com.google.android.gms.common.stats.zzb.zzrP().zza(this.mContext, (ServiceConnection)this);
            this.zzFC.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzpV;
        synchronized (object) {
            com.google.android.gms.common.stats.zzb.zzrP().zza(this.mContext, (ServiceConnection)this);
            this.zzFC.destroy();
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        zzin.zzaJ("In-app billing service disconnected.");
        this.zzFC.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName name, IBinder service) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzFC.zzN(service);
            this.zzfW();
            this.zzFB = true;
            this.zzpV.notify();
        }
    }

    protected void zzfW() {
        int n;
        Bundle bundle;
        if (this.zzFE.isEmpty()) {
            return;
        }
        HashMap<String, zzf> hashMap = new HashMap<String, zzf>();
        for (zzf object2 : this.zzFE) {
            hashMap.put(object2.zzFR, object2);
        }
        Object object3 = null;
        while ((bundle = this.zzFC.zzi(this.mContext.getPackageName(), (String)object3)) != null && (n = zzr.zzbM().zzd(bundle)) == 0) {
            ArrayList arrayList = bundle.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList2 = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList3 = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            object3 = bundle.getString("INAPP_CONTINUATION_TOKEN");
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!hashMap.containsKey(arrayList.get(i))) continue;
                String string2 = (String)arrayList.get(i);
                String string3 = (String)arrayList2.get(i);
                String string4 = (String)arrayList3.get(i);
                zzf zzf2 = (zzf)hashMap.get(string2);
                String string5 = zzr.zzbM().zzaq(string3);
                if (!zzf2.zzFQ.equals(string5)) continue;
                this.zza(zzf2, string3, string4);
                hashMap.remove(string2);
            }
            if (object3 != null && !hashMap.isEmpty()) continue;
        }
        for (String string6 : hashMap.keySet()) {
            this.zzFD.zza((zzf)hashMap.get(string6));
        }
    }

    protected void zza(final zzf zzf2, String string2, String string3) {
        final Intent intent = new Intent();
        zzr.zzbM();
        intent.putExtra("RESPONSE_CODE", 0);
        zzr.zzbM();
        intent.putExtra("INAPP_PURCHASE_DATA", string2);
        zzr.zzbM();
        intent.putExtra("INAPP_DATA_SIGNATURE", string3);
        zzir.zzMc.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (zzc.this.zzFF.zza(zzf2.zzFQ, -1, intent)) {
                        zzc.this.zzAK.zza(new zzg(zzc.this.mContext, zzf2.zzFR, true, -1, intent, zzf2));
                    } else {
                        zzc.this.zzAK.zza(new zzg(zzc.this.mContext, zzf2.zzFR, false, -1, intent, zzf2));
                    }
                }
                catch (RemoteException remoteException) {
                    zzin.zzaK("Fail to verify and dispatch pending transaction");
                }
            }
        });
    }

    private void zze(long l) {
        do {
            if (this.zzf(l)) continue;
            zzin.v("Timeout waiting for pending transaction to be processed.");
        } while (!this.zzFB);
    }

    private boolean zzf(long l) {
        long l2 = 60000L - (SystemClock.elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzpV.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            zzin.zzaK("waitWithTimeout_lock interrupted");
        }
        return true;
    }
}

