/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.request.zze;
import com.google.android.gms.ads.internal.request.zzg;
import com.google.android.gms.ads.internal.request.zzj;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.internal.zzbm;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhc;
import com.google.android.gms.internal.zzhd;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzit;
import com.google.android.gms.internal.zzji;

@zzhb
public abstract class zzd
implements zzc.zza,
zzit<Void> {
    private final zzji<AdRequestInfoParcel> zzHl;
    private final zzc.zza zzHm;
    private final Object zzpV = new Object();

    public zzd(zzji<AdRequestInfoParcel> zzji2, zzc.zza zza2) {
        this.zzHl = zzji2;
        this.zzHm = zza2;
    }

    public abstract void zzgr();

    public abstract zzj zzgs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzHm.zzb(adResponseParcel);
            this.zzgr();
        }
    }

    public Void zzga() {
        final zzj zzj2 = this.zzgs();
        if (zzj2 == null) {
            this.zzHm.zzb(new AdResponseParcel(0));
            this.zzgr();
            return null;
        }
        this.zzHl.zza(new zzji.zzc<AdRequestInfoParcel>(){

            public void zzc(AdRequestInfoParcel adRequestInfoParcel) {
                if (!zzd.this.zza(zzj2, adRequestInfoParcel)) {
                    zzd.this.zzgr();
                }
            }

            @Override
            public /* synthetic */ void zze(Object object) {
                this.zzc((AdRequestInfoParcel)object);
            }
        }, new zzji.zza(){

            @Override
            public void run() {
                zzd.this.zzgr();
            }
        });
        return null;
    }

    @Override
    public void cancel() {
        this.zzgr();
    }

    boolean zza(zzj zzj2, AdRequestInfoParcel adRequestInfoParcel) {
        try {
            zzj2.zza(adRequestInfoParcel, new zzg(this));
            return true;
        }
        catch (RemoteException remoteException) {
            zzin.zzd("Could not fetch ad response from ad request service.", remoteException);
            zzr.zzbF().zzb(remoteException, true);
        }
        catch (NullPointerException nullPointerException) {
            zzin.zzd("Could not fetch ad response from ad request service due to an Exception.", nullPointerException);
            zzr.zzbF().zzb(nullPointerException, true);
        }
        catch (SecurityException securityException) {
            zzin.zzd("Could not fetch ad response from ad request service due to an Exception.", securityException);
            zzr.zzbF().zzb(securityException, true);
        }
        catch (Throwable throwable) {
            zzin.zzd("Could not fetch ad response from ad request service due to an Exception.", throwable);
            zzr.zzbF().zzb(throwable, true);
        }
        this.zzHm.zzb(new AdResponseParcel(0));
        return false;
    }

    @Override
    public /* synthetic */ Object zzgd() {
        return this.zzga();
    }

    @zzhb
    public static class zzb
    extends zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private Context mContext;
        private VersionInfoParcel zzpT;
        private zzji<AdRequestInfoParcel> zzHl;
        private final zzc.zza zzHm;
        private final Object zzpV = new Object();
        protected zze zzHp;
        private boolean zzHq;

        public zzb(Context context, VersionInfoParcel versionInfoParcel, zzji<AdRequestInfoParcel> zzji2, zzc.zza zza2) {
            super(zzji2, zza2);
            Looper looper;
            this.mContext = context;
            this.zzpT = versionInfoParcel;
            this.zzHl = zzji2;
            this.zzHm = zza2;
            if (zzbt.zzwa.get().booleanValue()) {
                this.zzHq = true;
                looper = zzr.zzbO().zzhC();
            } else {
                looper = context.getMainLooper();
            }
            this.zzHp = new zze(context, looper, this, this, this.zzpT.zzNa);
            this.connect();
        }

        protected void connect() {
            this.zzHp.zzqG();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public zzj zzgs() {
            Object object = this.zzpV;
            synchronized (object) {
                try {
                    return this.zzHp.zzgw();
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzgr() {
            Object object = this.zzpV;
            synchronized (object) {
                if (this.zzHp.isConnected() || this.zzHp.isConnecting()) {
                    this.zzHp.disconnect();
                }
                Binder.flushPendingCommands();
                if (this.zzHq) {
                    zzr.zzbO().zzhD();
                    this.zzHq = false;
                }
            }
        }

        zzit zzgt() {
            return new zza(this.mContext, this.zzHl, this.zzHm);
        }

        public void onConnectionFailed(@NonNull ConnectionResult result) {
            zzin.zzaI("Cannot connect to remote service, fallback to local instance.");
            zzit zzit2 = this.zzgt();
            zzit2.zzgd();
            Bundle bundle = new Bundle();
            bundle.putString("action", "gms_connection_failed_fallback_to_local");
            zzr.zzbC().zzb(this.mContext, this.zzpT.afmaVersion, "gmob-apps", bundle, true);
        }

        public void onConnected(Bundle connectionHint) {
            this.zzga();
        }

        public void onConnectionSuspended(int cause) {
            zzin.zzaI("Disconnected from remote ad request service.");
        }

        @Override
        public /* synthetic */ Object zzgd() {
            return super.zzga();
        }
    }

    @zzhb
    public static final class zza
    extends zzd {
        private final Context mContext;

        public zza(Context context, zzji<AdRequestInfoParcel> zzji2, zzc.zza zza2) {
            super(zzji2, zza2);
            this.mContext = context;
        }

        @Override
        public zzj zzgs() {
            zzbm zzbm2 = new zzbm(zzbt.zzvB.get());
            return zzhd.zza(this.mContext, zzbm2, zzhc.zzgA());
        }

        @Override
        public void zzgr() {
        }

        @Override
        public /* synthetic */ Object zzgd() {
            return super.zzga();
        }
    }
}

