/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.internal.zzaj;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzao;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzdd;
import com.google.android.gms.internal.zzdf;
import com.google.android.gms.internal.zzdo;
import com.google.android.gms.internal.zzds;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzjp;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzhb
public final class zzde {
    public static final zzdf zzyX = new zzdf(){

        @Override
        public void zza(zzjp zzjp2, Map<String, String> map) {
        }
    };
    public static final zzdf zzyY = new zzdf(){

        @Override
        public void zza(zzjp zzjp2, Map<String, String> map) {
            String string2 = map.get("urls");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                zzin.zzaK("URLs missing in canOpenURLs GMSG.");
                return;
            }
            String[] stringArray = string2.split(",");
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            PackageManager packageManager = zzjp2.getContext().getPackageManager();
            for (String string3 : stringArray) {
                String[] stringArray2 = string3.split(";", 2);
                String string4 = stringArray2[0].trim();
                String string5 = stringArray2.length > 1 ? stringArray2[1].trim() : "android.intent.action.VIEW";
                Uri uri = Uri.parse((String)string4);
                Intent intent = new Intent(string5, uri);
                ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
                hashMap.put(string3, resolveInfo != null);
            }
            zzjp2.zza("openableURLs", hashMap);
        }
    };
    public static final zzdf zzyZ = new zzdf(){

        @Override
        public void zza(zzjp zzjp2, Map<String, String> map) {
            JSONArray jSONArray;
            JSONObject jSONObject;
            PackageManager packageManager = zzjp2.getContext().getPackageManager();
            String string2 = map.get("data");
            try {
                jSONObject = new JSONObject(string2);
            }
            catch (JSONException jSONException) {
                zzjp2.zzb("openableIntents", new JSONObject());
                return;
            }
            try {
                jSONArray = jSONObject.getJSONArray("intents");
            }
            catch (JSONException jSONException) {
                zzjp2.zzb("openableIntents", new JSONObject());
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (int i = 0; i < jSONArray.length(); ++i) {
                ResolveInfo resolveInfo;
                JSONObject jSONObject3;
                try {
                    jSONObject3 = jSONArray.getJSONObject(i);
                }
                catch (JSONException jSONException) {
                    zzin.zzb("Error parsing the intent data.", jSONException);
                    continue;
                }
                String string3 = jSONObject3.optString("id");
                String string4 = jSONObject3.optString("u");
                String string5 = jSONObject3.optString("i");
                String string6 = jSONObject3.optString("m");
                String string7 = jSONObject3.optString("p");
                String string8 = jSONObject3.optString("c");
                String string9 = jSONObject3.optString("f");
                String string10 = jSONObject3.optString("e");
                Intent intent = new Intent();
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    intent.setData(Uri.parse((String)string4));
                }
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    intent.setAction(string5);
                }
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    intent.setType(string6);
                }
                if (!TextUtils.isEmpty((CharSequence)string7)) {
                    intent.setPackage(string7);
                }
                if (!TextUtils.isEmpty((CharSequence)string8) && ((ResolveInfo)(resolveInfo = string8.split("/", 2))).length == 2) {
                    intent.setComponent(new ComponentName((String)resolveInfo[0], (String)resolveInfo[1]));
                }
                boolean bl = (resolveInfo = packageManager.resolveActivity(intent, 65536)) != null;
                try {
                    jSONObject2.put(string3, bl);
                    continue;
                }
                catch (JSONException jSONException) {
                    zzin.zzb("Error constructing openable urls response.", jSONException);
                }
            }
            zzjp2.zzb("openableIntents", jSONObject2);
        }
    };
    public static final zzdf zzza = new zzdf(){

        @Override
        public void zza(zzjp zzjp2, Map<String, String> map) {
            Object object;
            String string2 = map.get("u");
            if (string2 == null) {
                zzin.zzaK("URL missing from click GMSG.");
                return;
            }
            Uri uri = Uri.parse((String)string2);
            try {
                object = zzjp2.zzhW();
                if (object != null && ((zzan)object).zzb(uri)) {
                    uri = ((zzan)object).zza(uri, zzjp2.getContext());
                }
            }
            catch (zzao zzao2) {
                zzin.zzaK("Unable to append parameter to URL: " + string2);
            }
            string2 = uri.toString();
            object = new zziy(zzjp2.getContext(), zzjp2.zzhX().afmaVersion, string2);
            ((zzim)object).zzhn();
        }
    };
    public static final zzdf zzzb = new zzdf(){

        @Override
        public void zza(zzjp zzjp2, Map<String, String> map) {
            com.google.android.gms.ads.internal.overlay.zzd zzd2 = zzjp2.zzhS();
            if (zzd2 != null) {
                zzd2.close();
            } else {
                com.google.android.gms.ads.internal.overlay.zzd zzd3 = zzjp2.zzhT();
                if (zzd3 != null) {
                    zzd3.close();
                } else {
                    zzin.zzaK("A GMSG tried to close something that wasn't an overlay.");
                }
            }
        }
    };
    public static final zzdf zzzc = new zzdf(){

        private void zzc(zzjp zzjp2) {
            zzm zzm2;
            zzin.zzaJ("Received support message, responding.");
            boolean bl = false;
            zzd zzd2 = zzjp2.zzhR();
            if (zzd2 != null && (zzm2 = zzd2.zzpy) != null) {
                bl = zzm2.zzfM();
            }
            zzm2 = new JSONObject();
            try {
                zzm2.put("event", "checkSupport");
                zzm2.put("supports", bl);
                zzjp2.zzb("appStreaming", (JSONObject)zzm2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void zza(zzjp zzjp2, Map<String, String> map) {
            if ("checkSupport".equals(map.get("action"))) {
                this.zzc(zzjp2);
                return;
            }
            com.google.android.gms.ads.internal.overlay.zzd zzd2 = zzjp2.zzhS();
            if (zzd2 != null) {
                zzd2.zzg(zzjp2, map);
            }
        }
    };
    public static final zzdf zzzd = new zzdf(){

        @Override
        public void zza(zzjp zzjp2, Map<String, String> map) {
            zzjp2.zzE("1".equals(map.get("custom_close")));
        }
    };
    public static final zzdf zzze = new zzdf(){

        @Override
        public void zza(zzjp zzjp2, Map<String, String> map) {
            String string2 = map.get("u");
            if (string2 == null) {
                zzin.zzaK("URL missing from httpTrack GMSG.");
                return;
            }
            zziy zziy2 = new zziy(zzjp2.getContext(), zzjp2.zzhX().afmaVersion, string2);
            zziy2.zzhn();
        }
    };
    public static final zzdf zzzf = new zzdf(){

        @Override
        public void zza(zzjp zzjp2, Map<String, String> map) {
            zzin.zzaJ("Received log message: " + map.get("string"));
        }
    };
    public static final zzdf zzzg = new zzdf(){

        @Override
        public void zza(zzjp zzjp2, Map<String, String> map) {
            String string2 = map.get("tx");
            String string3 = map.get("ty");
            String string4 = map.get("td");
            try {
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(string3);
                int n3 = Integer.parseInt(string4);
                zzan zzan2 = zzjp2.zzhW();
                if (zzan2 != null) {
                    zzaj zzaj2 = zzan2.zzab();
                    zzaj2.zza(n, n2, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                zzin.zzaK("Could not parse touch parameters from gmsg.");
            }
        }
    };
    public static final zzdf zzzh = new zzdf(){

        @Override
        public void zza(zzjp zzjp2, Map<String, String> map) {
            if (!zzbt.zzwT.get().booleanValue()) {
                return;
            }
            String string2 = map.get("disabled");
            boolean bl = Boolean.parseBoolean(string2);
            zzjp2.zzF(!bl);
        }
    };
    public static final zzdf zzzi = new zzdo();
    public static final zzdf zzzj = new zzds();
    public static final zzdf zzzk = new zzdd();
}

