/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.internal.zzdf;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zziq;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzjp;
import java.io.BufferedOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzhb
public class zzdg
implements zzdf {
    private final Context mContext;
    private final VersionInfoParcel zzpT;

    public zzdg(Context context, VersionInfoParcel versionInfoParcel) {
        this.mContext = context;
        this.zzpT = versionInfoParcel;
    }

    protected zzb zzc(JSONObject jSONObject) {
        String string2 = jSONObject.optString("http_request_id");
        String string3 = jSONObject.optString("url");
        String string4 = jSONObject.optString("post_body", null);
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            zzin.zzb("Error constructing http request.", malformedURLException);
        }
        ArrayList<zza> arrayList = new ArrayList<zza>();
        JSONArray jSONArray = jSONObject.optJSONArray("headers");
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i);
            if (jSONObject2 == null) continue;
            String string5 = jSONObject2.optString("key");
            String string6 = jSONObject2.optString("value");
            arrayList.add(new zza(string5, string6));
        }
        return new zzb(string2, uRL, arrayList, string4);
    }

    protected JSONObject zza(zzd zzd2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("http_request_id", (Object)zzd2.zzdU());
            if (zzd2.getBody() != null) {
                jSONObject.put("body", (Object)zzd2.getBody());
            }
            JSONArray jSONArray = new JSONArray();
            for (zza zza2 : zzd2.zzdZ()) {
                jSONArray.put((Object)new JSONObject().put("key", (Object)zza2.getKey()).put("value", (Object)zza2.getValue()));
            }
            jSONObject.put("headers", (Object)jSONArray);
            jSONObject.put("response_code", zzd2.getResponseCode());
        }
        catch (JSONException jSONException) {
            zzin.zzb("Error constructing JSON for http response.", jSONException);
        }
        return jSONObject;
    }

    protected zzc zza(zzb zzb2) {
        try {
            Object object;
            HttpURLConnection httpURLConnection = (HttpURLConnection)zzb2.zzdV().openConnection();
            zzr.zzbC().zza(this.mContext, this.zzpT.afmaVersion, false, httpURLConnection);
            for (zza object22 : zzb2.zzdW()) {
                httpURLConnection.addRequestProperty(object22.getKey(), object22.getValue());
            }
            if (!TextUtils.isEmpty((CharSequence)zzb2.zzdX())) {
                httpURLConnection.setDoOutput(true);
                object = zzb2.zzdX().getBytes();
                httpURLConnection.setFixedLengthStreamingMode(((Object)object).length);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
                bufferedOutputStream.write((byte[])object);
                bufferedOutputStream.close();
            }
            object = new ArrayList();
            if (httpURLConnection.getHeaderFields() != null) {
                for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
                    for (String string2 : entry.getValue()) {
                        ((ArrayList)object).add(new zza(entry.getKey(), string2));
                    }
                }
            }
            zzd zzd2 = new zzd(zzb2.zzdU(), httpURLConnection.getResponseCode(), (List<zza>)object, zzr.zzbC().zza(new InputStreamReader(httpURLConnection.getInputStream())));
            return new zzc(true, zzd2, null);
        }
        catch (Exception exception) {
            return new zzc(false, null, exception.toString());
        }
    }

    public JSONObject zzQ(String string2) {
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            zzin.e("The request is not a valid JSON.");
            try {
                return new JSONObject().put("success", false);
            }
            catch (JSONException jSONException2) {
                return new JSONObject();
            }
        }
        JSONObject jSONObject2 = new JSONObject();
        String string3 = "";
        try {
            string3 = jSONObject.optString("http_request_id");
            zzb zzb2 = this.zzc(jSONObject);
            zzc zzc2 = this.zza(zzb2);
            if (zzc2.isSuccess()) {
                JSONObject jSONObject3 = this.zza(zzc2.zzdY());
                jSONObject2.put("response", (Object)jSONObject3);
                jSONObject2.put("success", true);
            } else {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)zzc2.getReason());
            }
        }
        catch (Exception exception) {
            try {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)exception.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return jSONObject2;
    }

    @Override
    public void zza(final zzjp zzjp2, final Map<String, String> map) {
        zziq.zza(new Runnable(){

            @Override
            public void run() {
                zzin.zzaI("Received Http request.");
                String string2 = (String)map.get("http_request");
                final JSONObject jSONObject = zzdg.this.zzQ(string2);
                if (jSONObject == null) {
                    zzin.e("Response should not be null.");
                    return;
                }
                zzir.zzMc.post(new Runnable(){

                    @Override
                    public void run() {
                        zzjp2.zzb("fetchHttpRequestCompleted", jSONObject);
                        zzin.zzaI("Dispatched http response.");
                    }
                });
            }
        });
    }

    @zzhb
    class zzc {
        private final zzd zzzt;
        private final boolean zzzu;
        private final String zzzv;

        public zzc(boolean bl, zzd zzd2, String string2) {
            this.zzzu = bl;
            this.zzzt = zzd2;
            this.zzzv = string2;
        }

        public String getReason() {
            return this.zzzv;
        }

        public zzd zzdY() {
            return this.zzzt;
        }

        public boolean isSuccess() {
            return this.zzzu;
        }
    }

    @zzhb
    static class zzd {
        private final String zzzp;
        private final int zzzw;
        private final List<zza> zzzx;
        private final String zzxY;

        public zzd(String string2, int n, List<zza> list, String string3) {
            this.zzzp = string2;
            this.zzzw = n;
            this.zzzx = list == null ? new ArrayList<zza>() : list;
            this.zzxY = string3;
        }

        public String zzdU() {
            return this.zzzp;
        }

        public int getResponseCode() {
            return this.zzzw;
        }

        public Iterable<zza> zzdZ() {
            return this.zzzx;
        }

        public String getBody() {
            return this.zzxY;
        }
    }

    @zzhb
    static class zzb {
        private final String zzzp;
        private final URL zzzq;
        private final ArrayList<zza> zzzr;
        private final String zzzs;

        public zzb(String string2, URL uRL, ArrayList<zza> arrayList, String string3) {
            this.zzzp = string2;
            this.zzzq = uRL;
            this.zzzr = arrayList == null ? new ArrayList() : arrayList;
            this.zzzs = string3;
        }

        public String zzdU() {
            return this.zzzp;
        }

        public URL zzdV() {
            return this.zzzq;
        }

        public ArrayList<zza> zzdW() {
            return this.zzzr;
        }

        public String zzdX() {
            return this.zzzs;
        }
    }

    @zzhb
    static class zza {
        private final String zzvs;
        private final String mValue;

        public zza(String string2, String string3) {
            this.zzvs = string2;
            this.mValue = string3;
        }

        public String getKey() {
            return this.zzvs;
        }

        public String getValue() {
            return this.mValue;
        }
    }
}

