/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzw;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzka;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzig
@TargetApi(value=14)
public class zzc
extends zzi
implements AudioManager.OnAudioFocusChangeListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzGK = new HashMap<Integer, String>();
    private final zzx zzGL;
    private final boolean zzGM;
    private int zzGN = 0;
    private int zzGO = 0;
    private MediaPlayer zzGP;
    private Uri zzGQ;
    private int zzGR;
    private int zzGS;
    private int zzGT;
    private int zzGU;
    private int zzGV;
    private float zzGW = 1.0f;
    private boolean zzGX;
    private boolean zzGY;
    private zzw zzGZ;
    private boolean zzHa;
    private int zzHb;
    private zzh zzHc;

    public zzc(Context context, boolean bl, boolean bl2, zzx zzx2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzGL = zzx2;
        this.zzHa = bl;
        this.zzGM = bl2;
        this.zzGL.zza(this);
    }

    @Override
    public String zzgc() {
        String string = String.valueOf(this.zzHa ? " spherical" : "");
        return string.length() != 0 ? "MediaPlayer".concat(string) : new String("MediaPlayer");
    }

    @Override
    public void zza(zzh zzh2) {
        this.zzHc = zzh2;
    }

    @Override
    public void setMimeType(String string) {
    }

    @Override
    public void setVideoPath(String string) {
        this.setVideoURI(Uri.parse((String)string));
    }

    public void setVideoURI(Uri uri) {
        this.zzGQ = uri;
        this.zzHb = 0;
        this.zzgd();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void stop() {
        zzjw.v("AdMediaPlayerView stop");
        if (this.zzGP != null) {
            this.zzGP.stop();
            this.zzGP.release();
            this.zzGP = null;
            this.zzB(0);
            this.zzC(0);
            this.zzgg();
        }
        this.zzGL.onStop();
    }

    public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzjw.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzGR = mediaPlayer.getVideoWidth();
        this.zzGS = mediaPlayer.getVideoHeight();
        if (this.zzGR != 0 && this.zzGS != 0) {
            this.requestLayout();
        }
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        zzjw.v("AdMediaPlayerView prepared");
        this.zzB(2);
        this.zzGL.zzgD();
        zzka.zzQu.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzHc != null) {
                    zzc.this.zzHc.zzgD();
                }
            }
        });
        this.zzGR = mediaPlayer.getVideoWidth();
        this.zzGS = mediaPlayer.getVideoHeight();
        if (this.zzHb != 0) {
            this.seekTo(this.zzHb);
        }
        this.zzge();
        int n = this.zzGR;
        int n2 = this.zzGS;
        zzjw.zzaV((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzGO == 3) {
            this.play();
        }
        this.zzgf();
        this.zzgm();
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        zzjw.v("AdMediaPlayerView completion");
        this.zzB(5);
        this.zzC(5);
        zzka.zzQu.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzHc != null) {
                    zzc.this.zzHc.zzgF();
                }
            }
        });
    }

    public boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzGK.get(n);
        String string2 = zzGK.get(n2);
        zzjw.v(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string).append(":").append(string2).toString());
        return true;
    }

    public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        final String string = zzGK.get(n);
        final String string2 = zzGK.get(n2);
        zzjw.zzaW((String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string).append(":").append(string2).toString());
        this.zzB(-1);
        this.zzC(-1);
        zzka.zzQu.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzHc != null) {
                    zzc.this.zzHc.zzj(string, string2);
                }
            }
        });
        return true;
    }

    public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzGT = n;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzjw.v("AdMediaPlayerView surface created");
        this.zzgd();
        zzka.zzQu.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzHc != null) {
                    zzc.this.zzHc.zzgC();
                }
            }
        });
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzjw.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzGO == 3;
        boolean bl3 = bl = this.zzGR == n && this.zzGS == n2;
        if (this.zzGP != null && bl2 && bl) {
            if (this.zzHb != 0) {
                this.seekTo(this.zzHb);
            }
            this.play();
        }
        if (this.zzGZ != null) {
            this.zzGZ.zzg(n, n2);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzjw.v("AdMediaPlayerView surface destroyed");
        if (this.zzGP != null && this.zzHb == 0) {
            this.zzHb = this.zzGP.getCurrentPosition();
        }
        if (this.zzGZ != null) {
            this.zzGZ.zzgR();
        }
        zzka.zzQu.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzHc != null) {
                    zzc.this.zzHc.onPaused();
                    zzc.this.zzHc.zzgG();
                }
            }
        });
        this.zzx(true);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzGL.zzb(this);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = zzc.getDefaultSize((int)this.zzGR, (int)n);
        int n4 = zzc.getDefaultSize((int)this.zzGS, (int)n2);
        if (this.zzGR > 0 && this.zzGS > 0 && this.zzGZ == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzGR * n4 < n3 * this.zzGS) {
                    n3 = n4 * this.zzGR / this.zzGS;
                } else if (this.zzGR * n4 > n3 * this.zzGS) {
                    n4 = n3 * this.zzGS / this.zzGR;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzGS / this.zzGR;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzGR / this.zzGS;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzGR;
                n4 = this.zzGS;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzGR / this.zzGS;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzGS / this.zzGR;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzGZ != null) {
            this.zzGZ.zzg(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzGU > 0 && this.zzGU != n3 || this.zzGV > 0 && this.zzGV != n4) {
                this.zzge();
            }
            this.zzGU = n3;
            this.zzGV = n4;
        }
    }

    public String toString() {
        String string = String.valueOf(((Object)((Object)this)).getClass().getName());
        String string2 = String.valueOf(Integer.toHexString(((Object)((Object)this)).hashCode()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("@").append(string2).toString();
    }

    private void zzgd() {
        zzjw.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzGQ == null || surfaceTexture == null) {
            return;
        }
        this.zzx(false);
        try {
            Surface surface;
            this.zzGP = zzu.zzcx().zzgQ();
            this.zzGP.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzGP.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzGP.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzGP.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzGP.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzGP.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzGT = 0;
            if (this.zzHa) {
                this.zzGZ = new zzw(this.getContext());
                this.zzGZ.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzGZ.start();
                surface = this.zzGZ.zzgS();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzGZ.zzgR();
                    this.zzGZ = null;
                }
            }
            this.zzGP.setDataSource(this.getContext(), this.zzGQ);
            surface = zzu.zzcy().zza(surfaceTexture);
            this.zzGP.setSurface(surface);
            this.zzGP.setAudioStreamType(3);
            this.zzGP.setScreenOnWhilePlaying(true);
            this.zzGP.prepareAsync();
            this.zzB(1);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string = String.valueOf(this.zzGQ);
            zzjw.zzd((String)new StringBuilder(36 + String.valueOf(string).length()).append("Failed to initialize MediaPlayer at ").append(string).toString(), (Throwable)exception);
            this.onError(this.zzGP, 1, 0);
        }
    }

    private void zzge() {
        if (!this.zzGM) {
            return;
        }
        if (this.zzgh() && this.zzGP.getCurrentPosition() > 0 && this.zzGO != 3) {
            long l;
            zzjw.v("AdMediaPlayerView nudging MediaPlayer");
            this.zzb(0.0f);
            this.zzGP.start();
            int n = this.zzGP.getCurrentPosition();
            long l2 = zzu.zzco().currentTimeMillis();
            while (this.zzgh() && this.zzGP.getCurrentPosition() == n && (l = zzu.zzco().currentTimeMillis()) - l2 <= 250L) {
            }
            this.zzGP.pause();
            this.zzgm();
        }
    }

    private void zzgf() {
        AudioManager audioManager = this.zzgn();
        if (audioManager != null && !this.zzGY) {
            int n = audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 2);
            if (n == 1) {
                this.zzgk();
            } else {
                zzjw.zzaW((String)"AdMediaPlayerView audio focus request failed");
            }
        }
    }

    private void zzgg() {
        zzjw.v("AdMediaPlayerView abandon audio focus");
        AudioManager audioManager = this.zzgn();
        if (audioManager != null && this.zzGY) {
            int n = audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
            if (n == 1) {
                this.zzGY = false;
            } else {
                zzjw.zzaW((String)"AdMediaPlayerView abandon audio focus failed");
            }
        }
    }

    private void zzx(boolean bl) {
        zzjw.v("AdMediaPlayerView release");
        if (this.zzGZ != null) {
            this.zzGZ.zzgR();
            this.zzGZ = null;
        }
        if (this.zzGP != null) {
            this.zzGP.reset();
            this.zzGP.release();
            this.zzGP = null;
            this.zzB(0);
            if (bl) {
                this.zzGO = 0;
                this.zzC(0);
            }
            this.zzgg();
        }
    }

    @Override
    public void play() {
        zzjw.v("AdMediaPlayerView play");
        if (this.zzgh()) {
            this.zzGP.start();
            this.zzB(3);
            zzka.zzQu.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzHc != null) {
                        zzc.this.zzHc.zzgE();
                    }
                }
            });
        }
        this.zzC(3);
    }

    @Override
    public void pause() {
        zzjw.v("AdMediaPlayerView pause");
        if (this.zzgh() && this.zzGP.isPlaying()) {
            this.zzGP.pause();
            this.zzB(4);
            zzka.zzQu.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzHc != null) {
                        zzc.this.zzHc.onPaused();
                    }
                }
            });
        }
        this.zzC(4);
    }

    @Override
    public int getDuration() {
        if (this.zzgh()) {
            return this.zzGP.getDuration();
        }
        return -1;
    }

    @Override
    public int getCurrentPosition() {
        if (this.zzgh()) {
            return this.zzGP.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public void seekTo(int n) {
        zzjw.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzgh()) {
            this.zzGP.seekTo(n);
            this.zzHb = 0;
        } else {
            this.zzHb = n;
        }
    }

    private boolean zzgh() {
        return this.zzGP != null && this.zzGN != -1 && this.zzGN != 0 && this.zzGN != 1;
    }

    public void onAudioFocusChange(int n) {
        if (n > 0) {
            this.zzgk();
        } else if (n < 0) {
            this.zzgl();
        }
    }

    @Override
    public void zzgi() {
        this.zzGX = true;
        this.zzgm();
    }

    @Override
    public void zzgj() {
        this.zzGX = false;
        this.zzgm();
    }

    @Override
    public void zza(float f) {
        this.zzGW = f;
        this.zzgm();
    }

    @Override
    public void zza(float f, float f2) {
        if (this.zzGZ != null) {
            this.zzGZ.zzb(f, f2);
        }
    }

    @Override
    public int getVideoWidth() {
        if (this.zzGP != null) {
            return this.zzGP.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.zzGP != null) {
            return this.zzGP.getVideoHeight();
        }
        return 0;
    }

    private void zzgk() {
        zzjw.v("AdMediaPlayerView audio focus gained");
        this.zzGY = true;
        this.zzgm();
    }

    private void zzgl() {
        zzjw.v("AdMediaPlayerView audio focus lost");
        this.zzGY = false;
        this.zzgm();
    }

    private void zzgm() {
        if (!this.zzGX && this.zzGY) {
            this.zzb(this.zzGW);
        } else {
            this.zzb(0.0f);
        }
    }

    private void zzb(float f) {
        if (this.zzGP != null) {
            try {
                this.zzGP.setVolume(f, f);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            zzjw.zzaW((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
        }
    }

    private AudioManager zzgn() {
        Context context = this.getContext();
        return (AudioManager)context.getSystemService("audio");
    }

    private void zzB(int n) {
        if (n == 3) {
            this.zzGL.zzhd();
        } else if (this.zzGN == 3) {
            this.zzGL.zzhe();
        }
        this.zzGN = n;
    }

    private void zzC(int n) {
        this.zzGO = n;
    }

    static {
        zzGK.put(-1004, "MEDIA_ERROR_IO");
        zzGK.put(-1007, "MEDIA_ERROR_MALFORMED");
        zzGK.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
        zzGK.put(-110, "MEDIA_ERROR_TIMED_OUT");
        zzGK.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzGK.put(1, "MEDIA_ERROR_UNKNOWN");
        zzGK.put(1, "MEDIA_INFO_UNKNOWN");
        zzGK.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzGK.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        zzGK.put(701, "MEDIA_INFO_BUFFERING_START");
        zzGK.put(702, "MEDIA_INFO_BUFFERING_END");
        zzGK.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzGK.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzGK.put(802, "MEDIA_INFO_METADATA_UPDATE");
        zzGK.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
        zzGK.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
    }
}

