/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzs;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzgz;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzlb;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Future;

@zzig
public class zzd
extends zzgz.zza
implements com.google.android.gms.ads.internal.overlay.zzu {
    static final int zzHg = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzHh;
    zzla zzBb;
    zzc zzHi;
    zzo zzHj;
    boolean zzHk = false;
    FrameLayout zzHl;
    WebChromeClient.CustomViewCallback zzHm;
    boolean zzHn = false;
    boolean zzHo = false;
    zzb zzHp;
    boolean zzHq = false;
    int zzHr = 0;
    zzl zzHs;
    private boolean zzHt;
    private boolean zzHu = false;
    private boolean zzHv = true;

    public zzd(Activity activity) {
        this.mActivity = activity;
        this.zzHs = new zzs();
    }

    public void close() {
        this.zzHr = 2;
        this.mActivity.finish();
    }

    public void zzgo() {
        if (this.zzHh != null && this.zzHk) {
            this.setRequestedOrientation(this.zzHh.orientation);
        }
        if (this.zzHl != null) {
            this.mActivity.setContentView((View)this.zzHp);
            this.zzaW();
            this.zzHl.removeAllViews();
            this.zzHl = null;
        }
        if (this.zzHm != null) {
            this.zzHm.onCustomViewHidden();
            this.zzHm = null;
        }
        this.zzHk = false;
    }

    @Override
    public void zzgp() {
        this.zzHr = 1;
        this.mActivity.finish();
    }

    public void onBackPressed() {
        this.zzHr = 0;
    }

    public boolean zzgq() {
        boolean bl;
        this.zzHr = 0;
        if (this.zzBb == null) {
            return true;
        }
        boolean bl2 = bl = this.zzBb.zzgO() && this.zzHs.zzgO();
        if (!bl) {
            this.zzBb.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzHn = bundle != null ? bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzHh = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzHh == null) {
                throw new zza("Could not get info for ad overlay.");
            }
            if (this.zzHh.zzsx.zzRD > 7500000) {
                this.zzHr = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzHv = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzHo = this.zzHh.zzHO != null ? this.zzHh.zzHO.zzrf : false;
            if (zzcu.zzyZ.get().booleanValue() && this.zzHo && this.zzHh.zzHO.zzrk != -1) {
                Future cfr_ignored_0 = (Future)new zzd().zzhs();
            }
            if (bundle == null) {
                if (this.zzHh.zzHE != null && this.zzHv) {
                    this.zzHh.zzHE.zzbt();
                }
                if (this.zzHh.zzHL != 1 && this.zzHh.zzHD != null) {
                    this.zzHh.zzHD.onAdClicked();
                }
            }
            this.zzHp = new zzb((Context)this.mActivity, this.zzHh.zzHN);
            this.zzHp.setId(1000);
            switch (this.zzHh.zzHL) {
                case 1: {
                    this.zzz(false);
                    break;
                }
                case 2: {
                    this.zzHi = new zzc(this.zzHh.zzHF);
                    this.zzz(false);
                    break;
                }
                case 3: {
                    this.zzz(true);
                    break;
                }
                case 4: {
                    if (this.zzHn) {
                        this.zzHr = 3;
                        this.mActivity.finish();
                        break;
                    }
                    if (!zzu.zzch().zza((Context)this.mActivity, this.zzHh.zzHC, this.zzHh.zzHK)) {
                        this.zzHr = 3;
                        this.mActivity.finish();
                    }
                    break;
                }
                default: {
                    throw new zza("Could not determine ad overlay type.");
                }
            }
        }
        catch (zza zza2) {
            zzjw.zzaW((String)zza2.getMessage());
            this.zzHr = 3;
            this.mActivity.finish();
        }
    }

    public void onRestart() {
    }

    public void onStart() {
    }

    public void onResume() {
        if (this.zzHh != null && this.zzHh.zzHL == 4) {
            if (this.zzHn) {
                this.zzHr = 3;
                this.mActivity.finish();
            } else {
                this.zzHn = true;
            }
        }
        if (this.zzHh.zzHE != null) {
            this.zzHh.zzHE.onResume();
        }
        if (this.zzBb != null && !this.zzBb.isDestroyed()) {
            zzu.zzcm().zzj(this.zzBb);
        } else {
            zzjw.zzaW((String)"The webview does not exit. Ignoring action.");
        }
        this.zzHs.resume();
    }

    public void onPause() {
        this.zzHs.pause();
        this.zzgo();
        if (this.zzHh.zzHE != null) {
            this.zzHh.zzHE.onPause();
        }
        if (!(this.zzBb == null || this.mActivity.isFinishing() && this.zzHi != null)) {
            zzu.zzcm().zzi(this.zzBb);
        }
        this.zzgs();
    }

    public void onActivityResult(int n, int n2, Intent intent) {
    }

    public void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzHn);
    }

    public void onStop() {
        this.zzgs();
    }

    public void onDestroy() {
        if (this.zzBb != null) {
            this.zzHp.removeView(this.zzBb.getView());
        }
        this.zzgs();
    }

    public void zzy(boolean bl) {
        int n = bl ? 50 : 32;
        this.zzHj = new zzo((Context)this.mActivity, n, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zzHj.zza(bl, this.zzHh.zzHI);
        this.zzHp.addView((View)this.zzHj, (ViewGroup.LayoutParams)layoutParams);
    }

    public void zzaW() {
        this.zzHt = true;
    }

    public void zza(boolean bl, boolean bl2) {
        if (this.zzHj != null) {
            this.zzHj.zza(bl, bl2);
        }
    }

    public void zzgr() {
        this.zzHp.removeView((View)this.zzHj);
        this.zzy(true);
    }

    public void setRequestedOrientation(int n) {
        this.mActivity.setRequestedOrientation(n);
    }

    public void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzHl = new FrameLayout((Context)this.mActivity);
        this.zzHl.setBackgroundColor(-16777216);
        this.zzHl.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzHl);
        this.zzaW();
        this.zzHm = customViewCallback;
        this.zzHk = true;
    }

    protected void zzz(boolean bl) throws zza {
        com.google.android.gms.ads.internal.zzd zzd2;
        zzm zzm2;
        Window window;
        if (!this.zzHt) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zza("Invalid activity, no window available.");
        }
        if (!this.zzHo || this.zzHh.zzHO != null && this.zzHh.zzHO.zzrg) {
            window.setFlags(1024, 1024);
        }
        boolean bl2 = this.zzHh.zzHF.zzjD().zzdi();
        this.zzHq = false;
        if (bl2) {
            if (this.zzHh.orientation == zzu.zzcm().zzje()) {
                this.zzHq = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzHh.orientation == zzu.zzcm().zzjf()) {
                this.zzHq = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        boolean bl3 = this.zzHq;
        zzjw.zzaU((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl3).toString());
        this.setRequestedOrientation(this.zzHh.orientation);
        if (zzu.zzcm().zza(window)) {
            zzjw.zzaU((String)"Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzHo) {
            this.zzHp.setBackgroundColor(-16777216);
        } else {
            this.zzHp.setBackgroundColor(zzHg);
        }
        this.mActivity.setContentView((View)this.zzHp);
        this.zzaW();
        if (bl) {
            this.zzBb = zzu.zzcl().zza((Context)this.mActivity, this.zzHh.zzHF.zzbi(), true, bl2, null, this.zzHh.zzsx, null, null, this.zzHh.zzHF.zzjA());
            this.zzBb.zzjD().zza(null, null, this.zzHh.zzHG, this.zzHh.zzHK, true, this.zzHh.zzHM, null, this.zzHh.zzHF.zzjD().zzjR(), null, null);
            this.zzBb.zzjD().zza(new zzlb.zza(){

                @Override
                public void zza(zzla zzla2, boolean bl) {
                    zzla2.zzgu();
                }
            });
            if (this.zzHh.url != null) {
                this.zzBb.loadUrl(this.zzHh.url);
            } else if (this.zzHh.zzHJ != null) {
                this.zzBb.loadDataWithBaseURL(this.zzHh.zzHH, this.zzHh.zzHJ, "text/html", "UTF-8", null);
            } else {
                throw new zza("No URL or HTML to display in ad overlay.");
            }
            if (this.zzHh.zzHF != null) {
                this.zzHh.zzHF.zzc(this);
            }
        } else {
            this.zzBb = this.zzHh.zzHF;
            this.zzBb.setContext((Context)this.mActivity);
        }
        this.zzBb.zzb(this);
        ViewParent viewParent = this.zzBb.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzBb.getView());
        }
        if (this.zzHo) {
            this.zzBb.setBackgroundColor(zzHg);
        }
        this.zzHp.addView(this.zzBb.getView(), -1, -1);
        if (!bl && !this.zzHq) {
            this.zzgu();
        }
        this.zzy(bl2);
        if (this.zzBb.zzjE()) {
            this.zza(bl2, true);
        }
        zzm zzm3 = zzm2 = (zzd2 = this.zzBb.zzjA()) != null ? zzd2.zzqo : null;
        if (zzm2 != null) {
            this.zzHs = zzm2.zza(this.mActivity, this.zzBb, this.zzHp);
        } else {
            zzjw.zzaW((String)"Appstreaming controller is null.");
        }
    }

    protected void zzgs() {
        if (!this.mActivity.isFinishing() || this.zzHu) {
            return;
        }
        this.zzHu = true;
        if (this.zzBb != null) {
            this.zzD(this.zzHr);
            this.zzHp.removeView(this.zzBb.getView());
            if (this.zzHi != null) {
                this.zzBb.setContext(this.zzHi.zzov);
                this.zzBb.zzG(false);
                this.zzHi.zzHz.addView(this.zzBb.getView(), this.zzHi.index, this.zzHi.zzHy);
                this.zzHi = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzBb.setContext(this.mActivity.getApplicationContext());
            }
            this.zzBb = null;
        }
        if (this.zzHh != null && this.zzHh.zzHE != null) {
            this.zzHh.zzHE.zzbs();
        }
        this.zzHs.destroy();
    }

    public void zzgt() {
        if (this.zzHq) {
            this.zzHq = false;
            this.zzgu();
        }
    }

    protected void zzgu() {
        this.zzBb.zzgu();
    }

    protected void zzD(int n) {
        this.zzBb.zzD(n);
    }

    public void zzf(zzla zzla2, Map<String, String> map) {
        this.zzHs.zzf(zzla2, map);
    }

    public void zzgv() {
        this.zzHp.disable();
    }

    @zzig
    private class zzd
    extends zzjv {
        private zzd() {
        }

        @Override
        public void zzbQ() {
            Bitmap bitmap = zzu.zzcB().zza(zzd.this.zzHh.zzHO.zzrk);
            if (bitmap != null) {
                final Drawable drawable = zzu.zzcm().zza((Context)zzd.this.mActivity, bitmap, zzd.this.zzHh.zzHO.zzri, zzd.this.zzHh.zzHO.zzrj);
                zzka.zzQu.post(new Runnable(){

                    @Override
                    public void run() {
                        zzd.this.mActivity.getWindow().setBackgroundDrawable(drawable);
                    }
                });
            }
        }

        @Override
        public void onStop() {
        }
    }

    @zzig
    static class zzb
    extends RelativeLayout {
        zzkd zztg;
        boolean zzHx;

        public zzb(Context context, String string) {
            super(context);
            this.zztg = new zzkd(context, string);
        }

        public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
            if (!this.zzHx) {
                this.zztg.zze(motionEvent);
            }
            return false;
        }

        void disable() {
            this.zzHx = true;
        }
    }

    @zzig
    public static class zzc {
        public final int index;
        public final ViewGroup.LayoutParams zzHy;
        public final ViewGroup zzHz;
        public final Context zzov;

        public zzc(zzla zzla2) throws zza {
            this.zzHy = zzla2.getLayoutParams();
            ViewParent viewParent = zzla2.getParent();
            this.zzov = zzla2.zzjz();
            if (viewParent == null || !(viewParent instanceof ViewGroup)) {
                throw new zza("Could not get the parent of the WebView for an overlay.");
            }
            this.zzHz = (ViewGroup)viewParent;
            this.index = this.zzHz.indexOfChild(zzla2.getView());
            this.zzHz.removeView(zzla2.getView());
            zzla2.zzG(true);
        }
    }

    @zzig
    private static final class zza
    extends Exception {
        public zza(String string) {
            super(string);
        }
    }
}

