/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.webkit.CookieManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzal;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzfr;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzkc;
import com.google.android.gms.internal.zzkt;
import com.google.android.gms.internal.zzku;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
public class zzb
extends zzjv
implements zzc.zza {
    private final zza.zza zzKV;
    private final AdRequestInfoParcel.zza zzKW;
    private final Object zzJM = new Object();
    private final Context mContext;
    private final zzaq zzAZ;
    private AdRequestInfoParcel zzFm;
    private Runnable zzJL;
    zzkc zzKX;
    AdResponseParcel zzJK;
    zzfr zzEX;

    public zzb(Context context, AdRequestInfoParcel.zza zza2, zzaq zzaq2, zza.zza zza3) {
        this.zzKV = zza3;
        this.mContext = context;
        this.zzKW = zza2;
        this.zzAZ = zzaq2;
    }

    zzkc zza(VersionInfoParcel versionInfoParcel, zzkt<AdRequestInfoParcel> zzkt2) {
        return zzc.zza(this.mContext, versionInfoParcel, zzkt2, this);
    }

    @Override
    public void zzbQ() {
        zzjw.zzaU((String)"AdLoaderBackgroundTask started.");
        this.zzJL = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzb.this.zzJM;
                synchronized (object) {
                    if (zzb.this.zzKX == null) {
                        return;
                    }
                    zzb.this.onStop();
                    zzb.this.zzd(2, "Timed out waiting for ad response.");
                }
            }
        };
        zzka.zzQu.postDelayed(this.zzJL, zzcu.zzyH.get().longValue());
        final zzku<AdRequestInfoParcel> zzku2 = new zzku<AdRequestInfoParcel>();
        long l = zzu.zzco().elapsedRealtime();
        zzjz.zza(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzb.this.zzJM;
                synchronized (object) {
                    zzb.this.zzKX = zzb.this.zza(((zzb)zzb.this).zzKW.zzsx, zzku2);
                    if (zzb.this.zzKX == null) {
                        zzb.this.zzd(0, "Could not start the ad request service.");
                        zzka.zzQu.removeCallbacks(zzb.this.zzJL);
                    }
                }
            }
        });
        zzal zzal2 = this.zzAZ.zzW();
        String string = zzal2.zzb(this.mContext);
        this.zzFm = new AdRequestInfoParcel(this.zzKW, string, l);
        zzku2.zzf(this.zzFm);
    }

    private void zzd(int n, String string) {
        if (n == 3 || n == -1) {
            zzjw.zzaV((String)string);
        } else {
            zzjw.zzaW((String)string);
        }
        this.zzJK = this.zzJK == null ? new AdResponseParcel(n) : new AdResponseParcel(n, this.zzJK.zzEL);
        AdRequestInfoParcel adRequestInfoParcel = this.zzFm != null ? this.zzFm : new AdRequestInfoParcel(this.zzKW, null, -1L);
        zzjn.zza zza2 = new zzjn.zza(adRequestInfoParcel, this.zzJK, this.zzEX, null, n, -1L, this.zzJK.zzLT, null);
        this.zzKV.zza(zza2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(@NonNull AdResponseParcel adResponseParcel) {
        zzjw.zzaU((String)"Received ad response.");
        this.zzJK = adResponseParcel;
        long l = zzu.zzco().elapsedRealtime();
        Object object = this.zzJM;
        synchronized (object) {
            this.zzKX = null;
        }
        zzu.zzcn().zzd(this.mContext, this.zzJK.zzLH);
        object = null;
        try {
            if (this.zzJK.errorCode != -2 && this.zzJK.errorCode != -3) {
                int n = this.zzJK.errorCode;
                throw new zza(new StringBuilder(66).append("There was a problem getting an ad response. ErrorCode: ").append(n).toString(), this.zzJK.errorCode);
            }
            this.zzhP();
            if (this.zzFm.zzsB.zzvu != null) {
                object = this.zzb(this.zzFm);
            }
        }
        catch (zza zza2) {
            this.zzd(zza2.getErrorCode(), zza2.getMessage());
            zzka.zzQu.removeCallbacks(this.zzJL);
            return;
        }
        zzu.zzcn().zzD(this.zzJK.zzLZ);
        JSONObject jSONObject = null;
        if (!TextUtils.isEmpty((CharSequence)this.zzJK.zzLX)) {
            try {
                jSONObject = new JSONObject(this.zzJK.zzLX);
            }
            catch (Exception exception) {
                zzjw.zzb((String)"Error parsing the JSON for Active View.", (Throwable)exception);
            }
        }
        zzjn.zza zza3 = new zzjn.zza(this.zzFm, this.zzJK, this.zzEX, (AdSizeParcel)object, -2, l, this.zzJK.zzLT, jSONObject);
        this.zzKV.zza(zza3);
        zzka.zzQu.removeCallbacks(this.zzJL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzJM;
        synchronized (object) {
            if (this.zzKX != null) {
                this.zzKX.cancel();
            }
        }
    }

    protected void zzhP() throws zza {
        if (this.zzJK.errorCode == -3) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzJK.body)) {
            throw new zza("No fill from ad server.", 3);
        }
        zzu.zzcn().zzc(this.mContext, this.zzJK.zzLq);
        if (this.zzJK.zzLP) {
            try {
                this.zzEX = new zzfr(this.zzJK.body);
                zzu.zzcn().zzE(this.zzEX.zzEJ);
            }
            catch (JSONException jSONException) {
                zzjw.zzb((String)"Could not parse mediation config.", (Throwable)jSONException);
                String string = String.valueOf(this.zzJK.body);
                throw new zza(string.length() != 0 ? "Could not parse mediation config: ".concat(string) : new String("Could not parse mediation config: "), 0);
            }
        } else {
            zzu.zzcn().zzE(this.zzJK.zzEJ);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzJK.zzLI) && zzcu.zzzK.get().booleanValue()) {
            zzjw.zzaU((String)"Received cookie from server. Setting webview cookie in CookieManager.");
            CookieManager cookieManager = zzu.zzcm().zzN(this.mContext);
            if (cookieManager != null) {
                cookieManager.setCookie("googleads.g.doubleclick.net", this.zzJK.zzLI);
            }
        }
    }

    protected AdSizeParcel zzb(AdRequestInfoParcel adRequestInfoParcel) throws zza {
        int n;
        int n2;
        if (this.zzJK.zzLS == null) {
            throw new zza("The ad response must specify one of the supported ad sizes.", 0);
        }
        String[] stringArray = this.zzJK.zzLS.split("x");
        if (stringArray.length != 2) {
            String string = String.valueOf(this.zzJK.zzLS);
            throw new zza(string.length() != 0 ? "Invalid ad size format from the ad response: ".concat(string) : new String("Invalid ad size format from the ad response: "), 0);
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            String string = String.valueOf(this.zzJK.zzLS);
            throw new zza(string.length() != 0 ? "Invalid ad size number from the ad response: ".concat(string) : new String("Invalid ad size number from the ad response: "), 0);
        }
        for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzsB.zzvu) {
            int n3;
            float f = this.mContext.getResources().getDisplayMetrics().density;
            int n4 = adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / f) : adSizeParcel.width;
            int n5 = n3 = adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / f) : adSizeParcel.height;
            if (n2 != n4 || n != n3) continue;
            return new AdSizeParcel(adSizeParcel, adRequestInfoParcel.zzsB.zzvu);
        }
        String string = String.valueOf(this.zzJK.zzLS);
        throw new zza(string.length() != 0 ? "The ad size from the ad response was not one of the requested sizes: ".concat(string) : new String("The ad size from the ad response was not one of the requested sizes: "), 0);
    }

    @zzig
    static final class zza
    extends Exception {
        private final int zzKa;

        public zza(String string, int n) {
            super(string);
            this.zzKa = n;
        }

        public int getErrorCode() {
            return this.zzKa;
        }
    }
}

