/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.internal.zzal;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzar;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzef;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzeq;
import com.google.android.gms.internal.zzer;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzkj;
import com.google.android.gms.internal.zzla;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
public final class zzeg {
    public static final zzeh zzBI = new zzeh(){

        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
        }
    };
    public static final zzeh zzBJ = new zzeh(){

        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
            String string2 = map.get("urls");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                zzjw.zzaW((String)"URLs missing in canOpenURLs GMSG.");
                return;
            }
            String[] stringArray = string2.split(",");
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            PackageManager packageManager = zzla2.getContext().getPackageManager();
            for (String string3 : stringArray) {
                String[] stringArray2 = string3.split(";", 2);
                String string4 = stringArray2[0].trim();
                String string5 = stringArray2.length > 1 ? stringArray2[1].trim() : "android.intent.action.VIEW";
                Uri uri = Uri.parse((String)string4);
                Intent intent = new Intent(string5, uri);
                ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
                hashMap.put(string3, resolveInfo != null);
            }
            zzla2.zza("openableURLs", hashMap);
        }
    };
    public static final zzeh zzBK = new zzeh(){

        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
            JSONArray jSONArray;
            JSONObject jSONObject;
            PackageManager packageManager = zzla2.getContext().getPackageManager();
            String string2 = map.get("data");
            try {
                jSONObject = new JSONObject(string2);
            }
            catch (JSONException jSONException) {
                zzla2.zzb("openableIntents", new JSONObject());
                return;
            }
            try {
                jSONArray = jSONObject.getJSONArray("intents");
            }
            catch (JSONException jSONException) {
                zzla2.zzb("openableIntents", new JSONObject());
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (int i = 0; i < jSONArray.length(); ++i) {
                ResolveInfo resolveInfo;
                JSONObject jSONObject3;
                try {
                    jSONObject3 = jSONArray.getJSONObject(i);
                }
                catch (JSONException jSONException) {
                    zzjw.zzb((String)"Error parsing the intent data.", (Throwable)jSONException);
                    continue;
                }
                String string3 = jSONObject3.optString("id");
                String string4 = jSONObject3.optString("u");
                String string5 = jSONObject3.optString("i");
                String string6 = jSONObject3.optString("m");
                String string7 = jSONObject3.optString("p");
                String string8 = jSONObject3.optString("c");
                String string9 = jSONObject3.optString("f");
                String string10 = jSONObject3.optString("e");
                Intent intent = new Intent();
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    intent.setData(Uri.parse((String)string4));
                }
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    intent.setAction(string5);
                }
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    intent.setType(string6);
                }
                if (!TextUtils.isEmpty((CharSequence)string7)) {
                    intent.setPackage(string7);
                }
                if (!TextUtils.isEmpty((CharSequence)string8) && ((ResolveInfo)(resolveInfo = string8.split("/", 2))).length == 2) {
                    intent.setComponent(new ComponentName((String)resolveInfo[0], (String)resolveInfo[1]));
                }
                boolean bl = (resolveInfo = packageManager.resolveActivity(intent, 65536)) != null;
                try {
                    jSONObject2.put(string3, bl);
                    continue;
                }
                catch (JSONException jSONException) {
                    zzjw.zzb((String)"Error constructing openable urls response.", (Throwable)jSONException);
                }
            }
            zzla2.zzb("openableIntents", jSONObject2);
        }
    };
    public static final zzeh zzBL = new zzeh(){

        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
            Object object;
            String string2 = map.get("u");
            if (string2 == null) {
                zzjw.zzaW((String)"URL missing from click GMSG.");
                return;
            }
            Uri uri = Uri.parse((String)string2);
            try {
                object = zzla2.zzjF();
                if (object != null && ((zzaq)object).zzc(uri)) {
                    uri = ((zzaq)object).zzb(uri, zzla2.getContext());
                }
            }
            catch (zzar zzar2) {
                String string3 = String.valueOf(string2);
                zzjw.zzaW((String)(string3.length() != 0 ? "Unable to append parameter to URL: ".concat(string3) : new String("Unable to append parameter to URL: ")));
            }
            string2 = uri.toString();
            object = new zzkj(zzla2.getContext(), zzla2.zzjG().afmaVersion, string2);
            Future cfr_ignored_0 = (Future)((zzjv)object).zzhs();
        }
    };
    public static final zzeh zzBM = new zzeh(){

        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
            com.google.android.gms.ads.internal.overlay.zzd zzd2 = zzla2.zzjB();
            if (zzd2 != null) {
                zzd2.close();
            } else {
                com.google.android.gms.ads.internal.overlay.zzd zzd3 = zzla2.zzjC();
                if (zzd3 != null) {
                    zzd3.close();
                } else {
                    zzjw.zzaW((String)"A GMSG tried to close something that wasn't an overlay.");
                }
            }
        }
    };
    public static final zzeh zzBN = new zzeh(){

        private void zzc(zzla zzla2) {
            zzm zzm2;
            zzjw.zzaV((String)"Received support message, responding.");
            boolean bl = false;
            zzd zzd2 = zzla2.zzjA();
            if (zzd2 != null && (zzm2 = zzd2.zzqo) != null) {
                bl = zzm2.zzgP();
            }
            zzm2 = new JSONObject();
            try {
                zzm2.put("event", "checkSupport");
                zzm2.put("supports", bl);
                zzla2.zzb("appStreaming", (JSONObject)zzm2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
            if ("checkSupport".equals(map.get("action"))) {
                this.zzc(zzla2);
                return;
            }
            com.google.android.gms.ads.internal.overlay.zzd zzd2 = zzla2.zzjB();
            if (zzd2 != null) {
                zzd2.zzf(zzla2, map);
            }
        }
    };
    public static final zzeh zzBO = new zzeh(){

        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
            zzla2.zzH("1".equals(map.get("custom_close")));
        }
    };
    public static final zzeh zzBP = new zzeh(){

        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
            String string2 = map.get("u");
            if (string2 == null) {
                zzjw.zzaW((String)"URL missing from httpTrack GMSG.");
                return;
            }
            zzkj zzkj2 = new zzkj(zzla2.getContext(), zzla2.zzjG().afmaVersion, string2);
            Future cfr_ignored_0 = (Future)zzkj2.zzhs();
        }
    };
    public static final zzeh zzBQ = new zzeh(){

        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
            String string2 = String.valueOf(map.get("string"));
            zzjw.zzaV((String)(string2.length() != 0 ? "Received log message: ".concat(string2) : new String("Received log message: ")));
        }
    };
    public static final zzeh zzBR = new zzeh(){

        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
            String string2 = map.get("tx");
            String string3 = map.get("ty");
            String string4 = map.get("td");
            try {
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(string3);
                int n3 = Integer.parseInt(string4);
                zzaq zzaq2 = zzla2.zzjF();
                if (zzaq2 != null) {
                    zzal zzal2 = zzaq2.zzW();
                    zzal2.zza(n, n2, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                zzjw.zzaW((String)"Could not parse touch parameters from gmsg.");
            }
        }
    };
    public static final zzeh zzBS = new zzeh(){

        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
            if (!zzcu.zzyB.get().booleanValue()) {
                return;
            }
            String string2 = map.get("disabled");
            boolean bl = Boolean.parseBoolean(string2);
            zzla2.zzI(!bl);
        }
    };
    public static final zzeh zzBT = new zzeh(){

        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
            String string2 = map.get("action");
            if ("pause".equals(string2)) {
                zzla2.zzbA();
            } else if ("resume".equals(string2)) {
                zzla2.zzbB();
            }
        }
    };
    public static final zzeh zzBU = new zzeq();
    public static final zzeh zzBV = new zzer();
    public static final zzeh zzBW = new zzev();
    public static final zzeh zzBX = new zzef();
}

