/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.reward.client.RewardedVideoAdRequestParcel;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzfq;
import com.google.android.gms.internal.zzfr;
import com.google.android.gms.internal.zzfz;
import com.google.android.gms.internal.zzga;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzij;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzjf;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzka;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
public class zziy
extends zzb
implements zzjb {
    private static final zzfz zzOy = new zzfz();
    private final Map<String, zzjf> zzOz = new HashMap<String, zzjf>();
    private boolean zzOA;

    public zziy(Context context, zzd zzd2, AdSizeParcel adSizeParcel, zzga zzga2, VersionInfoParcel versionInfoParcel) {
        super(context, adSizeParcel, null, zzga2, versionInfoParcel, zzd2);
    }

    public void zza(RewardedVideoAdRequestParcel rewardedVideoAdRequestParcel) {
        zzaa.zzdc((String)"loadAd must be called on the main UI thread.");
        if (TextUtils.isEmpty((CharSequence)rewardedVideoAdRequestParcel.zzsv)) {
            zzjw.zzaW((String)"Invalid ad unit id. Aborting.");
            return;
        }
        this.zzOA = false;
        this.zzpV.zzsv = rewardedVideoAdRequestParcel.zzsv;
        super.zzb(rewardedVideoAdRequestParcel.zzLi);
    }

    @Override
    public void zza(final zzjn.zza zza2, zzdc zzdc2) {
        if (zza2.errorCode != -2) {
            zzka.zzQu.post(new Runnable(){

                @Override
                public void run() {
                    zziy.this.zzb(new zzjn(zza2, null, null, null, null, null, null, null));
                }
            });
            return;
        }
        this.zzpV.zzsD = zza2;
        if (zza2.zzOY == null) {
            this.zzpV.zzsD = this.zze(zza2);
        }
        this.zzpV.zzsX = 0;
        this.zzpV.zzsA = zzu.zzcj().zza(this.zzpV.zzov, this.zzpV.zzsD, this);
    }

    @Nullable
    public zzjf zzaE(String string) {
        zzjf zzjf2 = this.zzOz.get(string);
        if (zzjf2 == null) {
            try {
                zzga zzga2 = this.zzqc;
                if ("com.google.ads.mediation.admob.AdMobAdapter".equals(string)) {
                    zzga2 = zzOy;
                }
                zzjf2 = new zzjf(zzga2.zzal(string), this);
                this.zzOz.put(string, zzjf2);
            }
            catch (Exception exception) {
                String string2 = String.valueOf(string);
                zzjw.zzd((String)(string2.length() != 0 ? "Fail to instantiate adapter ".concat(string2) : new String("Fail to instantiate adapter ")), (Throwable)exception);
            }
        }
        return zzjf2;
    }

    @Override
    public boolean zza(zzjn zzjn2, zzjn zzjn3) {
        return true;
    }

    @Override
    protected boolean zza(AdRequestParcel adRequestParcel, zzjn zzjn2, boolean bl) {
        return false;
    }

    @Override
    public void pause() {
        zzaa.zzdc((String)"pause must be called on the main UI thread.");
        for (String string : this.zzOz.keySet()) {
            try {
                zzjf zzjf2 = this.zzOz.get(string);
                if (zzjf2 == null || zzjf2.zzip() == null) continue;
                zzjf2.zzip().pause();
            }
            catch (RemoteException remoteException) {
                String string2 = String.valueOf(string);
                zzjw.zzaW((String)(string2.length() != 0 ? "Fail to pause adapter: ".concat(string2) : new String("Fail to pause adapter: ")));
            }
        }
    }

    @Override
    public void resume() {
        zzaa.zzdc((String)"resume must be called on the main UI thread.");
        for (String string : this.zzOz.keySet()) {
            try {
                zzjf zzjf2 = this.zzOz.get(string);
                if (zzjf2 == null || zzjf2.zzip() == null) continue;
                zzjf2.zzip().resume();
            }
            catch (RemoteException remoteException) {
                String string2 = String.valueOf(string);
                zzjw.zzaW((String)(string2.length() != 0 ? "Fail to resume adapter: ".concat(string2) : new String("Fail to resume adapter: ")));
            }
        }
    }

    @Override
    public void destroy() {
        zzaa.zzdc((String)"destroy must be called on the main UI thread.");
        for (String string : this.zzOz.keySet()) {
            try {
                zzjf zzjf2 = this.zzOz.get(string);
                if (zzjf2 == null || zzjf2.zzip() == null) continue;
                zzjf2.zzip().destroy();
            }
            catch (RemoteException remoteException) {
                String string2 = String.valueOf(string);
                zzjw.zzaW((String)(string2.length() != 0 ? "Fail to destroy adapter: ".concat(string2) : new String("Fail to destroy adapter: ")));
            }
        }
    }

    public void zzil() {
        zzaa.zzdc((String)"showAd must be called on the main UI thread.");
        if (!this.isLoaded()) {
            zzjw.zzaW((String)"The reward video has not loaded.");
            return;
        }
        this.zzOA = true;
        zzjf zzjf2 = this.zzaE(this.zzpV.zzsC.zzFi);
        if (zzjf2 != null && zzjf2.zzip() != null) {
            try {
                zzjf2.zzip().showVideo();
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Could not call showVideo.", (Throwable)remoteException);
            }
        }
    }

    public boolean isLoaded() {
        zzaa.zzdc((String)"isLoaded must be called on the main UI thread.");
        return this.zzpV.zzsz == null && this.zzpV.zzsA == null && this.zzpV.zzsC != null && !this.zzOA;
    }

    @Override
    public void onRewardedVideoAdOpened() {
        this.zza(this.zzpV.zzsC, false);
        this.zzbo();
    }

    @Override
    public void onRewardedVideoStarted() {
        if (this.zzpV.zzsC != null && this.zzpV.zzsC.zzFg != null) {
            zzu.zzcz().zza(this.zzpV.zzov, this.zzpV.zzsx.afmaVersion, this.zzpV.zzsC, this.zzpV.zzsv, false, this.zzpV.zzsC.zzFg.zzEw);
        }
        this.zzbq();
    }

    @Override
    public void onRewardedVideoAdClosed() {
        this.zzbm();
    }

    @Override
    public void zzc(@Nullable RewardItemParcel rewardItemParcel) {
        if (this.zzpV.zzsC != null && this.zzpV.zzsC.zzFg != null) {
            zzu.zzcz().zza(this.zzpV.zzov, this.zzpV.zzsx.afmaVersion, this.zzpV.zzsC, this.zzpV.zzsv, false, this.zzpV.zzsC.zzFg.zzEx);
        }
        if (this.zzpV.zzsC != null && this.zzpV.zzsC.zzOY != null && !TextUtils.isEmpty((CharSequence)this.zzpV.zzsC.zzOY.zzEM)) {
            rewardItemParcel = new RewardItemParcel(this.zzpV.zzsC.zzOY.zzEM, this.zzpV.zzsC.zzOY.zzEN);
        }
        this.zza(rewardItemParcel);
    }

    @Override
    public void zzim() {
        this.onAdClicked();
    }

    @Override
    public void onRewardedVideoAdLeftApplication() {
        this.zzbn();
    }

    public void onContextChanged(@NonNull Context context) {
        for (zzjf zzjf2 : this.zzOz.values()) {
            try {
                zzjf2.zzip().zzj(zze.zzD((Object)context));
            }
            catch (RemoteException remoteException) {
                zzjw.zzb((String)"Unable to call Adapter.onContextChanged.", (Throwable)remoteException);
            }
        }
    }

    private zzjn.zza zze(zzjn.zza zza2) {
        Object object;
        zzjw.v("Creating mediation ad response for non-mediated rewarded ad.");
        String string = null;
        String string2 = null;
        try {
            string = zzij.zzc(zza2.zzPi).toString();
            object = new JSONObject();
            object.put("pubid", (Object)zza2.zzPh.zzsv);
            string2 = object.toString();
        }
        catch (JSONException jSONException) {
            zzjw.zzb((String)"Unable to generate ad state for non-mediated rewarded video.", (Throwable)jSONException);
            return this.zzf(zza2);
        }
        object = new zzfq(string, null, Arrays.asList("com.google.ads.mediation.admob.AdMobAdapter"), null, null, Collections.emptyList(), Collections.emptyList(), string2, null, Collections.emptyList(), Collections.emptyList(), null, null, null, null, null, Collections.emptyList());
        zzfr zzfr2 = new zzfr(Arrays.asList(object), -1L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, "", -1L, 0, 1, null, 0, -1, -1L, false);
        return new zzjn.zza(zza2.zzPh, zza2.zzPi, zzfr2, zza2.zzsB, zza2.errorCode, zza2.zzPc, zza2.zzPd, zza2.zzOW);
    }

    private zzjn.zza zzf(zzjn.zza zza2) {
        return new zzjn.zza(zza2.zzPh, zza2.zzPi, null, zza2.zzsB, 0, zza2.zzPc, zza2.zzPd, zza2.zzOW);
    }
}

