/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzla;
import java.io.BufferedOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
public class zzei
implements zzeh {
    private final Context mContext;
    private final VersionInfoParcel zzqP;

    public zzei(Context context, VersionInfoParcel versionInfoParcel) {
        this.mContext = context;
        this.zzqP = versionInfoParcel;
    }

    protected zzb zzc(JSONObject jSONObject) {
        String string2 = jSONObject.optString("http_request_id");
        String string3 = jSONObject.optString("url");
        String string4 = jSONObject.optString("post_body", null);
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            zzjw.zzb((String)"Error constructing http request.", (Throwable)malformedURLException);
        }
        ArrayList<zza> arrayList = new ArrayList<zza>();
        JSONArray jSONArray = jSONObject.optJSONArray("headers");
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i);
            if (jSONObject2 == null) continue;
            String string5 = jSONObject2.optString("key");
            String string6 = jSONObject2.optString("value");
            arrayList.add(new zza(string5, string6));
        }
        return new zzb(string2, uRL, arrayList, string4);
    }

    protected JSONObject zza(zzd zzd2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("http_request_id", (Object)zzd2.zzeY());
            if (zzd2.getBody() != null) {
                jSONObject.put("body", (Object)zzd2.getBody());
            }
            JSONArray jSONArray = new JSONArray();
            for (zza zza2 : zzd2.zzfd()) {
                jSONArray.put((Object)new JSONObject().put("key", (Object)zza2.getKey()).put("value", (Object)zza2.getValue()));
            }
            jSONObject.put("headers", (Object)jSONArray);
            jSONObject.put("response_code", zzd2.getResponseCode());
        }
        catch (JSONException jSONException) {
            zzjw.zzb((String)"Error constructing JSON for http response.", (Throwable)jSONException);
        }
        return jSONObject;
    }

    protected zzc zza(zzb zzb2) {
        try {
            Object object;
            HttpURLConnection httpURLConnection = (HttpURLConnection)zzb2.zzeZ().openConnection();
            zzu.zzck().zza(this.mContext, this.zzqP.afmaVersion, false, httpURLConnection);
            for (zza object22 : zzb2.zzfa()) {
                httpURLConnection.addRequestProperty(object22.getKey(), object22.getValue());
            }
            if (!TextUtils.isEmpty((CharSequence)zzb2.zzfb())) {
                httpURLConnection.setDoOutput(true);
                object = zzb2.zzfb().getBytes();
                httpURLConnection.setFixedLengthStreamingMode(((Object)object).length);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
                bufferedOutputStream.write((byte[])object);
                bufferedOutputStream.close();
            }
            object = new ArrayList();
            if (httpURLConnection.getHeaderFields() != null) {
                for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
                    for (String string2 : entry.getValue()) {
                        ((ArrayList)object).add(new zza(entry.getKey(), string2));
                    }
                }
            }
            zzd zzd2 = new zzd(zzb2.zzeY(), httpURLConnection.getResponseCode(), (List<zza>)object, zzu.zzck().zza(new InputStreamReader(httpURLConnection.getInputStream())));
            return new zzc(true, zzd2, null);
        }
        catch (Exception exception) {
            return new zzc(false, null, exception.toString());
        }
    }

    public JSONObject zzV(String string2) {
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            zzjw.e((String)"The request is not a valid JSON.");
            try {
                return new JSONObject().put("success", false);
            }
            catch (JSONException jSONException2) {
                return new JSONObject();
            }
        }
        JSONObject jSONObject2 = new JSONObject();
        String string3 = "";
        try {
            string3 = jSONObject.optString("http_request_id");
            zzb zzb2 = this.zzc(jSONObject);
            zzc zzc2 = this.zza(zzb2);
            if (zzc2.isSuccess()) {
                JSONObject jSONObject3 = this.zza(zzc2.zzfc());
                jSONObject2.put("response", (Object)jSONObject3);
                jSONObject2.put("success", true);
            } else {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)zzc2.getReason());
            }
        }
        catch (Exception exception) {
            try {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)exception.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return jSONObject2;
    }

    @Override
    public void zza(final zzla zzla2, final Map<String, String> map) {
        zzjz.zza(new Runnable(){

            @Override
            public void run() {
                zzjw.zzaU((String)"Received Http request.");
                String string2 = (String)map.get("http_request");
                final JSONObject jSONObject = zzei.this.zzV(string2);
                if (jSONObject == null) {
                    zzjw.e((String)"Response should not be null.");
                    return;
                }
                zzka.zzQu.post(new Runnable(){

                    @Override
                    public void run() {
                        zzla2.zzb("fetchHttpRequestCompleted", jSONObject);
                        zzjw.zzaU((String)"Dispatched http response.");
                    }
                });
            }
        });
    }

    @zzig
    class zzc {
        private final zzd zzCg;
        private final boolean zzCh;
        private final String zzCi;

        public zzc(boolean bl, zzd zzd2, String string2) {
            this.zzCh = bl;
            this.zzCg = zzd2;
            this.zzCi = string2;
        }

        public String getReason() {
            return this.zzCi;
        }

        public zzd zzfc() {
            return this.zzCg;
        }

        public boolean isSuccess() {
            return this.zzCh;
        }
    }

    @zzig
    static class zzd {
        private final String zzCc;
        private final int zzCj;
        private final List<zza> zzCk;
        private final String zzAE;

        public zzd(String string2, int n, List<zza> list, String string3) {
            this.zzCc = string2;
            this.zzCj = n;
            this.zzCk = list == null ? new ArrayList<zza>() : list;
            this.zzAE = string3;
        }

        public String zzeY() {
            return this.zzCc;
        }

        public int getResponseCode() {
            return this.zzCj;
        }

        public Iterable<zza> zzfd() {
            return this.zzCk;
        }

        public String getBody() {
            return this.zzAE;
        }
    }

    @zzig
    static class zzb {
        private final String zzCc;
        private final URL zzCd;
        private final ArrayList<zza> zzCe;
        private final String zzCf;

        public zzb(String string2, URL uRL, ArrayList<zza> arrayList, String string3) {
            this.zzCc = string2;
            this.zzCd = uRL;
            this.zzCe = arrayList == null ? new ArrayList() : arrayList;
            this.zzCf = string3;
        }

        public String zzeY() {
            return this.zzCc;
        }

        public URL zzeZ() {
            return this.zzCd;
        }

        public ArrayList<zza> zzfa() {
            return this.zzCe;
        }

        public String zzfb() {
            return this.zzCf;
        }
    }

    @zzig
    static class zza {
        private final String zzwQ;
        private final String mValue;

        public zza(String string2, String string3) {
            this.zzwQ = string2;
            this.mValue = string3;
        }

        public String getKey() {
            return this.zzwQ;
        }

        public String getValue() {
            return this.mValue;
        }
    }
}

