/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcm;
import com.google.android.gms.internal.zzgw;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzla;
import java.util.Map;

@zzig
public class zzgt
extends zzgw {
    private final Map<String, String> zzAd;
    private final Context mContext;

    public zzgt(zzla zzla2, Map<String, String> map) {
        super(zzla2, "storePicture");
        this.zzAd = map;
        this.mContext = zzla2.zzjy();
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzas("Activity context is not available");
            return;
        }
        zzcm zzcm2 = zzu.zzck().zzF(this.mContext);
        if (!zzcm2.zzel()) {
            this.zzas("Feature is not supported by the device.");
            return;
        }
        final String string2 = this.zzAd.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzas("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzas(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        final String string4 = this.zzar(string2);
        if (!zzu.zzck().zzaP(string4)) {
            String string5 = String.valueOf(string4);
            this.zzas(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzu.zzcn().getResources();
        AlertDialog.Builder builder = zzu.zzck().zzE(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.store_picture_title) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.store_picture_message) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.accept) : "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                DownloadManager downloadManager = (DownloadManager)zzgt.this.mContext.getSystemService("download");
                try {
                    DownloadManager.Request request = zzgt.this.zzi(string2, string4);
                    downloadManager.enqueue(request);
                }
                catch (IllegalStateException illegalStateException) {
                    zzgt.this.zzas("Could not store picture.");
                }
            }
        });
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.decline) : "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzgt.this.zzas("User canceled the download.");
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    DownloadManager.Request zzi(String string2, String string3) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_PICTURES, string3);
        zzu.zzcm().zza(request);
        return request;
    }

    String zzar(String string2) {
        Uri uri = Uri.parse((String)string2);
        return uri.getLastPathSegment();
    }
}

