/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzw;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkh;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzin
@TargetApi(value=14)
public class zzc
extends zzi
implements AudioManager.OnAudioFocusChangeListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzbrr = new HashMap<Integer, String>();
    private final zzx zzbrs;
    private final boolean zzbrt;
    private int zzbru = 0;
    private int zzbrv = 0;
    private MediaPlayer zzbrw;
    private Uri zzbrx;
    private int zzbry;
    private int zzbrz;
    private int zzbsa;
    private int zzbsb;
    private int zzbsc;
    private float zzbsd = 1.0f;
    private boolean zzbse;
    private boolean zzbsf;
    private zzw zzbsg;
    private boolean zzbsh;
    private int zzbsi;
    private zzh zzbsj;

    public zzc(Context context, boolean bl, boolean bl2, zzx zzx2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzbrs = zzx2;
        this.zzbsh = bl;
        this.zzbrt = bl2;
        this.zzbrs.zza(this);
    }

    @Override
    public String zzni() {
        String string = String.valueOf(this.zzbsh ? " spherical" : "");
        return string.length() != 0 ? "MediaPlayer".concat(string) : new String("MediaPlayer");
    }

    @Override
    public void zza(zzh zzh2) {
        this.zzbsj = zzh2;
    }

    @Override
    public void setMimeType(String string) {
    }

    @Override
    public void setVideoPath(String string) {
        this.setVideoURI(Uri.parse((String)string));
    }

    public void setVideoURI(Uri uri) {
        this.zzbrx = uri;
        this.zzbsi = 0;
        this.zznj();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void stop() {
        zzkd.v("AdMediaPlayerView stop");
        if (this.zzbrw != null) {
            this.zzbrw.stop();
            this.zzbrw.release();
            this.zzbrw = null;
            this.zzad(0);
            this.zzae(0);
            this.zznm();
        }
        this.zzbrs.onStop();
    }

    public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzkd.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzbry = mediaPlayer.getVideoWidth();
        this.zzbrz = mediaPlayer.getVideoHeight();
        if (this.zzbry != 0 && this.zzbrz != 0) {
            this.requestLayout();
        }
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        zzkd.v("AdMediaPlayerView prepared");
        this.zzad(2);
        this.zzbrs.zzoj();
        zzkh.zzclc.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzbsj != null) {
                    zzc.this.zzbsj.zzoj();
                }
            }
        });
        this.zzbry = mediaPlayer.getVideoWidth();
        this.zzbrz = mediaPlayer.getVideoHeight();
        if (this.zzbsi != 0) {
            this.seekTo(this.zzbsi);
        }
        this.zznk();
        int n = this.zzbry;
        int n2 = this.zzbrz;
        zzkd.zzcw((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzbrv == 3) {
            this.play();
        }
        this.zznl();
        this.zzns();
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        zzkd.v("AdMediaPlayerView completion");
        this.zzad(5);
        this.zzae(5);
        zzkh.zzclc.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzbsj != null) {
                    zzc.this.zzbsj.zzol();
                }
            }
        });
    }

    public boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzbrr.get(n);
        String string2 = zzbrr.get(n2);
        zzkd.v(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string).append(":").append(string2).toString());
        return true;
    }

    public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        final String string = zzbrr.get(n);
        final String string2 = zzbrr.get(n2);
        zzkd.zzcx((String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string).append(":").append(string2).toString());
        this.zzad(-1);
        this.zzae(-1);
        zzkh.zzclc.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzbsj != null) {
                    zzc.this.zzbsj.zzl(string, string2);
                }
            }
        });
        return true;
    }

    public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzbsa = n;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzkd.v("AdMediaPlayerView surface created");
        this.zznj();
        zzkh.zzclc.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzbsj != null) {
                    zzc.this.zzbsj.zzoi();
                }
            }
        });
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzkd.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzbrv == 3;
        boolean bl3 = bl = this.zzbry == n && this.zzbrz == n2;
        if (this.zzbrw != null && bl2 && bl) {
            if (this.zzbsi != 0) {
                this.seekTo(this.zzbsi);
            }
            this.play();
        }
        if (this.zzbsg != null) {
            this.zzbsg.zzg(n, n2);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzkd.v("AdMediaPlayerView surface destroyed");
        if (this.zzbrw != null && this.zzbsi == 0) {
            this.zzbsi = this.zzbrw.getCurrentPosition();
        }
        if (this.zzbsg != null) {
            this.zzbsg.zzow();
        }
        zzkh.zzclc.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzbsj != null) {
                    zzc.this.zzbsj.onPaused();
                    zzc.this.zzbsj.zzom();
                }
            }
        });
        this.zzy(true);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzbrs.zzb(this);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = zzc.getDefaultSize((int)this.zzbry, (int)n);
        int n4 = zzc.getDefaultSize((int)this.zzbrz, (int)n2);
        if (this.zzbry > 0 && this.zzbrz > 0 && this.zzbsg == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzbry * n4 < n3 * this.zzbrz) {
                    n3 = n4 * this.zzbry / this.zzbrz;
                } else if (this.zzbry * n4 > n3 * this.zzbrz) {
                    n4 = n3 * this.zzbrz / this.zzbry;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzbrz / this.zzbry;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzbry / this.zzbrz;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzbry;
                n4 = this.zzbrz;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzbry / this.zzbrz;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzbrz / this.zzbry;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzbsg != null) {
            this.zzbsg.zzg(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzbsb > 0 && this.zzbsb != n3 || this.zzbsc > 0 && this.zzbsc != n4) {
                this.zznk();
            }
            this.zzbsb = n3;
            this.zzbsc = n4;
        }
    }

    public String toString() {
        String string = String.valueOf(((Object)((Object)this)).getClass().getName());
        String string2 = String.valueOf(Integer.toHexString(((Object)((Object)this)).hashCode()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("@").append(string2).toString();
    }

    private void zznj() {
        zzkd.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzbrx == null || surfaceTexture == null) {
            return;
        }
        this.zzy(false);
        try {
            Surface surface;
            this.zzbrw = zzu.zzgd().zzov();
            this.zzbrw.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzbrw.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzbrw.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzbrw.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzbrw.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzbrw.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzbsa = 0;
            if (this.zzbsh) {
                this.zzbsg = new zzw(this.getContext());
                this.zzbsg.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzbsg.start();
                surface = this.zzbsg.zzox();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzbsg.zzow();
                    this.zzbsg = null;
                }
            }
            this.zzbrw.setDataSource(this.getContext(), this.zzbrx);
            surface = zzu.zzge().zza(surfaceTexture);
            this.zzbrw.setSurface(surface);
            this.zzbrw.setAudioStreamType(3);
            this.zzbrw.setScreenOnWhilePlaying(true);
            this.zzbrw.prepareAsync();
            this.zzad(1);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string = String.valueOf(this.zzbrx);
            zzkd.zzd((String)new StringBuilder(36 + String.valueOf(string).length()).append("Failed to initialize MediaPlayer at ").append(string).toString(), (Throwable)exception);
            this.onError(this.zzbrw, 1, 0);
        }
    }

    private void zznk() {
        if (!this.zzbrt) {
            return;
        }
        if (this.zznn() && this.zzbrw.getCurrentPosition() > 0 && this.zzbrv != 3) {
            long l;
            zzkd.v("AdMediaPlayerView nudging MediaPlayer");
            this.zzb(0.0f);
            this.zzbrw.start();
            int n = this.zzbrw.getCurrentPosition();
            long l2 = zzu.zzfu().currentTimeMillis();
            while (this.zznn() && this.zzbrw.getCurrentPosition() == n && (l = zzu.zzfu().currentTimeMillis()) - l2 <= 250L) {
            }
            this.zzbrw.pause();
            this.zzns();
        }
    }

    private void zznl() {
        AudioManager audioManager = this.zznt();
        if (audioManager != null && !this.zzbsf) {
            int n = audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 2);
            if (n == 1) {
                this.zznq();
            } else {
                zzkd.zzcx((String)"AdMediaPlayerView audio focus request failed");
            }
        }
    }

    private void zznm() {
        zzkd.v("AdMediaPlayerView abandon audio focus");
        AudioManager audioManager = this.zznt();
        if (audioManager != null && this.zzbsf) {
            int n = audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
            if (n == 1) {
                this.zzbsf = false;
            } else {
                zzkd.zzcx((String)"AdMediaPlayerView abandon audio focus failed");
            }
        }
    }

    private void zzy(boolean bl) {
        zzkd.v("AdMediaPlayerView release");
        if (this.zzbsg != null) {
            this.zzbsg.zzow();
            this.zzbsg = null;
        }
        if (this.zzbrw != null) {
            this.zzbrw.reset();
            this.zzbrw.release();
            this.zzbrw = null;
            this.zzad(0);
            if (bl) {
                this.zzbrv = 0;
                this.zzae(0);
            }
            this.zznm();
        }
    }

    @Override
    public void play() {
        zzkd.v("AdMediaPlayerView play");
        if (this.zznn()) {
            this.zzbrw.start();
            this.zzad(3);
            zzkh.zzclc.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzbsj != null) {
                        zzc.this.zzbsj.zzok();
                    }
                }
            });
        }
        this.zzae(3);
    }

    @Override
    public void pause() {
        zzkd.v("AdMediaPlayerView pause");
        if (this.zznn() && this.zzbrw.isPlaying()) {
            this.zzbrw.pause();
            this.zzad(4);
            zzkh.zzclc.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzbsj != null) {
                        zzc.this.zzbsj.onPaused();
                    }
                }
            });
        }
        this.zzae(4);
    }

    @Override
    public int getDuration() {
        if (this.zznn()) {
            return this.zzbrw.getDuration();
        }
        return -1;
    }

    @Override
    public int getCurrentPosition() {
        if (this.zznn()) {
            return this.zzbrw.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public void seekTo(int n) {
        zzkd.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zznn()) {
            this.zzbrw.seekTo(n);
            this.zzbsi = 0;
        } else {
            this.zzbsi = n;
        }
    }

    private boolean zznn() {
        return this.zzbrw != null && this.zzbru != -1 && this.zzbru != 0 && this.zzbru != 1;
    }

    public void onAudioFocusChange(int n) {
        if (n > 0) {
            this.zznq();
        } else if (n < 0) {
            this.zznr();
        }
    }

    @Override
    public void zzno() {
        this.zzbse = true;
        this.zzns();
    }

    @Override
    public void zznp() {
        this.zzbse = false;
        this.zzns();
    }

    @Override
    public void zza(float f) {
        this.zzbsd = f;
        this.zzns();
    }

    @Override
    public void zza(float f, float f2) {
        if (this.zzbsg != null) {
            this.zzbsg.zzb(f, f2);
        }
    }

    @Override
    public int getVideoWidth() {
        if (this.zzbrw != null) {
            return this.zzbrw.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.zzbrw != null) {
            return this.zzbrw.getVideoHeight();
        }
        return 0;
    }

    private void zznq() {
        zzkd.v("AdMediaPlayerView audio focus gained");
        this.zzbsf = true;
        this.zzns();
    }

    private void zznr() {
        zzkd.v("AdMediaPlayerView audio focus lost");
        this.zzbsf = false;
        this.zzns();
    }

    private void zzns() {
        if (!this.zzbse && this.zzbsf) {
            this.zzb(this.zzbsd);
        } else {
            this.zzb(0.0f);
        }
    }

    private void zzb(float f) {
        if (this.zzbrw != null) {
            try {
                this.zzbrw.setVolume(f, f);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            zzkd.zzcx((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
        }
    }

    private AudioManager zznt() {
        Context context = this.getContext();
        return (AudioManager)context.getSystemService("audio");
    }

    private void zzad(int n) {
        if (n == 3) {
            this.zzbrs.zzpi();
        } else if (this.zzbru == 3) {
            this.zzbrs.zzpj();
        }
        this.zzbru = n;
    }

    private void zzae(int n) {
        this.zzbrv = n;
    }

    static {
        zzbrr.put(-1004, "MEDIA_ERROR_IO");
        zzbrr.put(-1007, "MEDIA_ERROR_MALFORMED");
        zzbrr.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
        zzbrr.put(-110, "MEDIA_ERROR_TIMED_OUT");
        zzbrr.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzbrr.put(1, "MEDIA_ERROR_UNKNOWN");
        zzbrr.put(1, "MEDIA_INFO_UNKNOWN");
        zzbrr.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzbrr.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        zzbrr.put(701, "MEDIA_INFO_BUFFERING_START");
        zzbrr.put(702, "MEDIA_INFO_BUFFERING_END");
        zzbrr.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzbrr.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzbrr.put(802, "MEDIA_INFO_METADATA_UPDATE");
        zzbrr.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
        zzbrr.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
    }
}

