/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzs;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzhi;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkc;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkk;
import com.google.android.gms.internal.zzlh;
import com.google.android.gms.internal.zzli;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Future;

@zzin
public class zzd
extends zzhi.zza
implements com.google.android.gms.ads.internal.overlay.zzu {
    static final int zzbsn = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzbso;
    zzlh zzbgf;
    zzc zzbsp;
    zzo zzbsq;
    boolean zzbsr = false;
    FrameLayout zzbss;
    WebChromeClient.CustomViewCallback zzbst;
    boolean zzbsu = false;
    boolean zzbsv = false;
    zzb zzbsw;
    boolean zzbsx = false;
    int zzbsy = 0;
    zzl zzbsz;
    private boolean zzbta;
    private boolean zzbtb = false;
    private boolean zzbtc = true;

    public zzd(Activity activity) {
        this.mActivity = activity;
        this.zzbsz = new zzs();
    }

    public void close() {
        this.zzbsy = 2;
        this.mActivity.finish();
    }

    public void zznu() {
        if (this.zzbso != null && this.zzbsr) {
            this.setRequestedOrientation(this.zzbso.orientation);
        }
        if (this.zzbss != null) {
            this.mActivity.setContentView((View)this.zzbsw);
            this.zzdb();
            this.zzbss.removeAllViews();
            this.zzbss = null;
        }
        if (this.zzbst != null) {
            this.zzbst.onCustomViewHidden();
            this.zzbst = null;
        }
        this.zzbsr = false;
    }

    @Override
    public void zznv() {
        this.zzbsy = 1;
        this.mActivity.finish();
    }

    public void onBackPressed() {
        this.zzbsy = 0;
    }

    public boolean zznw() {
        boolean bl;
        this.zzbsy = 0;
        if (this.zzbgf == null) {
            return true;
        }
        boolean bl2 = bl = this.zzbgf.zzou() && this.zzbsz.zzou();
        if (!bl) {
            this.zzbgf.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzbsu = bundle != null ? bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzbso = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzbso == null) {
                throw new zza("Could not get info for ad overlay.");
            }
            if (this.zzbso.zzaow.zzcnl > 7500000) {
                this.zzbsy = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzbtc = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzbsv = this.zzbso.zzbtv != null ? this.zzbso.zzbtv.zzame : false;
            if (zzdc.zzbca.get().booleanValue() && this.zzbsv && this.zzbso.zzbtv.zzamj != -1) {
                Future cfr_ignored_0 = (Future)new zzd().zzpy();
            }
            if (bundle == null) {
                if (this.zzbso.zzbtl != null && this.zzbtc) {
                    this.zzbso.zzbtl.zzdy();
                }
                if (this.zzbso.zzbts != 1 && this.zzbso.zzbtk != null) {
                    this.zzbso.zzbtk.onAdClicked();
                }
            }
            this.zzbsw = new zzb((Context)this.mActivity, this.zzbso.zzbtu);
            this.zzbsw.setId(1000);
            switch (this.zzbso.zzbts) {
                case 1: {
                    this.zzaa(false);
                    break;
                }
                case 2: {
                    this.zzbsp = new zzc(this.zzbso.zzbtm);
                    this.zzaa(false);
                    break;
                }
                case 3: {
                    this.zzaa(true);
                    break;
                }
                case 4: {
                    if (this.zzbsu) {
                        this.zzbsy = 3;
                        this.mActivity.finish();
                        break;
                    }
                    if (!zzu.zzfn().zza((Context)this.mActivity, this.zzbso.zzbtj, this.zzbso.zzbtr)) {
                        this.zzbsy = 3;
                        this.mActivity.finish();
                    }
                    break;
                }
                default: {
                    throw new zza("Could not determine ad overlay type.");
                }
            }
        }
        catch (zza zza2) {
            zzkd.zzcx((String)zza2.getMessage());
            this.zzbsy = 3;
            this.mActivity.finish();
        }
    }

    public void onRestart() {
    }

    public void onStart() {
    }

    public void onResume() {
        if (this.zzbso != null && this.zzbso.zzbts == 4) {
            if (this.zzbsu) {
                this.zzbsy = 3;
                this.mActivity.finish();
            } else {
                this.zzbsu = true;
            }
        }
        if (this.zzbso.zzbtl != null) {
            this.zzbso.zzbtl.onResume();
        }
        if (this.zzbgf != null && !this.zzbgf.isDestroyed()) {
            zzu.zzfs().zzj(this.zzbgf);
        } else {
            zzkd.zzcx((String)"The webview does not exit. Ignoring action.");
        }
        this.zzbsz.resume();
    }

    public void onPause() {
        this.zzbsz.pause();
        this.zznu();
        if (this.zzbso.zzbtl != null) {
            this.zzbso.zzbtl.onPause();
        }
        if (!(this.zzbgf == null || this.mActivity.isFinishing() && this.zzbsp != null)) {
            zzu.zzfs().zzi(this.zzbgf);
        }
        this.zzny();
    }

    public void onActivityResult(int n, int n2, Intent intent) {
    }

    public void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzbsu);
    }

    public void onStop() {
        this.zzny();
    }

    public void onDestroy() {
        if (this.zzbgf != null) {
            this.zzbsw.removeView(this.zzbgf.getView());
        }
        this.zzny();
    }

    public void zzz(boolean bl) {
        int n = bl ? 50 : 32;
        this.zzbsq = new zzo((Context)this.mActivity, n, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zzbsq.zza(bl, this.zzbso.zzbtp);
        this.zzbsw.addView((View)this.zzbsq, (ViewGroup.LayoutParams)layoutParams);
    }

    public void zzdb() {
        this.zzbta = true;
    }

    public void zza(boolean bl, boolean bl2) {
        if (this.zzbsq != null) {
            this.zzbsq.zza(bl, bl2);
        }
    }

    public void zznx() {
        this.zzbsw.removeView((View)this.zzbsq);
        this.zzz(true);
    }

    public void setRequestedOrientation(int n) {
        this.mActivity.setRequestedOrientation(n);
    }

    public void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzbss = new FrameLayout((Context)this.mActivity);
        this.zzbss.setBackgroundColor(-16777216);
        this.zzbss.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzbss);
        this.zzdb();
        this.zzbst = customViewCallback;
        this.zzbsr = true;
    }

    protected void zzaa(boolean bl) throws zza {
        com.google.android.gms.ads.internal.zzd zzd2;
        zzm zzm2;
        zzli zzli2;
        Window window;
        if (!this.zzbta) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zza("Invalid activity, no window available.");
        }
        if (!this.zzbsv || this.zzbso.zzbtv != null && this.zzbso.zzbtv.zzamf) {
            window.setFlags(1024, 1024);
        }
        boolean bl2 = (zzli2 = this.zzbso.zzbtm.zzuj()) != null ? zzli2.zzho() : false;
        this.zzbsx = false;
        if (bl2) {
            if (this.zzbso.orientation == zzu.zzfs().zztj()) {
                this.zzbsx = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzbso.orientation == zzu.zzfs().zztk()) {
                this.zzbsx = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        boolean bl3 = this.zzbsx;
        zzkd.zzcv((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl3).toString());
        this.setRequestedOrientation(this.zzbso.orientation);
        if (zzu.zzfs().zza(window)) {
            zzkd.zzcv((String)"Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzbsv) {
            this.zzbsw.setBackgroundColor(-16777216);
        } else {
            this.zzbsw.setBackgroundColor(zzbsn);
        }
        this.mActivity.setContentView((View)this.zzbsw);
        this.zzdb();
        if (bl) {
            this.zzbgf = zzu.zzfr().zza((Context)this.mActivity, this.zzbso.zzbtm.zzdn(), true, bl2, null, this.zzbso.zzaow, null, null, this.zzbso.zzbtm.zzug());
            this.zzbgf.zzuj().zza(null, null, this.zzbso.zzbtn, this.zzbso.zzbtr, true, this.zzbso.zzbtt, null, this.zzbso.zzbtm.zzuj().zzux(), null, null);
            this.zzbgf.zzuj().zza(new zzli.zza(){

                @Override
                public void zza(zzlh zzlh2, boolean bl) {
                    zzlh2.zzoa();
                }
            });
            if (this.zzbso.url != null) {
                this.zzbgf.loadUrl(this.zzbso.url);
            } else if (this.zzbso.zzbtq != null) {
                this.zzbgf.loadDataWithBaseURL(this.zzbso.zzbto, this.zzbso.zzbtq, "text/html", "UTF-8", null);
            } else {
                throw new zza("No URL or HTML to display in ad overlay.");
            }
            if (this.zzbso.zzbtm != null) {
                this.zzbso.zzbtm.zzc(this);
            }
        } else {
            this.zzbgf = this.zzbso.zzbtm;
            this.zzbgf.setContext((Context)this.mActivity);
        }
        this.zzbgf.zzb(this);
        ViewParent viewParent = this.zzbgf.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzbgf.getView());
        }
        if (this.zzbsv) {
            this.zzbgf.setBackgroundColor(zzbsn);
        }
        this.zzbsw.addView(this.zzbgf.getView(), -1, -1);
        if (!bl && !this.zzbsx) {
            this.zzoa();
        }
        this.zzz(bl2);
        if (this.zzbgf.zzuk()) {
            this.zza(bl2, true);
        }
        zzm zzm3 = zzm2 = (zzd2 = this.zzbgf.zzug()) != null ? zzd2.zzakl : null;
        if (zzm2 != null) {
            this.zzbsz = zzm2.zza(this.mActivity, this.zzbgf, this.zzbsw);
        } else {
            zzkd.zzcx((String)"Appstreaming controller is null.");
        }
    }

    protected void zzny() {
        if (!this.mActivity.isFinishing() || this.zzbtb) {
            return;
        }
        this.zzbtb = true;
        if (this.zzbgf != null) {
            this.zzaf(this.zzbsy);
            this.zzbsw.removeView(this.zzbgf.getView());
            if (this.zzbsp != null) {
                this.zzbgf.setContext(this.zzbsp.zzagf);
                this.zzbgf.zzah(false);
                this.zzbsp.zzbtg.addView(this.zzbgf.getView(), this.zzbsp.index, this.zzbsp.zzbtf);
                this.zzbsp = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzbgf.setContext(this.mActivity.getApplicationContext());
            }
            this.zzbgf = null;
        }
        if (this.zzbso != null && this.zzbso.zzbtl != null) {
            this.zzbso.zzbtl.zzdx();
        }
        this.zzbsz.destroy();
    }

    public void zznz() {
        if (this.zzbsx) {
            this.zzbsx = false;
            this.zzoa();
        }
    }

    protected void zzoa() {
        this.zzbgf.zzoa();
    }

    protected void zzaf(int n) {
        this.zzbgf.zzaf(n);
    }

    public void zzf(zzlh zzlh2, Map<String, String> map) {
        this.zzbsz.zzf(zzlh2, map);
    }

    public void zzob() {
        this.zzbsw.disable();
    }

    @zzin
    private class zzd
    extends zzkc {
        private zzd() {
        }

        @Override
        public void zzew() {
            Bitmap bitmap = zzu.zzgh().zza(zzd.this.zzbso.zzbtv.zzamj);
            if (bitmap != null) {
                final Drawable drawable = zzu.zzfs().zza((Context)zzd.this.mActivity, bitmap, zzd.this.zzbso.zzbtv.zzamh, zzd.this.zzbso.zzbtv.zzami);
                zzkh.zzclc.post(new Runnable(){

                    @Override
                    public void run() {
                        zzd.this.mActivity.getWindow().setBackgroundDrawable(drawable);
                    }
                });
            }
        }

        @Override
        public void onStop() {
        }
    }

    @zzin
    static class zzb
    extends RelativeLayout {
        zzkk zzaqf;
        boolean zzbte;

        public zzb(Context context, String string) {
            super(context);
            this.zzaqf = new zzkk(context, string);
        }

        public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
            if (!this.zzbte) {
                this.zzaqf.zze(motionEvent);
            }
            return false;
        }

        void disable() {
            this.zzbte = true;
        }
    }

    @zzin
    public static class zzc {
        public final int index;
        public final ViewGroup.LayoutParams zzbtf;
        public final ViewGroup zzbtg;
        public final Context zzagf;

        public zzc(zzlh zzlh2) throws zza {
            this.zzbtf = zzlh2.getLayoutParams();
            ViewParent viewParent = zzlh2.getParent();
            this.zzagf = zzlh2.zzuf();
            if (viewParent == null || !(viewParent instanceof ViewGroup)) {
                throw new zza("Could not get the parent of the WebView for an overlay.");
            }
            this.zzbtg = (ViewGroup)viewParent;
            this.index = this.zzbtg.indexOfChild(zzlh2.getView());
            this.zzbtg.removeView(zzlh2.getView());
            zzlh2.zzah(true);
        }
    }

    @zzin
    private static final class zza
    extends Exception {
        public zza(String string) {
            super(string);
        }
    }
}

