/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import com.google.android.gms.ads.internal.purchase.zzb;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzg;
import com.google.android.gms.ads.internal.purchase.zzh;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzhr;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkc;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkh;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@zzin
public class zzc
extends zzkc
implements ServiceConnection {
    private final Object zzail = new Object();
    private boolean zzbwr = false;
    private Context mContext;
    private zzhs zzbld;
    private zzb zzbws;
    private zzh zzbwt;
    private List<zzf> zzbwu = null;
    private zzk zzbwv;

    public zzc(Context context, zzhs zzhs2, zzk zzk2) {
        this(context, zzhs2, zzk2, new zzb(context), zzh.zzs(context.getApplicationContext()));
    }

    zzc(Context context, zzhs zzhs2, zzk zzk2, zzb zzb2, zzh zzh2) {
        this.mContext = context;
        this.zzbld = zzhs2;
        this.zzbwv = zzk2;
        this.zzbws = zzb2;
        this.zzbwt = zzh2;
        this.zzbwu = this.zzbwt.zzg(10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzew() {
        Object object = this.zzail;
        synchronized (object) {
            Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
            intent.setPackage("com.android.vending");
            com.google.android.gms.common.stats.zzb.zzaux().zza(this.mContext, intent, (ServiceConnection)this, 1);
            this.zze(SystemClock.elapsedRealtime());
            com.google.android.gms.common.stats.zzb.zzaux().zza(this.mContext, (ServiceConnection)this);
            this.zzbws.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzail;
        synchronized (object) {
            com.google.android.gms.common.stats.zzb.zzaux().zza(this.mContext, (ServiceConnection)this);
            this.zzbws.destroy();
        }
    }

    public void onServiceDisconnected(ComponentName componentName) {
        zzkd.zzcw((String)"In-app billing service disconnected.");
        this.zzbws.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzbws.zzas(iBinder);
            this.zzpq();
            this.zzbwr = true;
            this.zzail.notify();
        }
    }

    protected void zzpq() {
        int n;
        Bundle bundle;
        if (this.zzbwu.isEmpty()) {
            return;
        }
        HashMap<String, zzf> hashMap = new HashMap<String, zzf>();
        for (zzf object2 : this.zzbwu) {
            hashMap.put(object2.zzbxh, object2);
        }
        Object object3 = null;
        while ((bundle = this.zzbws.zzn(this.mContext.getPackageName(), (String)object3)) != null && (n = zzu.zzga().zze(bundle)) == 0) {
            ArrayList arrayList = bundle.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList2 = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList3 = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            object3 = bundle.getString("INAPP_CONTINUATION_TOKEN");
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!hashMap.containsKey(arrayList.get(i))) continue;
                String string = (String)arrayList.get(i);
                String string2 = (String)arrayList2.get(i);
                String string3 = (String)arrayList3.get(i);
                zzf zzf2 = (zzf)hashMap.get(string);
                String string4 = zzu.zzga().zzby(string2);
                if (!zzf2.zzbxg.equals(string4)) continue;
                this.zza(zzf2, string2, string3);
                hashMap.remove(string);
            }
            if (object3 != null && !hashMap.isEmpty()) continue;
        }
        for (String string : hashMap.keySet()) {
            this.zzbwt.zza((zzf)hashMap.get(string));
        }
    }

    protected void zza(final zzf zzf2, String string, String string2) {
        final Intent intent = new Intent();
        zzu.zzga();
        intent.putExtra("RESPONSE_CODE", 0);
        zzu.zzga();
        intent.putExtra("INAPP_PURCHASE_DATA", string);
        zzu.zzga();
        intent.putExtra("INAPP_DATA_SIGNATURE", string2);
        zzkh.zzclc.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (zzc.this.zzbwv.zza(zzf2.zzbxg, -1, intent)) {
                        zzc.this.zzbld.zza((zzhr)new zzg(zzc.this.mContext, zzf2.zzbxh, true, -1, intent, zzf2));
                    } else {
                        zzc.this.zzbld.zza((zzhr)new zzg(zzc.this.mContext, zzf2.zzbxh, false, -1, intent, zzf2));
                    }
                }
                catch (RemoteException remoteException) {
                    zzkd.zzcx((String)"Fail to verify and dispatch pending transaction");
                }
            }
        });
    }

    private void zze(long l) {
        do {
            if (this.zzf(l)) continue;
            zzkd.v("Timeout waiting for pending transaction to be processed.");
        } while (!this.zzbwr);
    }

    private boolean zzf(long l) {
        long l2 = 60000L - (SystemClock.elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzail.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            zzkd.zzcx((String)"waitWithTimeout_lock interrupted");
        }
        return true;
    }
}

