/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.text.TextUtils;
import android.util.Base64;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkd;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

@zzin
public class zzl {
    public static boolean zzc(String string, String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string3)) {
            zzkd.e((String)"Purchase verification failed: missing data.");
            return false;
        }
        PublicKey publicKey = zzl.zzca(string);
        return zzl.zza(publicKey, string2, string3);
    }

    public static PublicKey zzca(String string) {
        try {
            byte[] byArray = Base64.decode((String)string, (int)0);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            zzkd.e((String)"Invalid key specification.");
            throw new IllegalArgumentException(invalidKeySpecException);
        }
    }

    public static boolean zza(PublicKey publicKey, String string, String string2) {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initVerify(publicKey);
            signature.update(string.getBytes());
            if (!signature.verify(Base64.decode((String)string2, (int)0))) {
                zzkd.e((String)"Signature verification failed.");
                return false;
            }
            return true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            zzkd.e((String)"NoSuchAlgorithmException.");
        }
        catch (InvalidKeyException invalidKeyException) {
            zzkd.e((String)"Invalid key specification.");
        }
        catch (SignatureException signatureException) {
            zzkd.e((String)"Signature exception.");
        }
        return false;
    }
}

