/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.webkit.CookieManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzas;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzga;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzkc;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkj;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzlb;
import org.json.JSONException;
import org.json.JSONObject;

@zzin
public class zzb
extends zzkc
implements zzc.zza {
    private final zza.zza zzcae;
    private final AdRequestInfoParcel.zza zzcaf;
    private final Object zzbxu = new Object();
    private final Context mContext;
    private final zzas zzbgd;
    private AdRequestInfoParcel zzbot;
    private Runnable zzbxt;
    zzkj zzcag;
    AdResponseParcel zzbxs;
    zzga zzboe;

    public zzb(Context context, AdRequestInfoParcel.zza zza2, zzas zzas2, zza.zza zza3) {
        this.zzcae = zza3;
        this.mContext = context;
        this.zzcaf = zza2;
        this.zzbgd = zzas2;
    }

    zzkj zza(VersionInfoParcel versionInfoParcel, zzla<AdRequestInfoParcel> zzla2) {
        return zzc.zza(this.mContext, versionInfoParcel, zzla2, this);
    }

    @Override
    public void zzew() {
        zzkd.zzcv((String)"AdLoaderBackgroundTask started.");
        this.zzbxt = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzb.this.zzbxu;
                synchronized (object) {
                    if (zzb.this.zzcag == null) {
                        return;
                    }
                    zzb.this.onStop();
                    zzb.this.zzd(2, "Timed out waiting for ad response.");
                }
            }
        };
        zzkh.zzclc.postDelayed(this.zzbxt, zzdc.zzbbg.get().longValue());
        final zzlb<AdRequestInfoParcel> zzlb2 = new zzlb<AdRequestInfoParcel>();
        long l = zzu.zzfu().elapsedRealtime();
        zzkg.zza(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzb.this.zzbxu;
                synchronized (object) {
                    zzb.this.zzcag = zzb.this.zza(((zzb)zzb.this).zzcaf.zzaow, zzlb2);
                    if (zzb.this.zzcag == null) {
                        zzb.this.zzd(0, "Could not start the ad request service.");
                        zzkh.zzclc.removeCallbacks(zzb.this.zzbxt);
                    }
                }
            }
        });
        zzan zzan2 = this.zzbgd.zzaw();
        String string = zzan2.zzb(this.mContext);
        this.zzbot = new AdRequestInfoParcel(this.zzcaf, string, l);
        zzlb2.zzg(this.zzbot);
    }

    private void zzd(int n, String string) {
        if (n == 3 || n == -1) {
            zzkd.zzcw((String)string);
        } else {
            zzkd.zzcx((String)string);
        }
        this.zzbxs = this.zzbxs == null ? new AdResponseParcel(n) : new AdResponseParcel(n, this.zzbxs.zzbns);
        AdRequestInfoParcel adRequestInfoParcel = this.zzbot != null ? this.zzbot : new AdRequestInfoParcel(this.zzcaf, null, -1L);
        zzju.zza zza2 = new zzju.zza(adRequestInfoParcel, this.zzbxs, this.zzboe, null, n, -1L, this.zzbxs.zzccc, null);
        this.zzcae.zza(zza2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(@NonNull AdResponseParcel adResponseParcel) {
        zzkd.zzcv((String)"Received ad response.");
        this.zzbxs = adResponseParcel;
        long l = zzu.zzfu().elapsedRealtime();
        Object object = this.zzbxu;
        synchronized (object) {
            this.zzcag = null;
        }
        zzu.zzft().zzd(this.mContext, this.zzbxs.zzcbq);
        object = null;
        try {
            if (this.zzbxs.errorCode != -2 && this.zzbxs.errorCode != -3) {
                int n = this.zzbxs.errorCode;
                throw new zza(new StringBuilder(66).append("There was a problem getting an ad response. ErrorCode: ").append(n).toString(), this.zzbxs.errorCode);
            }
            this.zzqv();
            if (this.zzbot.zzapa.zzaut != null) {
                object = this.zzb(this.zzbot);
            }
        }
        catch (zza zza2) {
            this.zzd(zza2.getErrorCode(), zza2.getMessage());
            zzkh.zzclc.removeCallbacks(this.zzbxt);
            return;
        }
        zzu.zzft().zzae(this.zzbxs.zzcci);
        JSONObject jSONObject = null;
        if (!TextUtils.isEmpty((CharSequence)this.zzbxs.zzccg)) {
            try {
                jSONObject = new JSONObject(this.zzbxs.zzccg);
            }
            catch (Exception exception) {
                zzkd.zzb((String)"Error parsing the JSON for Active View.", (Throwable)exception);
            }
        }
        zzju.zza zza3 = new zzju.zza(this.zzbot, this.zzbxs, this.zzboe, (AdSizeParcel)object, -2, l, this.zzbxs.zzccc, jSONObject);
        this.zzcae.zza(zza3);
        zzkh.zzclc.removeCallbacks(this.zzbxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzbxu;
        synchronized (object) {
            if (this.zzcag != null) {
                this.zzcag.cancel();
            }
        }
    }

    protected void zzqv() throws zza {
        if (this.zzbxs.errorCode == -3) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzbxs.body)) {
            throw new zza("No fill from ad server.", 3);
        }
        zzu.zzft().zzc(this.mContext, this.zzbxs.zzcaz);
        if (this.zzbxs.zzcby) {
            try {
                this.zzboe = new zzga(this.zzbxs.body);
                zzu.zzft().zzaf(this.zzboe.zzbnq);
            }
            catch (JSONException jSONException) {
                zzkd.zzb((String)"Could not parse mediation config.", (Throwable)jSONException);
                String string = String.valueOf(this.zzbxs.body);
                throw new zza(string.length() != 0 ? "Could not parse mediation config: ".concat(string) : new String("Could not parse mediation config: "), 0);
            }
        } else {
            zzu.zzft().zzaf(this.zzbxs.zzbnq);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzbxs.zzcbr) && zzdc.zzbdn.get().booleanValue()) {
            zzkd.zzcv((String)"Received cookie from server. Setting webview cookie in CookieManager.");
            CookieManager cookieManager = zzu.zzfs().zzao(this.mContext);
            if (cookieManager != null) {
                cookieManager.setCookie("googleads.g.doubleclick.net", this.zzbxs.zzcbr);
            }
        }
    }

    protected AdSizeParcel zzb(AdRequestInfoParcel adRequestInfoParcel) throws zza {
        int n;
        int n2;
        if (this.zzbxs.zzauv) {
            for (AdSizeParcel adSizeParcelArray : adRequestInfoParcel.zzapa.zzaut) {
                if (!adSizeParcelArray.zzauv) continue;
                return new AdSizeParcel(adSizeParcelArray, adRequestInfoParcel.zzapa.zzaut);
            }
        }
        if (this.zzbxs.zzccb == null) {
            throw new zza("The ad response must specify one of the supported ad sizes.", 0);
        }
        String[] stringArray = this.zzbxs.zzccb.split("x");
        if (stringArray.length != 2) {
            String string = String.valueOf(this.zzbxs.zzccb);
            throw new zza(string.length() != 0 ? "Invalid ad size format from the ad response: ".concat(string) : new String("Invalid ad size format from the ad response: "), 0);
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            String string = String.valueOf(this.zzbxs.zzccb);
            throw new zza(string.length() != 0 ? "Invalid ad size number from the ad response: ".concat(string) : new String("Invalid ad size number from the ad response: "), 0);
        }
        for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzapa.zzaut) {
            int n3;
            float f = this.mContext.getResources().getDisplayMetrics().density;
            int n4 = adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / f) : adSizeParcel.width;
            int n5 = n3 = adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / f) : adSizeParcel.height;
            if (n2 != n4 || n != n3) continue;
            return new AdSizeParcel(adSizeParcel, adRequestInfoParcel.zzapa.zzaut);
        }
        String string = String.valueOf(this.zzbxs.zzccb);
        throw new zza(string.length() != 0 ? "The ad size from the ad response was not one of the requested sizes: ".concat(string) : new String("The ad size from the ad response was not one of the requested sizes: "), 0);
    }

    @zzin
    static final class zza
    extends Exception {
        private final int zzbyi;

        public zza(String string, int n) {
            super(string);
            this.zzbyi = n;
        }

        public int getErrorCode() {
            return this.zzbyi;
        }
    }
}

