/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.request.zze;
import com.google.android.gms.ads.internal.request.zzg;
import com.google.android.gms.ads.internal.request.zzk;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzio;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkj;
import com.google.android.gms.internal.zzla;

@zzin
public abstract class zzd
implements zzc.zza,
zzkj<Void> {
    private final zzla<AdRequestInfoParcel> zzcaj;
    private final zzc.zza zzcak;
    private final Object zzail = new Object();

    public zzd(zzla<AdRequestInfoParcel> zzla2, zzc.zza zza2) {
        this.zzcaj = zzla2;
        this.zzcak = zza2;
    }

    public abstract void zzqw();

    public abstract zzk zzqx();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcak.zzb(adResponseParcel);
            this.zzqw();
        }
    }

    public Void zzpv() {
        final zzk zzk2 = this.zzqx();
        if (zzk2 == null) {
            this.zzcak.zzb(new AdResponseParcel(0));
            this.zzqw();
            return null;
        }
        this.zzcaj.zza(new zzla.zzc<AdRequestInfoParcel>(){

            public void zzc(AdRequestInfoParcel adRequestInfoParcel) {
                if (!zzd.this.zza(zzk2, adRequestInfoParcel)) {
                    zzd.this.zzqw();
                }
            }

            @Override
            public /* synthetic */ void zzd(Object object) {
                this.zzc((AdRequestInfoParcel)((Object)object));
            }
        }, new zzla.zza(){

            @Override
            public void run() {
                zzd.this.zzqw();
            }
        });
        return null;
    }

    @Override
    public void cancel() {
        this.zzqw();
    }

    boolean zza(zzk zzk2, AdRequestInfoParcel adRequestInfoParcel) {
        try {
            zzk2.zza(adRequestInfoParcel, new zzg(this));
            return true;
        }
        catch (RemoteException remoteException) {
            zzkd.zzd((String)"Could not fetch ad response from ad request service.", (Throwable)remoteException);
            zzu.zzft().zzb(remoteException, true);
        }
        catch (NullPointerException nullPointerException) {
            zzkd.zzd((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)nullPointerException);
            zzu.zzft().zzb(nullPointerException, true);
        }
        catch (SecurityException securityException) {
            zzkd.zzd((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)securityException);
            zzu.zzft().zzb(securityException, true);
        }
        catch (Throwable throwable) {
            zzkd.zzd((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)throwable);
            zzu.zzft().zzb(throwable, true);
        }
        this.zzcak.zzb(new AdResponseParcel(0));
        return false;
    }

    @Override
    public /* synthetic */ Object zzpy() {
        return this.zzpv();
    }

    @zzin
    public static class zzb
    extends zzd
    implements zzd.zzb,
    zzd.zzc {
        private Context mContext;
        private VersionInfoParcel zzalo;
        private zzla<AdRequestInfoParcel> zzcaj;
        private final zzc.zza zzcak;
        private final Object zzail = new Object();
        protected zze zzcan;
        private boolean zzcao;

        public zzb(Context context, VersionInfoParcel versionInfoParcel, zzla<AdRequestInfoParcel> zzla2, zzc.zza zza2) {
            super(zzla2, zza2);
            Looper looper;
            this.mContext = context;
            this.zzalo = versionInfoParcel;
            this.zzcaj = zzla2;
            this.zzcak = zza2;
            if (zzdc.zzayy.get().booleanValue()) {
                this.zzcao = true;
                looper = zzu.zzgc().zztq();
            } else {
                looper = context.getMainLooper();
            }
            this.zzcan = new zze(context, looper, this, this, this.zzalo.zzcnl);
            this.connect();
        }

        protected void connect() {
            this.zzcan.zzarx();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public zzk zzqx() {
            Object object = this.zzail;
            synchronized (object) {
                try {
                    return this.zzcan.zzrb();
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzqw() {
            Object object = this.zzail;
            synchronized (object) {
                if (this.zzcan.isConnected() || this.zzcan.isConnecting()) {
                    this.zzcan.disconnect();
                }
                Binder.flushPendingCommands();
                if (this.zzcao) {
                    zzu.zzgc().zztr();
                    this.zzcao = false;
                }
            }
        }

        zzkj zzqy() {
            return new zza(this.mContext, this.zzcaj, this.zzcak);
        }

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzkd.zzcv((String)"Cannot connect to remote service, fallback to local instance.");
            zzkj zzkj2 = this.zzqy();
            zzkj2.zzpy();
            Bundle bundle = new Bundle();
            bundle.putString("action", "gms_connection_failed_fallback_to_local");
            zzu.zzfq().zzb(this.mContext, this.zzalo.zzcs, "gmob-apps", bundle, true);
        }

        public void onConnected(Bundle bundle) {
            Void cfr_ignored_0 = (Void)((zzd)this).zzpy();
        }

        public void onConnectionSuspended(int n) {
            zzkd.zzcv((String)"Disconnected from remote ad request service.");
        }

        @Override
        public /* synthetic */ Object zzpy() {
            return super.zzpv();
        }
    }

    @zzin
    public static final class zza
    extends zzd {
        private final Context mContext;

        public zza(Context context, zzla<AdRequestInfoParcel> zzla2, zzc.zza zza2) {
            super(zzla2, zza2);
            this.mContext = context;
        }

        @Override
        public zzk zzqx() {
            zzcv zzcv2 = new zzcv(zzdc.zzaxy.get());
            return zzip.zza(this.mContext, zzcv2, zzio.zzrf());
        }

        @Override
        public void zzqw() {
        }

        @Override
        public /* synthetic */ Object zzpy() {
            return super.zzpv();
        }
    }
}

