/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzeq;
import com.google.android.gms.internal.zzeu;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zziq;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzkc;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkl;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzlh;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzin
public class zzn
extends zzkc {
    static final long zzcdf = TimeUnit.SECONDS.toMillis(10L);
    private static final Object zzamr = new Object();
    static boolean zzcdg = false;
    private static zzfs zzbyv = null;
    private static zzeq zzcdh = null;
    private static zzeu zzcdi = null;
    private static zzep zzcdj = null;
    private final zza.zza zzcae;
    private final AdRequestInfoParcel.zza zzcaf;
    private final Object zzbxu = new Object();
    private final Context mContext;
    private zzfs.zzc zzcdk;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzn(Context context, AdRequestInfoParcel.zza zza2, zza.zza zza3) {
        super(true);
        this.zzcae = zza3;
        this.mContext = context;
        this.zzcaf = zza2;
        Object object = zzamr;
        synchronized (object) {
            if (!zzcdg) {
                zzcdi = new zzeu();
                zzcdh = new zzeq(context.getApplicationContext(), zza2.zzaow);
                zzcdj = new zzc();
                zzbyv = new zzfs(this.mContext.getApplicationContext(), this.zzcaf.zzaow, zzdc.zzaxy.get(), new zzb(), new zza());
                zzcdg = true;
            }
        }
    }

    protected static void zzb(zzfp zzfp2) {
        zzfp2.zza("/loadAd", zzcdi);
        zzfp2.zza("/fetchHttpRequest", zzcdh);
        zzfp2.zza("/invalidRequest", zzcdj);
    }

    protected static void zzc(zzfp zzfp2) {
        zzfp2.zzb("/loadAd", zzcdi);
        zzfp2.zzb("/fetchHttpRequest", zzcdh);
        zzfp2.zzb("/invalidRequest", zzcdj);
    }

    @Override
    public void zzew() {
        zzkd.zzcv((String)"SdkLessAdLoaderBackgroundTask started.");
        AdRequestInfoParcel adRequestInfoParcel = new AdRequestInfoParcel(this.zzcaf, null, -1L);
        AdResponseParcel adResponseParcel = this.zze(adRequestInfoParcel);
        long l = zzu.zzfu().elapsedRealtime();
        final zzju.zza zza2 = new zzju.zza(adRequestInfoParcel, adResponseParcel, null, null, adResponseParcel.errorCode, l, adResponseParcel.zzccc, null);
        com.google.android.gms.ads.internal.util.client.zza.zzcnb.post(new Runnable(){

            @Override
            public void run() {
                zzn.this.zzcae.zza(zza2);
                if (zzn.this.zzcdk != null) {
                    zzn.this.zzcdk.release();
                    zzn.this.zzcdk = null;
                }
            }
        });
    }

    private AdResponseParcel zze(AdRequestInfoParcel adRequestInfoParcel) {
        JSONObject jSONObject;
        final String string = zzu.zzfq().zzte();
        final JSONObject jSONObject2 = this.zza(adRequestInfoParcel, string);
        if (jSONObject2 == null) {
            return new AdResponseParcel(0);
        }
        long l = zzu.zzfu().elapsedRealtime();
        Future<JSONObject> future = zzcdi.zzaw(string);
        com.google.android.gms.ads.internal.util.client.zza.zzcnb.post(new Runnable(){

            @Override
            public void run() {
                zzn.this.zzcdk = zzbyv.zzma();
                zzn.this.zzcdk.zza(new zzla.zzc<zzft>(){

                    public void zzb(zzft zzft2) {
                        try {
                            zzft2.zza("AFMA_getAdapterLessMediationAd", jSONObject2);
                        }
                        catch (Exception exception) {
                            zzkd.zzb((String)"Error requesting an ad url", (Throwable)exception);
                            zzcdi.zzax(string);
                        }
                    }

                    @Override
                    public /* synthetic */ void zzd(Object object) {
                        this.zzb((zzft)object);
                    }
                }, new zzla.zza(){

                    @Override
                    public void run() {
                        zzcdi.zzax(string);
                    }
                });
            }
        });
        long l2 = zzcdf - (zzu.zzfu().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new AdResponseParcel(-1);
        }
        catch (TimeoutException timeoutException) {
            return new AdResponseParcel(2);
        }
        catch (ExecutionException executionException) {
            return new AdResponseParcel(0);
        }
        if (jSONObject == null) {
            return new AdResponseParcel(-1);
        }
        AdResponseParcel adResponseParcel = zziq.zza(this.mContext, adRequestInfoParcel, jSONObject.toString());
        if (adResponseParcel.errorCode != -3 && TextUtils.isEmpty((CharSequence)adResponseParcel.body)) {
            return new AdResponseParcel(3);
        }
        return adResponseParcel;
    }

    private JSONObject zza(AdRequestInfoParcel adRequestInfoParcel, String string) {
        Bundle bundle = adRequestInfoParcel.zzcar.extras.getBundle("sdk_less_server_data");
        String string2 = adRequestInfoParcel.zzcar.extras.getString("sdk_less_network_id");
        if (bundle == null) {
            return null;
        }
        JSONObject jSONObject = zziq.zza(this.mContext, adRequestInfoParcel, zzu.zzfw().zzy(this.mContext), null, null, new zzcv(zzdc.zzaxy.get()), null, new ArrayList<String>(), null, null);
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            zzkd.zzd((String)"Cannot get advertising id info", (Throwable)throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string);
        hashMap.put("network_id", string2);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzu.zzfq().zzam(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzbxu;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zza.zzcnb.post(new Runnable(){

                @Override
                public void run() {
                    if (zzn.this.zzcdk != null) {
                        zzn.this.zzcdk.release();
                        zzn.this.zzcdk = null;
                    }
                }
            });
        }
    }

    public static class zza
    implements zzkl<zzfp> {
        public void zza(zzfp zzfp2) {
            zzn.zzc(zzfp2);
        }

        @Override
        public /* synthetic */ void zzd(Object object) {
            this.zza((zzfp)object);
        }
    }

    public static class zzb
    implements zzkl<zzfp> {
        public void zza(zzfp zzfp2) {
            zzn.zzb(zzfp2);
        }

        @Override
        public /* synthetic */ void zzd(Object object) {
            this.zza((zzfp)object);
        }
    }

    public static class zzc
    implements zzep {
        @Override
        public void zza(zzlh zzlh2, Map<String, String> map) {
            String string = map.get("request_id");
            String string2 = map.get("errors");
            String string3 = String.valueOf(string2);
            zzkd.zzcx((String)(string3.length() != 0 ? "Invalid request: ".concat(string3) : new String("Invalid request: ")));
            zzcdi.zzax(string);
        }
    }
}

