/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Debug;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.ThinAdSizeParcel;
import com.google.android.gms.ads.internal.client.VideoOptionsParcel;
import com.google.android.gms.ads.internal.client.zzab;
import com.google.android.gms.ads.internal.client.zzf;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.client.zzw;
import com.google.android.gms.ads.internal.client.zzy;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzcg;
import com.google.android.gms.internal.zzcl;
import com.google.android.gms.internal.zzco;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzdo;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzho;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzic;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzjd;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzkd;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;

@zzin
public abstract class zza
extends zzu.zza
implements com.google.android.gms.ads.internal.client.zza,
zzp,
zza.zza,
zzel,
zzic.zza,
zzjz {
    protected zzdk zzajn;
    protected zzdi zzajo;
    protected zzdi zzajp;
    protected boolean zzajq = false;
    protected final zzr zzajr;
    protected final zzv zzajs;
    @Nullable
    protected transient AdRequestParcel zzajt;
    protected final zzcg zzaju;
    protected final zzd zzajv;

    zza(zzv zzv2, @Nullable zzr zzr2, zzd zzd2) {
        this.zzajs = zzv2;
        this.zzajr = zzr2 != null ? zzr2 : new zzr(this);
        this.zzajv = zzd2;
        zzu.zzfq().zzad(this.zzajs.zzagf);
        zzu.zzft().zzb(this.zzajs.zzagf, this.zzajs.zzaow);
        this.zzaju = zzu.zzft().zzsu();
        this.zzdk();
    }

    private void zzdk() {
        if (zzdc.zzbcj.get().booleanValue()) {
            Timer timer = new Timer();
            CountDownLatch countDownLatch = new CountDownLatch(zzdc.zzbcl.get());
            TimerTask timerTask = this.zza(timer, countDownLatch);
            timer.schedule(timerTask, 0L, (long)zzdc.zzbck.get());
        }
    }

    private TimerTask zza(final Timer timer, final CountDownLatch countDownLatch) {
        return new TimerTask(){

            @Override
            public void run() {
                if ((long)zzdc.zzbcl.get().intValue() != countDownLatch.getCount()) {
                    zzkd.zzcv((String)"Stopping method tracing");
                    Debug.stopMethodTracing();
                    if (countDownLatch.getCount() == 0L) {
                        timer.cancel();
                        return;
                    }
                }
                String string = String.valueOf(zza.this.zzajs.zzagf.getPackageName()).concat("_adsTrace_");
                try {
                    zzkd.zzcv((String)"Starting method tracing");
                    countDownLatch.countDown();
                    long l = zzu.zzfu().currentTimeMillis();
                    Debug.startMethodTracing((String)new StringBuilder(20 + String.valueOf(string).length()).append(string).append(l).toString(), (int)zzdc.zzbcm.get());
                }
                catch (Exception exception) {
                    zzkd.zzd((String)"Exception occurred while starting method tracing.", (Throwable)exception);
                    return;
                }
            }
        };
    }

    public void zzdl() {
        this.zzajn = new zzdk(zzdc.zzaze.get(), "load_ad", this.zzajs.zzapa.zzaur);
        this.zzajo = new zzdi(-1L, null, null);
        this.zzajp = new zzdi(-1L, null, null);
    }

    public void destroy() {
        com.google.android.gms.common.internal.zzab.zzhi((String)"destroy must be called on the main UI thread.");
        this.zzajr.cancel();
        this.zzaju.zzj(this.zzajs.zzapb);
        this.zzajs.destroy();
    }

    public com.google.android.gms.dynamic.zzd zzdm() {
        com.google.android.gms.common.internal.zzab.zzhi((String)"getAdFrame must be called on the main UI thread.");
        return zze.zzac((Object)((Object)this.zzajs.zzaox));
    }

    @Nullable
    public AdSizeParcel zzdn() {
        com.google.android.gms.common.internal.zzab.zzhi((String)"getAdSize must be called on the main UI thread.");
        return this.zzajs.zzapa == null ? null : new ThinAdSizeParcel(this.zzajs.zzapa);
    }

    public boolean isReady() {
        com.google.android.gms.common.internal.zzab.zzhi((String)"isLoaded must be called on the main UI thread.");
        return this.zzajs.zzaoy == null && this.zzajs.zzaoz == null && this.zzajs.zzapb != null;
    }

    public void setManualImpressionsEnabled(boolean bl) {
        throw new UnsupportedOperationException("Attempt to call setManualImpressionsEnabled for an unsupported ad type.");
    }

    private AdRequestParcel zza(AdRequestParcel adRequestParcel) {
        if (zzi.zzcl((Context)this.zzajs.zzagf) && adRequestParcel.zzatu != null) {
            return new zzf(adRequestParcel).zza(null).zzig();
        }
        return adRequestParcel;
    }

    public boolean zzb(AdRequestParcel adRequestParcel) {
        com.google.android.gms.common.internal.zzab.zzhi((String)"loadAd must be called on the main UI thread.");
        adRequestParcel = this.zza(adRequestParcel);
        if (this.zzajs.zzaoy != null || this.zzajs.zzaoz != null) {
            if (this.zzajt != null) {
                zzkd.zzcx((String)"Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            } else {
                zzkd.zzcx((String)"Loading already in progress, saving this object for future refreshes.");
            }
            this.zzajt = adRequestParcel;
            return false;
        }
        zzkd.zzcw((String)"Starting ad request.");
        this.zzdl();
        this.zzajo = this.zzajn.zzkg();
        if (!adRequestParcel.zzatp) {
            String string = String.valueOf(zzm.zziw().zzaq(this.zzajs.zzagf));
            zzkd.zzcw((String)new StringBuilder(71 + String.valueOf(string).length()).append("Use AdRequest.Builder.addTestDevice(\"").append(string).append("\") to get test ads on this device.").toString());
        }
        this.zzajq = this.zza(adRequestParcel, this.zzajn);
        return this.zzajq;
    }

    protected abstract boolean zza(AdRequestParcel var1, zzdk var2);

    @Override
    public void zza(zzju.zza zza2) {
        long l;
        if (zza2.zzciq.zzccc != -1L && !TextUtils.isEmpty((CharSequence)zza2.zzciq.zzccl) && (l = this.zzs(zza2.zzciq.zzccl)) != -1L) {
            zzdi zzdi2 = this.zzajn.zzc(zza2.zzciq.zzccc + l);
            this.zzajn.zza(zzdi2, "stc");
        }
        this.zzajn.zzas(zza2.zzciq.zzccl);
        this.zzajn.zza(this.zzajo, "arf");
        this.zzajp = this.zzajn.zzkg();
        this.zzajn.zzh("gqi", zza2.zzciq.zzccm);
        this.zzajs.zzaoy = null;
        this.zzajs.zzapc = zza2;
        this.zza(zza2, this.zzajn);
    }

    protected abstract void zza(zzju.zza var1, zzdk var2);

    boolean zza(zzju zzju2) {
        return false;
    }

    @Override
    public void zzb(zzju zzju2) {
        this.zzajn.zza(this.zzajp, "awr");
        this.zzajs.zzaoz = null;
        if (zzju2.errorCode != -2 && zzju2.errorCode != 3) {
            zzu.zzft().zzb(this.zzajs.zzgl());
        }
        if (zzju2.errorCode == -1) {
            this.zzajq = false;
            return;
        }
        if (this.zza(zzju2)) {
            zzkd.zzcv((String)"Ad refresh scheduled.");
        }
        if (zzju2.errorCode != -2) {
            this.zzh(zzju2.errorCode);
            return;
        }
        if (this.zzajs.zzapu == null) {
            this.zzajs.zzapu = new zzka(this.zzajs.zzaou);
        }
        this.zzaju.zzi(this.zzajs.zzapb);
        if (this.zza(this.zzajs.zzapb, zzju2)) {
            this.zzajs.zzapb = zzju2;
            this.zzajs.zzgu();
            this.zzajn.zzh("is_mraid", this.zzajs.zzapb.zzho() ? "1" : "0");
            this.zzajn.zzh("is_mediation", this.zzajs.zzapb.zzcby ? "1" : "0");
            if (this.zzajs.zzapb.zzbtm != null && this.zzajs.zzapb.zzbtm.zzuj() != null) {
                this.zzajn.zzh("is_delay_pl", this.zzajs.zzapb.zzbtm.zzuj().zzuy() ? "1" : "0");
            }
            this.zzajn.zza(this.zzajo, "ttc");
            if (zzu.zzft().zzsl() != null) {
                zzu.zzft().zzsl().zza(this.zzajn);
            }
            if (this.zzajs.zzgp()) {
                this.zzdu();
            }
        }
        if (zzju2.zzbnp != null) {
            zzu.zzfq().zza(this.zzajs.zzagf, zzju2.zzbnp);
        }
    }

    protected abstract boolean zza(@Nullable zzju var1, zzju var2);

    public void onAdClicked() {
        if (this.zzajs.zzapb == null) {
            zzkd.zzcx((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        zzkd.zzcv((String)"Pinging click URLs.");
        this.zzajs.zzapd.zzrz();
        if (this.zzajs.zzapb.zzbnm != null) {
            zzu.zzfq().zza(this.zzajs.zzagf, this.zzajs.zzaow.zzcs, this.zzajs.zzapb.zzbnm);
        }
        if (this.zzajs.zzape != null) {
            try {
                this.zzajs.zzape.onAdClicked();
            }
            catch (RemoteException remoteException) {
                zzkd.zzd((String)"Could not notify onAdClicked event.", (Throwable)remoteException);
            }
        }
    }

    @Override
    public void zzdo() {
        this.zzds();
    }

    @Override
    public void onAppEvent(String string, @Nullable String string2) {
        if (this.zzajs.zzapg != null) {
            try {
                this.zzajs.zzapg.onAppEvent(string, string2);
            }
            catch (RemoteException remoteException) {
                zzkd.zzd((String)"Could not call the AppEventListener.", (Throwable)remoteException);
            }
        }
    }

    public void zzdp() {
        com.google.android.gms.common.internal.zzab.zzhi((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzajs.zzapb == null) {
            zzkd.zzcx((String)"Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        zzkd.zzcv((String)"Pinging manual tracking URLs.");
        if (this.zzajs.zzapb.zzcca != null && !this.zzajs.zzapb.zzcio) {
            zzu.zzfq().zza(this.zzajs.zzagf, this.zzajs.zzaow.zzcs, this.zzajs.zzapb.zzcca);
            this.zzajs.zzapb.zzcio = true;
        }
    }

    public void pause() {
        com.google.android.gms.common.internal.zzab.zzhi((String)"pause must be called on the main UI thread.");
    }

    public void resume() {
        com.google.android.gms.common.internal.zzab.zzhi((String)"resume must be called on the main UI thread.");
    }

    protected boolean zzc(AdRequestParcel adRequestParcel) {
        if (this.zzajs.zzaox == null) {
            return false;
        }
        ViewParent viewParent = this.zzajs.zzaox.getParent();
        if (!(viewParent instanceof View)) {
            return false;
        }
        View view = (View)viewParent;
        return zzu.zzfq().zza(view, view.getContext());
    }

    public void zzd(AdRequestParcel adRequestParcel) {
        if (this.zzc(adRequestParcel)) {
            this.zzb(adRequestParcel);
        } else {
            zzkd.zzcw((String)"Ad is not visible. Not refreshing ad.");
            this.zzajr.zzg(adRequestParcel);
        }
    }

    public void zza(zzq zzq2) {
        com.google.android.gms.common.internal.zzab.zzhi((String)"setAdListener must be called on the main UI thread.");
        this.zzajs.zzapf = zzq2;
    }

    public void zza(com.google.android.gms.ads.internal.reward.client.zzd zzd2) {
        com.google.android.gms.common.internal.zzab.zzhi((String)"setRewardedVideoAdListener can only be called from the UI thread.");
        this.zzajs.zzapr = zzd2;
    }

    public void setUserId(String string) {
        zzkd.zzcx((String)"RewardedVideoAd.setUserId() is deprecated. Please do not call this method.");
    }

    public void zza(com.google.android.gms.ads.internal.client.zzp zzp2) {
        com.google.android.gms.common.internal.zzab.zzhi((String)"setAdListener must be called on the main UI thread.");
        this.zzajs.zzape = zzp2;
    }

    public void zza(AdSizeParcel adSizeParcel) {
        com.google.android.gms.common.internal.zzab.zzhi((String)"setAdSize must be called on the main UI thread.");
        this.zzajs.zzapa = adSizeParcel;
        if (this.zzajs.zzapb != null && this.zzajs.zzapb.zzbtm != null && this.zzajs.zzapw == 0) {
            this.zzajs.zzapb.zzbtm.zza(adSizeParcel);
        }
        if (this.zzajs.zzaox == null) {
            return;
        }
        if (this.zzajs.zzaox.getChildCount() > 1) {
            this.zzajs.zzaox.removeView(this.zzajs.zzaox.getNextView());
        }
        this.zzajs.zzaox.setMinimumWidth(adSizeParcel.widthPixels);
        this.zzajs.zzaox.setMinimumHeight(adSizeParcel.heightPixels);
        this.zzajs.zzaox.requestLayout();
    }

    public void zza(zzw zzw2) {
        com.google.android.gms.common.internal.zzab.zzhi((String)"setAppEventListener must be called on the main UI thread.");
        this.zzajs.zzapg = zzw2;
    }

    public void zza(zzho zzho2) {
        throw new IllegalStateException("setInAppPurchaseListener is not supported for current ad type");
    }

    public void zza(zzdo zzdo2) {
        throw new IllegalStateException("setOnCustomRenderedAdLoadedListener is not supported for current ad type");
    }

    public void zza(zzhs zzhs2, String string) {
        throw new IllegalStateException("setPlayStorePurchaseParams is not supported for current ad type");
    }

    public void zza(zzy zzy2) {
        com.google.android.gms.common.internal.zzab.zzhi((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzajs.zzaph = zzy2;
    }

    public void stopLoading() {
        com.google.android.gms.common.internal.zzab.zzhi((String)"stopLoading must be called on the main UI thread.");
        this.zzajq = false;
        this.zzajs.zzi(true);
    }

    public boolean isLoading() {
        return this.zzajq;
    }

    public zzab zzdq() {
        return null;
    }

    public void zza(@Nullable VideoOptionsParcel videoOptionsParcel) {
        com.google.android.gms.common.internal.zzab.zzhi((String)"setVideoOptions must be called on the main UI thread.");
        this.zzajs.zzapp = videoOptionsParcel;
    }

    Bundle zza(@Nullable zzco zzco2) {
        if (zzco2 == null) {
            return null;
        }
        if (zzco2.zzid()) {
            zzco2.wakeup();
        }
        zzcl zzcl2 = zzco2.zzib();
        String string = null;
        String string2 = null;
        if (zzcl2 != null) {
            string = zzcl2.zzhr();
            string2 = zzcl2.zzhs();
            String string3 = String.valueOf(zzcl2.toString());
            zzkd.zzcv((String)(string3.length() != 0 ? "In AdManager: loadAd, ".concat(string3) : new String("In AdManager: loadAd, ")));
            if (string != null) {
                zzu.zzft().zzcm(string);
            }
        } else {
            string = zzu.zzft().zzsp();
        }
        if (string != null) {
            Bundle bundle = new Bundle(1);
            bundle.putString("fingerprint", string);
            if (!string.equals(string2)) {
                bundle.putString("v_fp", string2);
            }
            return bundle;
        }
        return null;
    }

    long zzs(String string) {
        int n = string.indexOf("ufe");
        int n2 = string.indexOf(44, n);
        if (n2 == -1) {
            n2 = string.length();
        }
        try {
            return Long.parseLong(string.substring(n + 4, n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzkd.zzcx((String)"Invalid index for Url fetch time in CSI latency info.");
        }
        catch (NumberFormatException numberFormatException) {
            zzkd.zzcx((String)"Cannot find valid format of Url fetch time in CSI latency info.");
        }
        return -1L;
    }

    protected void zzb(View view) {
        zzv.zza zza2 = this.zzajs.zzaox;
        if (zza2 != null) {
            zza2.addView(view, zzu.zzfs().zztm());
        }
    }

    protected void zzdr() {
        zzkd.zzcw((String)"Ad closing.");
        if (this.zzajs.zzapf != null) {
            try {
                this.zzajs.zzapf.onAdClosed();
            }
            catch (RemoteException remoteException) {
                zzkd.zzd((String)"Could not call AdListener.onAdClosed().", (Throwable)remoteException);
            }
        }
        if (this.zzajs.zzapr != null) {
            try {
                this.zzajs.zzapr.onRewardedVideoAdClosed();
            }
            catch (RemoteException remoteException) {
                zzkd.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdClosed().", (Throwable)remoteException);
            }
        }
    }

    protected void zzds() {
        zzkd.zzcw((String)"Ad leaving application.");
        if (this.zzajs.zzapf != null) {
            try {
                this.zzajs.zzapf.onAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzkd.zzd((String)"Could not call AdListener.onAdLeftApplication().", (Throwable)remoteException);
            }
        }
        if (this.zzajs.zzapr != null) {
            try {
                this.zzajs.zzapr.onRewardedVideoAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzkd.zzd((String)"Could not call  RewardedVideoAdListener.onRewardedVideoAdLeftApplication().", (Throwable)remoteException);
            }
        }
    }

    protected void zzdt() {
        zzkd.zzcw((String)"Ad opening.");
        if (this.zzajs.zzapf != null) {
            try {
                this.zzajs.zzapf.onAdOpened();
            }
            catch (RemoteException remoteException) {
                zzkd.zzd((String)"Could not call AdListener.onAdOpened().", (Throwable)remoteException);
            }
        }
        if (this.zzajs.zzapr != null) {
            try {
                this.zzajs.zzapr.onRewardedVideoAdOpened();
            }
            catch (RemoteException remoteException) {
                zzkd.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdOpened().", (Throwable)remoteException);
            }
        }
    }

    protected void zzdu() {
        zzkd.zzcw((String)"Ad finished loading.");
        this.zzajq = false;
        if (this.zzajs.zzapf != null) {
            try {
                this.zzajs.zzapf.onAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzkd.zzd((String)"Could not call AdListener.onAdLoaded().", (Throwable)remoteException);
            }
        }
        if (this.zzajs.zzapr != null) {
            try {
                this.zzajs.zzapr.onRewardedVideoAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzkd.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdLoaded().", (Throwable)remoteException);
            }
        }
    }

    protected void zzh(int n) {
        zzkd.zzcx((String)new StringBuilder(30).append("Failed to load ad: ").append(n).toString());
        this.zzajq = false;
        if (this.zzajs.zzapf != null) {
            try {
                this.zzajs.zzapf.onAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzkd.zzd((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
            }
        }
        if (this.zzajs.zzapr != null) {
            try {
                this.zzajs.zzapr.onRewardedVideoAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzkd.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdFailedToLoad().", (Throwable)remoteException);
            }
        }
    }

    protected void zzdv() {
        if (this.zzajs.zzapr == null) {
            return;
        }
        try {
            this.zzajs.zzapr.onRewardedVideoStarted();
        }
        catch (RemoteException remoteException) {
            zzkd.zzd((String)"Could not call RewardedVideoAdListener.onVideoStarted().", (Throwable)remoteException);
        }
    }

    protected void zza(@Nullable RewardItemParcel rewardItemParcel) {
        if (this.zzajs.zzapr == null) {
            return;
        }
        try {
            String string = "";
            int n = 0;
            if (rewardItemParcel != null) {
                string = rewardItemParcel.type;
                n = rewardItemParcel.zzcid;
            }
            this.zzajs.zzapr.zza((com.google.android.gms.ads.internal.reward.client.zza)new zzjd(string, n));
        }
        catch (RemoteException remoteException) {
            zzkd.zzd((String)"Could not call RewardedVideoAdListener.onRewarded().", (Throwable)remoteException);
        }
    }

    protected void zzc(@Nullable zzju zzju2) {
        if (zzju2 == null) {
            zzkd.zzcx((String)"Ad state was null when trying to ping impression URLs.");
            return;
        }
        zzkd.zzcv((String)"Pinging Impression URLs.");
        this.zzajs.zzapd.zzry();
        if (zzju2.zzbnn != null && !zzju2.zzcin) {
            zzu.zzfq().zza(this.zzajs.zzagf, this.zzajs.zzaow.zzcs, zzju2.zzbnn);
            zzju2.zzcin = true;
        }
    }

    @Override
    public void zza(HashSet<zzjv> hashSet) {
        this.zzajs.zza(hashSet);
    }
}

