/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.View;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.purchase.GInAppPurchaseManagerInfoParcel;
import com.google.android.gms.ads.internal.purchase.zzc;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzj;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.CapabilityParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzer;
import com.google.android.gms.internal.zzgb;
import com.google.android.gms.internal.zzgj;
import com.google.android.gms.internal.zzhl;
import com.google.android.gms.internal.zzhn;
import com.google.android.gms.internal.zzho;
import com.google.android.gms.internal.zzhr;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzlh;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Future;

@zzin
public abstract class zzb
extends zza
implements zzg,
zzj,
zzs,
zzer,
zzgb {
    protected final zzgj zzajz;
    private final Messenger mMessenger;
    protected transient boolean zzaka;

    public zzb(Context context, AdSizeParcel adSizeParcel, String string, zzgj zzgj2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        this(new zzv(context, adSizeParcel, string, versionInfoParcel), zzgj2, null, zzd2);
    }

    protected zzb(zzv zzv2, zzgj zzgj2, @Nullable zzr zzr2, zzd zzd2) {
        super(zzv2, zzr2, zzd2);
        this.zzajz = zzgj2;
        this.mMessenger = new Messenger((Handler)new zzhl(this.zzajs.zzagf));
        this.zzaka = false;
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel, zzdk zzdk2) {
        if (!this.zzdw()) {
            return false;
        }
        Bundle bundle = null;
        bundle = this.zza(zzu.zzft().zzaa(this.zzajs.zzagf));
        this.zzajr.cancel();
        this.zzajs.zzapw = 0;
        zzjw zzjw2 = null;
        if (zzdc.zzbct.get().booleanValue()) {
            zzjw2 = zzu.zzft().zzst();
            zzu.zzgi().zza(this.zzajs.zzagf, this.zzajs.zzaow, false, zzjw2, zzjw2 == null ? null : zzjw2.zzsh(), this.zzajs.zzaou);
        }
        AdRequestInfoParcel.zza zza2 = this.zza(adRequestParcel, bundle, zzjw2);
        zzdk2.zzh("seq_num", zza2.zzcau);
        zzdk2.zzh("request_id", zza2.zzcbg);
        zzdk2.zzh("session_id", zza2.zzcav);
        if (zza2.zzcas != null) {
            zzdk2.zzh("app_version", String.valueOf(zza2.zzcas.versionCode));
        }
        this.zzajs.zzaoy = zzu.zzfm().zza(this.zzajs.zzagf, zza2, this.zzajs.zzaov, this);
        return true;
    }

    @Override
    public void zzb(zzju zzju2) {
        super.zzb(zzju2);
        if (zzju2.zzbon != null) {
            zzkd.zzcv((String)"Pinging network fill URLs.");
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaow.zzcs, zzju2, this.zzajs.zzaou, false, zzju2.zzbon.zzbnb);
            if (zzju2.zzcig.zzbnp != null && zzju2.zzcig.zzbnp.size() > 0) {
                zzkd.zzcv((String)"Pinging urls remotely");
                zzu.zzfq().zza(this.zzajs.zzagf, zzju2.zzcig.zzbnp);
            }
        }
        if (zzju2.errorCode == 3 && zzju2.zzcig != null && zzju2.zzcig.zzbno != null) {
            zzkd.zzcv((String)"Pinging no fill URLs.");
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaow.zzcs, zzju2, this.zzajs.zzaou, false, zzju2.zzcig.zzbno);
        }
    }

    @Override
    protected boolean zza(@Nullable zzju zzju2, zzju zzju3) {
        if (zzju2 != null && zzju2.zzboq != null) {
            zzju2.zzboq.zza((zzgb)null);
        }
        if (zzju3.zzboq != null) {
            zzju3.zzboq.zza(this);
        }
        int n = 0;
        int n2 = 0;
        if (zzju3.zzcig != null) {
            n = zzju3.zzcig.zzbny;
            n2 = zzju3.zzcig.zzbnz;
        }
        this.zzajs.zzapu.zzh(n, n2);
        return true;
    }

    @Override
    public void onAdClicked() {
        if (this.zzajs.zzapb == null) {
            zzkd.zzcx((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        if (this.zzajs.zzapb.zzcig != null && this.zzajs.zzapb.zzcig.zzbnm != null) {
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaow.zzcs, this.zzajs.zzapb, this.zzajs.zzaou, false, this.zzajs.zzapb.zzcig.zzbnm);
        }
        if (this.zzajs.zzapb.zzbon != null && this.zzajs.zzapb.zzbon.zzbmz != null) {
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaow.zzcs, this.zzajs.zzapb, this.zzajs.zzaou, false, this.zzajs.zzapb.zzbon.zzbmz);
        }
        super.onAdClicked();
    }

    @Override
    boolean zza(zzju zzju2) {
        AdRequestParcel adRequestParcel;
        boolean bl = false;
        if (this.zzajt != null) {
            adRequestParcel = this.zzajt;
            this.zzajt = null;
        } else {
            adRequestParcel = zzju2.zzcar;
            bl = adRequestParcel.extras != null ? adRequestParcel.extras.getBoolean("_noRefresh", false) : false;
        }
        return this.zza(adRequestParcel, zzju2, bl);
    }

    protected boolean zza(AdRequestParcel adRequestParcel, zzju zzju2, boolean bl) {
        if (!bl && this.zzajs.zzgp()) {
            if (zzju2.zzbns > 0L) {
                this.zzajr.zza(adRequestParcel, zzju2.zzbns);
            } else if (zzju2.zzcig != null && zzju2.zzcig.zzbns > 0L) {
                this.zzajr.zza(adRequestParcel, zzju2.zzcig.zzbns);
            } else if (!zzju2.zzcby && zzju2.errorCode == 2) {
                this.zzajr.zzg(adRequestParcel);
            }
        }
        return this.zzajr.zzfc();
    }

    @Override
    public void pause() {
        zzab.zzhi((String)"pause must be called on the main UI thread.");
        if (this.zzajs.zzapb != null && this.zzajs.zzapb.zzbtm != null && this.zzajs.zzgp()) {
            zzu.zzfs().zzi(this.zzajs.zzapb.zzbtm);
        }
        if (this.zzajs.zzapb != null && this.zzajs.zzapb.zzboo != null) {
            try {
                this.zzajs.zzapb.zzboo.pause();
            }
            catch (RemoteException remoteException) {
                zzkd.zzcx((String)"Could not pause mediation adapter.");
            }
        }
        this.zzaju.zzk(this.zzajs.zzapb);
        this.zzajr.pause();
    }

    @Override
    public void resume() {
        zzab.zzhi((String)"resume must be called on the main UI thread.");
        zzlh zzlh2 = null;
        if (this.zzajs.zzapb != null && this.zzajs.zzapb.zzbtm != null) {
            zzlh2 = this.zzajs.zzapb.zzbtm;
        }
        if (zzlh2 != null && this.zzajs.zzgp()) {
            zzu.zzfs().zzj(this.zzajs.zzapb.zzbtm);
        }
        if (this.zzajs.zzapb != null && this.zzajs.zzapb.zzboo != null) {
            try {
                this.zzajs.zzapb.zzboo.resume();
            }
            catch (RemoteException remoteException) {
                zzkd.zzcx((String)"Could not resume mediation adapter.");
            }
        }
        if (zzlh2 == null || !zzlh2.zzup()) {
            this.zzajr.resume();
        }
        this.zzaju.zzl(this.zzajs.zzapb);
    }

    @Override
    protected boolean zzc(AdRequestParcel adRequestParcel) {
        return super.zzc(adRequestParcel) && !this.zzaka;
    }

    protected boolean zzdw() {
        boolean bl = true;
        if (!zzu.zzfq().zza(this.zzajs.zzagf.getPackageManager(), this.zzajs.zzagf.getPackageName(), "android.permission.INTERNET") || !zzu.zzfq().zzac(this.zzajs.zzagf)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void zzdx() {
        this.zzaju.zzi(this.zzajs.zzapb);
        this.zzaka = false;
        this.zzdr();
        this.zzajs.zzapd.zzsa();
    }

    @Override
    public void zzdy() {
        this.zzaka = true;
        this.zzdt();
    }

    @Override
    public void onPause() {
        this.zzaju.zzk(this.zzajs.zzapb);
    }

    @Override
    public void onResume() {
        this.zzaju.zzl(this.zzajs.zzapb);
    }

    @Override
    public void zzdz() {
        this.onAdClicked();
    }

    @Override
    public void zzea() {
        this.zzdx();
    }

    @Override
    public void zzeb() {
        this.zzdo();
    }

    @Override
    public void zzec() {
        this.zzdy();
    }

    @Override
    public void zzed() {
        if (this.zzajs.zzapb != null) {
            String string = this.zzajs.zzapb.zzbop;
            zzkd.zzcx((String)new StringBuilder(74 + String.valueOf(string).length()).append("Mediation adapter ").append(string).append(" refreshed, but mediation adapters should never refresh.").toString());
        }
        this.zza(this.zzajs.zzapb, true);
        this.zzdu();
    }

    @Override
    public void zzee() {
        this.recordImpression();
    }

    private AdRequestInfoParcel.zza zza(AdRequestParcel adRequestParcel, Bundle bundle, zzjw zzjw2) {
        String string;
        int n;
        Object object;
        PackageInfo packageInfo;
        PackageManager packageManager;
        ApplicationInfo applicationInfo = this.zzajs.zzagf.getApplicationInfo();
        try {
            packageManager = this.zzajs.zzagf.getPackageManager();
            packageInfo = packageManager.getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        packageManager = this.zzajs.zzagf.getResources().getDisplayMetrics();
        Bundle bundle2 = null;
        if (this.zzajs.zzaox != null && this.zzajs.zzaox.getParent() != null) {
            object = new int[2];
            this.zzajs.zzaox.getLocationOnScreen((int[])object);
            Object object2 = object[0];
            Object object3 = object[1];
            int n2 = this.zzajs.zzaox.getWidth();
            int n3 = this.zzajs.zzaox.getHeight();
            int n4 = 0;
            if (this.zzajs.zzaox.isShown() && object2 + n2 > 0 && object3 + n3 > 0 && object2 <= packageManager.widthPixels && object3 <= packageManager.heightPixels) {
                n4 = 1;
            }
            bundle2 = new Bundle(5);
            bundle2.putInt("x", (int)object2);
            bundle2.putInt("y", (int)object3);
            bundle2.putInt("width", n2);
            bundle2.putInt("height", n3);
            bundle2.putInt("visible", n4);
        }
        object = zzu.zzft().zzsj();
        this.zzajs.zzapd = new zzjv((String)object, this.zzajs.zzaou);
        this.zzajs.zzapd.zzq(adRequestParcel);
        String string2 = zzu.zzfq().zza(this.zzajs.zzagf, (View)this.zzajs.zzaox, this.zzajs.zzapa);
        long l = 0L;
        if (this.zzajs.zzaph != null) {
            try {
                l = this.zzajs.zzaph.getValue();
            }
            catch (RemoteException remoteException) {
                zzkd.zzcx((String)"Cannot get correlation id, default to 0.");
            }
        }
        String string3 = UUID.randomUUID().toString();
        Bundle bundle3 = zzu.zzft().zza(this.zzajs.zzagf, this, (String)object);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.zzajs.zzapn.size(); n += 1) {
            arrayList.add((String)this.zzajs.zzapn.keyAt(n));
        }
        n = this.zzajs.zzapi != null ? 1 : 0;
        boolean bl = this.zzajs.zzapj != null && zzu.zzft().zzsv();
        boolean bl2 = this.zzajv.zzakl.zzr(this.zzajs.zzagf);
        String string4 = "";
        if (zzdc.zzbdn.get().booleanValue()) {
            zzkd.zzcv((String)"Getting webview cookie from CookieManager.");
            string = zzu.zzfs().zzao(this.zzajs.zzagf);
            if (string != null) {
                string4 = string.getCookie("googleads.g.doubleclick.net");
            }
        }
        string = null;
        if (zzjw2 != null) {
            string = zzjw2.zzsg();
        }
        return new AdRequestInfoParcel.zza(bundle2, adRequestParcel, this.zzajs.zzapa, this.zzajs.zzaou, applicationInfo, packageInfo, (String)object, zzu.zzft().getSessionId(), this.zzajs.zzaow, bundle3, this.zzajs.zzaps, arrayList, bundle, zzu.zzft().zzsn(), this.mMessenger, packageManager.widthPixels, packageManager.heightPixels, packageManager.density, string2, l, string3, zzdc.zzjx(), this.zzajs.zzaot, this.zzajs.zzapo, new CapabilityParcel(n != 0, bl, bl2), this.zzajs.zzgt(), zzu.zzfq().zzey(), zzu.zzfq().zzfa(), zzu.zzfq().zzam(this.zzajs.zzagf), zzu.zzfq().zzn((View)this.zzajs.zzaox), this.zzajs.zzagf instanceof Activity, zzu.zzft().zzsr(), string4, string, zzu.zzft().zzss(), zzu.zzgj().zzlk(), zzu.zzfq().zzti());
    }

    @Override
    public void zza(zzho zzho2) {
        zzab.zzhi((String)"setInAppPurchaseListener must be called on the main UI thread.");
        this.zzajs.zzapi = zzho2;
    }

    @Override
    public void zza(zzhs zzhs2, @Nullable String string) {
        zzab.zzhi((String)"setPlayStorePurchaseParams must be called on the main UI thread.");
        this.zzajs.zzapt = new zzk(string);
        this.zzajs.zzapj = zzhs2;
        if (!zzu.zzft().zzsm() && zzhs2 != null) {
            Future cfr_ignored_0 = (Future)new zzc(this.zzajs.zzagf, this.zzajs.zzapj, this.zzajs.zzapt).zzpy();
        }
    }

    @Override
    public void zza(String string, ArrayList<String> arrayList) {
        com.google.android.gms.ads.internal.purchase.zzd zzd2 = new com.google.android.gms.ads.internal.purchase.zzd(string, arrayList, this.zzajs.zzagf, this.zzajs.zzaow.zzcs);
        if (this.zzajs.zzapi == null) {
            zzkd.zzcx((String)"InAppPurchaseListener is not set. Try to launch default purchase flow.");
            if (!zzm.zziw().zzar(this.zzajs.zzagf)) {
                zzkd.zzcx((String)"Google Play Service unavailable, cannot launch default purchase flow.");
                return;
            }
            if (this.zzajs.zzapj == null) {
                zzkd.zzcx((String)"PlayStorePurchaseListener is not set.");
                return;
            }
            if (this.zzajs.zzapt == null) {
                zzkd.zzcx((String)"PlayStorePurchaseVerifier is not initialized.");
                return;
            }
            if (this.zzajs.zzapx) {
                zzkd.zzcx((String)"An in-app purchase request is already in progress, abort");
                return;
            }
            this.zzajs.zzapx = true;
            try {
                if (!this.zzajs.zzapj.isValidPurchase(string)) {
                    this.zzajs.zzapx = false;
                    return;
                }
            }
            catch (RemoteException remoteException) {
                zzkd.zzcx((String)"Could not start In-App purchase.");
                this.zzajs.zzapx = false;
                return;
            }
            zzu.zzga().zza(this.zzajs.zzagf, this.zzajs.zzaow.zzcnm, new GInAppPurchaseManagerInfoParcel(this.zzajs.zzagf, this.zzajs.zzapt, (zzhn)zzd2, this));
        } else {
            try {
                this.zzajs.zzapi.zza((zzhn)zzd2);
            }
            catch (RemoteException remoteException) {
                zzkd.zzcx((String)"Could not start In-App purchase.");
            }
        }
    }

    @Override
    public void zza(String string, boolean bl, int n, final Intent intent, zzf zzf2) {
        try {
            if (this.zzajs.zzapj != null) {
                this.zzajs.zzapj.zza((zzhr)new com.google.android.gms.ads.internal.purchase.zzg(this.zzajs.zzagf, string, bl, n, intent, zzf2));
            }
        }
        catch (RemoteException remoteException) {
            zzkd.zzcx((String)"Fail to invoke PlayStorePurchaseListener.");
        }
        zzkh.zzclc.postDelayed(new Runnable(){

            @Override
            public void run() {
                int n = zzu.zzga().zzd(intent);
                zzu.zzga();
                if (n == 0 && zzb.this.zzajs.zzapb != null && zzb.this.zzajs.zzapb.zzbtm != null && zzb.this.zzajs.zzapb.zzbtm.zzuh() != null) {
                    zzb.this.zzajs.zzapb.zzbtm.zzuh().close();
                }
                zzb.this.zzajs.zzapx = false;
            }
        }, 500L);
    }

    public void recordImpression() {
        this.zza(this.zzajs.zzapb, false);
    }

    protected void zza(@Nullable zzju zzju2, boolean bl) {
        if (zzju2 == null) {
            zzkd.zzcx((String)"Ad state was null when trying to ping impression URLs.");
            return;
        }
        super.zzc(zzju2);
        if (zzju2.zzcig != null && zzju2.zzcig.zzbnn != null) {
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaow.zzcs, zzju2, this.zzajs.zzaou, bl, zzju2.zzcig.zzbnn);
        }
        if (zzju2.zzbon != null && zzju2.zzbon.zzbna != null) {
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaow.zzcs, zzju2, this.zzajs.zzaou, bl, zzju2.zzbon.zzbna);
        }
    }

    public String getMediationAdapterClassName() {
        if (this.zzajs.zzapb == null) {
            return null;
        }
        return this.zzajs.zzapb.zzbop;
    }

    public void showInterstitial() {
        throw new IllegalStateException("showInterstitial is not supported for current ad type");
    }

    @Override
    public void zzef() {
        zzu.zzfq().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                zzb.this.zzajr.pause();
            }
        });
    }

    @Override
    public void zzeg() {
        zzu.zzfq().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                zzb.this.zzajr.resume();
            }
        });
    }
}

