/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzfl;
import com.google.android.gms.internal.zzfm;
import com.google.android.gms.internal.zzfo;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzkd;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;

@zzin
public class zzfk {
    private final Map<zzfl, zzfm> zzbko = new HashMap<zzfl, zzfm>();
    private final LinkedList<zzfl> zzbkp = new LinkedList();
    @Nullable
    private zzfh zzbkq;

    void zza(zzfh zzfh2) {
        if (this.zzbkq == null) {
            this.zzbkq = zzfh2.zzln();
            this.restore();
        }
    }

    @Nullable
    zzfm.zza zza(AdRequestParcel adRequestParcel, String string2) {
        Object object;
        if (this.zzbf(string2)) {
            return null;
        }
        Context context = this.zzbkq.getApplicationContext();
        zziv zziv2 = new zziv.zza(context).zzrn();
        int n = zziv2.zzcgp;
        AdRequestParcel adRequestParcel2 = zzfk.zzl(adRequestParcel);
        zzfl zzfl2 = new zzfl(adRequestParcel2, string2, n);
        zzfm zzfm2 = this.zzbko.get(zzfl2);
        if (zzfm2 == null) {
            zzfk.zza("Interstitial pool created at %s.", zzfl2);
            zzfm2 = new zzfm(adRequestParcel2, string2, n);
            this.zzbko.put(zzfl2, zzfm2);
        }
        this.zzbkp.remove(zzfl2);
        this.zzbkp.add(zzfl2);
        zzfm2.zzlt();
        while (this.zzbkp.size() > zzdc.zzbai.get()) {
            object = this.zzbkp.remove();
            zzfm zzfm3 = this.zzbko.get(object);
            zzfk.zza("Evicting interstitial queue for %s.", (zzfl)object);
            while (zzfm3.size() > 0) {
                zzfm.zza zza2 = zzfm3.zzm(null);
                zza2.zzbkv.zzeu();
            }
            this.zzbko.remove(object);
        }
        while (zzfm2.size() > 0) {
            long l;
            object = zzfm2.zzm(adRequestParcel2);
            if (((zzfm.zza)object).zzbkz && (l = zzu.zzfu().currentTimeMillis() - ((zzfm.zza)object).zzbky) > 1000L * (long)zzdc.zzbak.get().intValue()) {
                zzfk.zza("Expired interstitial at %s.", zzfl2);
                continue;
            }
            String string3 = ((zzfm.zza)object).zzbkw != null ? " (inline) " : " ";
            zzfk.zza(new StringBuilder(34 + String.valueOf(string3).length()).append("Pooled interstitial").append(string3).append("returned at %s.").toString(), zzfl2);
            return object;
        }
        return null;
    }

    void zzb(AdRequestParcel adRequestParcel, String string2) {
        if (this.zzbkq == null) {
            return;
        }
        Context context = this.zzbkq.getApplicationContext();
        zziv zziv2 = new zziv.zza(context).zzrn();
        int n = zziv2.zzcgp;
        AdRequestParcel adRequestParcel2 = zzfk.zzl(adRequestParcel);
        zzfl zzfl2 = new zzfl(adRequestParcel2, string2, n);
        zzfm zzfm2 = this.zzbko.get(zzfl2);
        if (zzfm2 == null) {
            zzfk.zza("Interstitial pool created at %s.", zzfl2);
            zzfm2 = new zzfm(adRequestParcel2, string2, n);
            this.zzbko.put(zzfl2, zzfm2);
        }
        zzfm2.zza(this.zzbkq, adRequestParcel);
        zzfm2.zzlt();
        zzfk.zza("Inline entry added to the queue at %s.", zzfl2);
    }

    void zzlo() {
        if (this.zzbkq == null) {
            return;
        }
        for (Map.Entry<zzfl, zzfm> entry : this.zzbko.entrySet()) {
            zzfl zzfl2 = entry.getKey();
            zzfm zzfm2 = entry.getValue();
            if (zzkd.zzaz((int)2)) {
                int n = zzfm2.size();
                int n2 = zzfm2.zzlr();
                if (n2 < n) {
                    zzkd.v(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zzfl2));
                }
            }
            zzfm2.zzls();
            while (zzfm2.size() < zzdc.zzbaj.get()) {
                zzfk.zza("Pooling and loading one new interstitial for %s.", zzfl2);
                zzfm2.zzb(this.zzbkq);
            }
        }
        this.save();
    }

    void save() {
        if (this.zzbkq == null) {
            return;
        }
        Context context = this.zzbkq.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        for (Map.Entry<zzfl, zzfm> entry : this.zzbko.entrySet()) {
            zzfl zzfl2 = entry.getKey();
            zzfm zzfm2 = entry.getValue();
            if (!zzfm2.zzlu()) continue;
            zzfo zzfo2 = new zzfo(zzfm2);
            String string2 = zzfo2.zzlx();
            String string3 = zzfl2.toString();
            editor.putString(string3, string2);
            zzfk.zza("Saved interstitial queue for %s.", zzfl2);
        }
        editor.putString("PoolKeys", this.zzlp());
        editor.apply();
    }

    void restore() {
        zzfl zzfl2;
        if (this.zzbkq == null) {
            return;
        }
        Context context = this.zzbkq.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        this.flush();
        HashMap<String, zzfl> hashMap = new HashMap<String, zzfl>();
        String[] stringArray = sharedPreferences.getAll().entrySet().iterator();
        while (stringArray.hasNext()) {
            String[] stringArray2 = stringArray.next();
            try {
                String string2 = (String)stringArray2.getKey();
                if (string2.equals("PoolKeys")) continue;
                String string3 = (String)stringArray2.getValue();
                zzfo object = new zzfo(string3);
                zzfl2 = new zzfl(object.zzanc, object.zzaln, object.zzbkt);
                if (this.zzbko.containsKey(zzfl2)) continue;
                zzfm zzfm2 = new zzfm(object.zzanc, object.zzaln, object.zzbkt);
                this.zzbko.put(zzfl2, zzfm2);
                hashMap.put(zzfl2.toString(), zzfl2);
                zzfk.zza("Restored interstitial queue for %s.", zzfl2);
            }
            catch (IOException | ClassCastException exception) {
                zzkd.zzd((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)exception);
            }
        }
        for (String string2 : stringArray = this.zzbe(sharedPreferences.getString("PoolKeys", ""))) {
            zzfl2 = (zzfl)hashMap.get(string2);
            if (!this.zzbko.containsKey(zzfl2)) continue;
            this.zzbkp.add(zzfl2);
        }
    }

    void flush() {
        while (this.zzbkp.size() > 0) {
            zzfl zzfl2 = this.zzbkp.remove();
            zzfm zzfm2 = this.zzbko.get(zzfl2);
            zzfk.zza("Flushing interstitial queue for %s.", zzfl2);
            while (zzfm2.size() > 0) {
                zzfm.zza zza2 = zzfm2.zzm(null);
                zza2.zzbkv.zzeu();
            }
            this.zzbko.remove(zzfl2);
        }
    }

    private String zzlp() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzbkp.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zzfl)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private String[] zzbe(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private boolean zzbf(String string2) {
        try {
            return Pattern.matches(zzdc.zzbal.get(), string2);
        }
        catch (RuntimeException runtimeException) {
            zzu.zzft().zzb(runtimeException, true);
            return false;
        }
    }

    @Nullable
    static Bundle zzi(AdRequestParcel adRequestParcel) {
        Bundle bundle = adRequestParcel.zzatw;
        if (bundle == null) {
            return null;
        }
        return bundle.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
    }

    static AdRequestParcel zzj(AdRequestParcel adRequestParcel) {
        Parcel parcel = Parcel.obtain();
        adRequestParcel.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        AdRequestParcel adRequestParcel2 = (AdRequestParcel)AdRequestParcel.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        Bundle bundle = zzfk.zzi(adRequestParcel2);
        if (bundle == null) {
            bundle = new Bundle();
            adRequestParcel2.zzatw.putBundle("com.google.ads.mediation.admob.AdMobAdapter", bundle);
        }
        bundle.putBoolean("_skipMediation", true);
        return adRequestParcel2;
    }

    static boolean zzk(AdRequestParcel adRequestParcel) {
        Bundle bundle = adRequestParcel.zzatw;
        if (bundle == null) {
            return false;
        }
        Bundle bundle2 = bundle.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        return bundle2 != null && bundle2.containsKey("_skipMediation");
    }

    private static AdRequestParcel zzl(AdRequestParcel adRequestParcel) {
        String[] stringArray;
        Parcel parcel = Parcel.obtain();
        adRequestParcel.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        AdRequestParcel adRequestParcel2 = (AdRequestParcel)AdRequestParcel.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        String string2 = zzdc.zzbah.get();
        for (String string3 : stringArray = string2.split(",")) {
            zzfk.zzc(adRequestParcel2.zzatw, string3);
        }
        return adRequestParcel2;
    }

    private static void zzc(Bundle bundle, String string2) {
        String[] stringArray = string2.split("/", 2);
        if (stringArray.length == 0) {
            return;
        }
        String string3 = stringArray[0];
        if (stringArray.length == 1) {
            bundle.remove(string3);
            return;
        }
        Bundle bundle2 = bundle.getBundle(string3);
        if (bundle2 == null) {
            return;
        }
        zzfk.zzc(bundle2, stringArray[1]);
    }

    private static void zza(String string2, zzfl zzfl2) {
        if (zzkd.zzaz((int)2)) {
            zzkd.v(String.format(string2, zzfl2));
        }
    }
}

