/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzhf;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzlh;
import java.util.Map;

@zzin
public class zzgz
extends zzhf {
    private final Map<String, String> zzbeg;
    private final Context mContext;
    private String zzbpy;
    private long zzbpz;
    private long zzbqa;
    private String zzbqb;
    private String zzbqc;

    public zzgz(zzlh zzlh2, Map<String, String> map) {
        super(zzlh2, "createCalendarEvent");
        this.zzbeg = map;
        this.mContext = zzlh2.zzue();
        this.zzmt();
    }

    private void zzmt() {
        this.zzbpy = this.zzbq("description");
        this.zzbqb = this.zzbq("summary");
        this.zzbpz = this.zzbr("start_ticks");
        this.zzbqa = this.zzbr("end_ticks");
        this.zzbqc = this.zzbq("location");
    }

    private String zzbq(String string2) {
        return TextUtils.isEmpty((CharSequence)this.zzbeg.get(string2)) ? "" : this.zzbeg.get(string2);
    }

    private long zzbr(String string2) {
        String string3 = this.zzbeg.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzbt("Activity context is not available.");
            return;
        }
        zzcu zzcu2 = zzu.zzfq().zzag(this.mContext);
        if (!zzcu2.zzju()) {
            this.zzbt("This feature is not available on the device.");
            return;
        }
        AlertDialog.Builder builder = zzu.zzfq().zzaf(this.mContext);
        Resources resources = zzu.zzft().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.create_calendar_title) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.create_calendar_message) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.accept) : "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                Intent intent = zzgz.this.createIntent();
                zzu.zzfq().zzb(zzgz.this.mContext, intent);
            }
        });
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.decline) : "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzgz.this.zzbt("Operation denied by user.");
            }
        });
        builder.create().show();
    }

    @TargetApi(value=14)
    Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzbpy);
        intent.putExtra("eventLocation", this.zzbqc);
        intent.putExtra("description", this.zzbqb);
        if (this.zzbpz > -1L) {
            intent.putExtra("beginTime", this.zzbpz);
        }
        if (this.zzbqa > -1L) {
            intent.putExtra("endTime", this.zzbqa);
        }
        intent.setFlags(0x10000000);
        return intent;
    }
}

