/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.internal.zzhf;
import com.google.android.gms.internal.zzhg;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzlh;
import java.util.Map;
import java.util.Set;

@zzin
public class zzha
extends zzhf {
    static final Set<String> zzbqe = zzf.zzc((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzbqf = "top-right";
    private boolean zzbqg = true;
    private int zzbqh = 0;
    private int zzbqi = 0;
    private int zzaif = -1;
    private int zzbqj = 0;
    private int zzbqk = 0;
    private int zzaie = -1;
    private final Object zzail = new Object();
    private final zzlh zzbgf;
    private final Activity zzbpu;
    private AdSizeParcel zzani;
    private ImageView zzbql;
    private LinearLayout zzbqm;
    private zzhg zzbqn;
    private PopupWindow zzbqo;
    private RelativeLayout zzbqp;
    private ViewGroup zzbqq;

    public zzha(zzlh zzlh2, zzhg zzhg2) {
        super(zzlh2, "resize");
        this.zzbgf = zzlh2;
        this.zzbpu = zzlh2.zzue();
        this.zzbqn = zzhg2;
    }

    private void zzi(Map<String, String> map) {
        String string2;
        if (!TextUtils.isEmpty((CharSequence)map.get("width"))) {
            this.zzaie = zzu.zzfq().zzcp(map.get("width"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("height"))) {
            this.zzaif = zzu.zzfq().zzcp(map.get("height"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetX"))) {
            this.zzbqj = zzu.zzfq().zzcp(map.get("offsetX"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetY"))) {
            this.zzbqk = zzu.zzfq().zzcp(map.get("offsetY"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("allowOffscreen"))) {
            this.zzbqg = Boolean.parseBoolean(map.get("allowOffscreen"));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = map.get("customClosePosition")))) {
            this.zzbqf = string2;
        }
    }

    boolean zzmu() {
        return this.zzaie > -1 && this.zzaif > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<String, String> map) {
        Object object = this.zzail;
        synchronized (object) {
            Bitmap bitmap;
            if (this.zzbpu == null) {
                this.zzbt("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzbgf.zzdn() == null) {
                this.zzbt("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzbgf.zzdn().zzaus) {
                this.zzbt("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzbgf.zzun()) {
                this.zzbt("Cannot resize an expanded banner.");
                return;
            }
            this.zzi(map);
            if (!this.zzmu()) {
                this.zzbt("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzbpu.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzbt("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzmv();
            if (nArray == null) {
                this.zzbt("Resize location out of screen or close button is not visible.");
                return;
            }
            int n = zzm.zziw().zza((Context)this.zzbpu, this.zzaie);
            int n2 = zzm.zziw().zza((Context)this.zzbpu, this.zzaif);
            ViewParent viewParent = this.zzbgf.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzbgf.getView());
                if (this.zzbqo == null) {
                    this.zzbqq = (ViewGroup)viewParent;
                    bitmap = zzu.zzfq().zzk(this.zzbgf.getView());
                    this.zzbql = new ImageView((Context)this.zzbpu);
                    this.zzbql.setImageBitmap(bitmap);
                    this.zzani = this.zzbgf.zzdn();
                    this.zzbqq.addView((View)this.zzbql);
                } else {
                    this.zzbqo.dismiss();
                }
            } else {
                this.zzbt("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzbqp = new RelativeLayout((Context)this.zzbpu);
            this.zzbqp.setBackgroundColor(0);
            this.zzbqp.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            this.zzbqo = zzu.zzfq().zza((View)this.zzbqp, n, n2, false);
            this.zzbqo.setOutsideTouchable(true);
            this.zzbqo.setTouchable(true);
            this.zzbqo.setClippingEnabled(!this.zzbqg);
            this.zzbqp.addView(this.zzbgf.getView(), -1, -1);
            this.zzbqm = new LinearLayout((Context)this.zzbpu);
            bitmap = new RelativeLayout.LayoutParams(zzm.zziw().zza((Context)this.zzbpu, 50), zzm.zziw().zza((Context)this.zzbpu, 50));
            switch (this.zzbqf) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzbqm.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    zzha.this.zzs(true);
                }
            });
            this.zzbqm.setContentDescription((CharSequence)"Close button");
            this.zzbqp.addView((View)this.zzbqm, (ViewGroup.LayoutParams)bitmap);
            try {
                this.zzbqo.showAtLocation(window.getDecorView(), 0, zzm.zziw().zza((Context)this.zzbpu, nArray[0]), zzm.zziw().zza((Context)this.zzbpu, nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(runtimeException.getMessage());
                this.zzbt(string2.length() != 0 ? "Cannot show popup window: ".concat(string2) : new String("Cannot show popup window: "));
                this.zzbqp.removeView(this.zzbgf.getView());
                if (this.zzbqq != null) {
                    this.zzbqq.removeView((View)this.zzbql);
                    this.zzbqq.addView(this.zzbgf.getView());
                    this.zzbgf.zza(this.zzani);
                }
                return;
            }
            this.zzb(nArray[0], nArray[1]);
            this.zzbgf.zza(new AdSizeParcel((Context)this.zzbpu, new AdSize(this.zzaie, this.zzaif)));
            this.zzc(nArray[0], nArray[1]);
            this.zzbv("resized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzs(boolean bl) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzbqo != null) {
                this.zzbqo.dismiss();
                this.zzbqp.removeView(this.zzbgf.getView());
                if (this.zzbqq != null) {
                    this.zzbqq.removeView((View)this.zzbql);
                    this.zzbqq.addView(this.zzbgf.getView());
                    this.zzbgf.zza(this.zzani);
                }
                if (bl) {
                    this.zzbv("default");
                    if (this.zzbqn != null) {
                        this.zzbqn.zzej();
                    }
                }
                this.zzbqo = null;
                this.zzbqp = null;
                this.zzbqq = null;
                this.zzbqm = null;
            }
        }
    }

    private int[] zzmv() {
        if (!this.zzmx()) {
            return null;
        }
        if (this.zzbqg) {
            return new int[]{this.zzbqh + this.zzbqj, this.zzbqi + this.zzbqk};
        }
        int[] nArray = zzu.zzfq().zzi(this.zzbpu);
        int[] nArray2 = zzu.zzfq().zzk(this.zzbpu);
        int n = nArray[0];
        int n2 = this.zzbqh + this.zzbqj;
        int n3 = this.zzbqi + this.zzbqk;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 + this.zzaie > n) {
            n2 = n - this.zzaie;
        }
        if (n3 < nArray2[0]) {
            n3 = nArray2[0];
        } else if (n3 + this.zzaif > nArray2[1]) {
            n3 = nArray2[1] - this.zzaif;
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(int n, int n2, boolean bl) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzbqh = n;
            this.zzbqi = n2;
            if (this.zzbqo != null && bl) {
                int[] nArray = this.zzmv();
                if (nArray != null) {
                    this.zzbqo.update(zzm.zziw().zza((Context)this.zzbpu, nArray[0]), zzm.zziw().zza((Context)this.zzbpu, nArray[1]), this.zzbqo.getWidth(), this.zzbqo.getHeight());
                    this.zzc(nArray[0], nArray[1]);
                } else {
                    this.zzs(true);
                }
            }
        }
    }

    void zzb(int n, int n2) {
        if (this.zzbqn != null) {
            this.zzbqn.zza(n, n2, this.zzaie, this.zzaif);
        }
    }

    void zzc(int n, int n2) {
        int n3 = zzu.zzfq().zzk(this.zzbpu)[0];
        this.zzb(n, n2 - n3, this.zzaie, this.zzaif);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzmw() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzbqo != null;
        }
    }

    public void zzd(int n, int n2) {
        this.zzbqh = n;
        this.zzbqi = n2;
    }

    boolean zzmx() {
        int[] nArray = zzu.zzfq().zzi(this.zzbpu);
        int[] nArray2 = zzu.zzfq().zzk(this.zzbpu);
        int n = nArray[0];
        int n2 = nArray[1];
        if (this.zzaie < 50 || this.zzaie > n) {
            zzkd.zzcx((String)"Width is too small or too large.");
            return false;
        }
        if (this.zzaif < 50 || this.zzaif > n2) {
            zzkd.zzcx((String)"Height is too small or too large.");
            return false;
        }
        if (this.zzaif == n2 && this.zzaie == n) {
            zzkd.zzcx((String)"Cannot resize to a full-screen ad.");
            return false;
        }
        if (this.zzbqg) {
            int n3 = -1;
            int n4 = -2;
            switch (this.zzbqf) {
                case "top-left": {
                    n3 = this.zzbqh + this.zzbqj;
                    n4 = this.zzbqi + this.zzbqk;
                    break;
                }
                case "top-center": {
                    n3 = this.zzbqh + this.zzbqj + this.zzaie / 2 - 25;
                    n4 = this.zzbqi + this.zzbqk;
                    break;
                }
                case "center": {
                    n3 = this.zzbqh + this.zzbqj + this.zzaie / 2 - 25;
                    n4 = this.zzbqi + this.zzbqk + this.zzaif / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n3 = this.zzbqh + this.zzbqj;
                    n4 = this.zzbqi + this.zzbqk + this.zzaif - 50;
                    break;
                }
                case "bottom-center": {
                    n3 = this.zzbqh + this.zzbqj + this.zzaie / 2 - 25;
                    n4 = this.zzbqi + this.zzbqk + this.zzaif - 50;
                    break;
                }
                case "bottom-right": {
                    n3 = this.zzbqh + this.zzbqj + this.zzaie - 50;
                    n4 = this.zzbqi + this.zzbqk + this.zzaif - 50;
                    break;
                }
                default: {
                    n3 = this.zzbqh + this.zzbqj + this.zzaie - 50;
                    n4 = this.zzbqi + this.zzbqk;
                }
            }
            if (n3 < 0 || n3 + 50 > n || n4 < nArray2[0] || n4 + 50 > nArray2[1]) {
                return false;
            }
        }
        return true;
    }
}

