/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzhf;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzlh;
import java.util.Map;

@zzin
public class zzhc
extends zzhf {
    private final Map<String, String> zzbeg;
    private final Context mContext;

    public zzhc(zzlh zzlh2, Map<String, String> map) {
        super(zzlh2, "storePicture");
        this.zzbeg = map;
        this.mContext = zzlh2.zzue();
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzbt("Activity context is not available");
            return;
        }
        zzcu zzcu2 = zzu.zzfq().zzag(this.mContext);
        if (!zzcu2.zzjr()) {
            this.zzbt("Feature is not supported by the device.");
            return;
        }
        final String string2 = this.zzbeg.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzbt("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzbt(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        final String string4 = this.zzbs(string2);
        if (!zzu.zzfq().zzcq(string4)) {
            String string5 = String.valueOf(string4);
            this.zzbt(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzu.zzft().getResources();
        AlertDialog.Builder builder = zzu.zzfq().zzaf(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.store_picture_title) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.store_picture_message) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.accept) : "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                DownloadManager downloadManager = (DownloadManager)zzhc.this.mContext.getSystemService("download");
                try {
                    DownloadManager.Request request = zzhc.this.zzk(string2, string4);
                    downloadManager.enqueue(request);
                }
                catch (IllegalStateException illegalStateException) {
                    zzhc.this.zzbt("Could not store picture.");
                }
            }
        });
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.decline) : "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzhc.this.zzbt("User canceled the download.");
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    DownloadManager.Request zzk(String string2, String string3) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_PICTURES, string3);
        zzu.zzfs().zza(request);
        return request;
    }

    String zzbs(String string2) {
        Uri uri = Uri.parse((String)string2);
        return uri.getLastPathSegment();
    }
}

