/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.formats.zzc;
import com.google.android.gms.ads.internal.formats.zzf;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.formats.zzi;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzas;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzed;
import com.google.android.gms.internal.zzee;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzih;
import com.google.android.gms.internal.zzij;
import com.google.android.gms.internal.zzik;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkv;
import com.google.android.gms.internal.zzkw;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzky;
import com.google.android.gms.internal.zzlh;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzin
public class zzii
implements Callable<zzju> {
    private static final long zzbyt = TimeUnit.SECONDS.toMillis(60L);
    private final Context mContext;
    private final zzkn zzbzc;
    private final zzq zzbzd;
    private final zzas zzbgd;
    private final zzih zzbgb;
    private final Object zzail = new Object();
    private final zzju.zza zzbxr;
    private boolean zzbze;
    private int zzbyi;
    private List<String> zzbzf;
    private JSONObject zzbzg;

    public zzii(Context context, zzq zzq2, zzkn zzkn2, zzas zzas2, zzju.zza zza2) {
        this.mContext = context;
        this.zzbzd = zzq2;
        this.zzbzc = zzkn2;
        this.zzbxr = zza2;
        this.zzbgd = zzas2;
        this.zzbgb = this.zza(context, zza2, zzq2, zzas2);
        this.zzbgb.zzqg();
        this.zzbze = false;
        this.zzbyi = -2;
        this.zzbzf = null;
    }

    public zzju zzqr() {
        try {
            this.zzbgb.zzqh();
            String string2 = UUID.randomUUID().toString();
            JSONObject jSONObject = this.zzcb(string2);
            zza zza2 = this.zzf(jSONObject);
            zzh.zza zza3 = this.zza(zza2, jSONObject, string2);
            this.zza(zza3);
            zzju zzju2 = this.zzb(zza3);
            return zzju2;
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (JSONException jSONException) {
            zzkd.zzd((String)"Malformed native JSON response.", (Throwable)jSONException);
        }
        catch (TimeoutException timeoutException) {
            zzkd.zzd((String)"Timeout when loading native ad.", (Throwable)timeoutException);
        }
        if (!this.zzbze) {
            this.zzan(0);
        }
        return this.zzb(null);
    }

    private JSONObject zzcb(final String string2) throws ExecutionException, InterruptedException, TimeoutException, JSONException {
        if (this.zzqs()) {
            return null;
        }
        final zzkv zzkv2 = new zzkv();
        final zzb zzb2 = new zzb();
        zzih.zza zza2 = new zzih.zza(){

            @Override
            public void zze(final zzft zzft2) {
                zzep zzep2;
                zzb2.zzbzz = zzep2 = new zzep(){

                    @Override
                    public void zza(zzlh zzlh2, Map<String, String> map) {
                        zzft2.zzb("/nativeAdPreProcess", zzb2.zzbzz);
                        try {
                            String string2 = map.get("success");
                            if (!TextUtils.isEmpty((CharSequence)string2)) {
                                zzkv2.zzh(new JSONObject(string2).getJSONArray("ads").getJSONObject(0));
                                return;
                            }
                        }
                        catch (JSONException jSONException) {
                            zzkd.zzb((String)"Malformed native JSON response.", (Throwable)jSONException);
                        }
                        zzii.this.zzan(0);
                        zzab.zza((boolean)zzii.this.zzqs(), (Object)"Unable to set the ad state error!");
                        zzkv2.zzh(null);
                    }
                };
                zzft2.zza("/nativeAdPreProcess", zzep2);
                try {
                    JSONObject jSONObject = new JSONObject(((zzii)zzii.this).zzbxr.zzciq.body);
                    jSONObject.put("ads_id", (Object)string2);
                    zzft2.zza("google.afma.nativeAds.preProcessJsonGmsg", jSONObject);
                }
                catch (JSONException jSONException) {
                    zzkd.zzd((String)"Exception occurred while invoking javascript", (Throwable)jSONException);
                    zzkv2.zzh(null);
                }
            }

            @Override
            public void zzqq() {
                zzkv2.zzh(null);
            }
        };
        this.zzbgb.zza(zza2);
        return (JSONObject)zzkv2.get(zzbyt, TimeUnit.MILLISECONDS);
    }

    protected zza zzf(JSONObject jSONObject) throws ExecutionException, InterruptedException, JSONException, TimeoutException {
        boolean bl;
        if (this.zzqs()) {
            return null;
        }
        String string2 = jSONObject.getString("template_id");
        boolean bl2 = this.zzbxr.zzcip.zzapo != null ? this.zzbxr.zzcip.zzapo.zzbgp : false;
        boolean bl3 = bl = this.zzbxr.zzcip.zzapo != null ? this.zzbxr.zzcip.zzapo.zzbgr : false;
        if ("2".equals(string2)) {
            return new zzij(bl2, bl);
        }
        if ("1".equals(string2)) {
            return new zzik(bl2, bl);
        }
        if ("3".equals(string2)) {
            final String string3 = jSONObject.getString("custom_template_id");
            final zzkv zzkv2 = new zzkv();
            zzkh.zzclc.post(new Runnable(){

                @Override
                public void run() {
                    zzkv2.zzh((zzee)zzii.this.zzbzd.zzfb().get((Object)string3));
                }
            });
            if (zzkv2.get(zzbyt, TimeUnit.MILLISECONDS) != null) {
                return new zzil(bl2);
            }
            String string4 = String.valueOf(jSONObject.getString("custom_template_id"));
            zzkd.e((String)(string4.length() != 0 ? "No handler for custom template: ".concat(string4) : new String("No handler for custom template: ")));
        } else {
            this.zzan(0);
        }
        return null;
    }

    private void zza(zzh.zza zza2) {
        zzep zzep2;
        if (!(zza2 instanceof zzf)) {
            return;
        }
        final zzf zzf2 = (zzf)zza2;
        zzb zzb2 = new zzb();
        zzb2.zzbzz = zzep2 = new zzep(){

            @Override
            public void zza(zzlh zzlh2, Map<String, String> map) {
                String string2 = map.get("asset");
                zzii.this.zzb((zzdz)zzf2, string2);
            }
        };
        this.zzbgb.zza(new zzih.zza(){

            @Override
            public void zze(zzft zzft2) {
                zzft2.zza("/nativeAdCustomClick", zzep2);
            }
        });
    }

    private void zzb(zzdz zzdz2, String string2) {
        try {
            zzed zzed2 = this.zzbzd.zzv(zzdz2.getCustomTemplateId());
            if (zzed2 != null) {
                zzed2.zza(zzdz2, string2);
            }
        }
        catch (RemoteException remoteException) {
            zzkd.zzd((String)new StringBuilder(40 + String.valueOf(string2).length()).append("Failed to call onCustomClick for asset ").append(string2).append(".").toString(), (Throwable)remoteException);
        }
    }

    private zzh.zza zza(zza zza2, JSONObject jSONObject, String string2) throws ExecutionException, InterruptedException, JSONException {
        if (this.zzqs()) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("tracking_urls_and_actions");
        String[] stringArray = this.zzc(jSONObject2, "impression_tracking_urls");
        this.zzbzf = stringArray == null ? null : Arrays.asList(stringArray);
        this.zzbzg = jSONObject2.optJSONObject("active_view");
        Object t = zza2.zza(this, jSONObject);
        if (t == null) {
            zzkd.e((String)"Failed to retrieve ad assets.");
            return null;
        }
        t.zzb((zzh)new zzi(this.mContext, this.zzbzd, this.zzbgb, this.zzbgd, jSONObject, (zzh.zza)t, this.zzbxr.zzcip.zzaow, string2));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzju zzb(zzh.zza zza2) {
        int n;
        Object object = this.zzail;
        synchronized (object) {
            n = this.zzbyi;
            if (zza2 == null && this.zzbyi == -2) {
                n = 0;
            }
        }
        if (n != -2) {
            zza2 = null;
        }
        return new zzju(this.zzbxr.zzcip.zzcar, null, this.zzbxr.zzciq.zzbnm, n, this.zzbxr.zzciq.zzbnn, this.zzbzf, this.zzbxr.zzciq.orientation, this.zzbxr.zzciq.zzbns, this.zzbxr.zzcip.zzcau, false, null, null, null, null, null, 0L, this.zzbxr.zzapa, this.zzbxr.zzciq.zzcbx, this.zzbxr.zzcik, this.zzbxr.zzcil, this.zzbxr.zzciq.zzccd, this.zzbzg, zza2, null, null, null, this.zzbxr.zzciq.zzccq, this.zzbxr.zzciq.zzccr, null, this.zzbxr.zzciq.zzbnp);
    }

    public zzky<com.google.android.gms.ads.internal.formats.zza> zzg(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject("attribution");
        if (jSONObject2 == null) {
            return new zzkw<Object>(null);
        }
        final String string2 = jSONObject2.optString("text");
        final int n = jSONObject2.optInt("text_size", -1);
        final Integer n2 = this.zzb(jSONObject2, "text_color");
        final Integer n3 = this.zzb(jSONObject2, "bg_color");
        final int n4 = jSONObject2.optInt("animation_ms", 1000);
        final int n5 = jSONObject2.optInt("presentation_ms", 4000);
        final int n6 = this.zzbxr.zzcip.zzapo != null && this.zzbxr.zzcip.zzapo.versionCode >= 2 ? this.zzbxr.zzcip.zzapo.zzbgs : 1;
        ArrayList arrayList = new ArrayList<zzky<zzc>>();
        if (jSONObject2.optJSONArray("images") != null) {
            arrayList = this.zza(jSONObject2, "images", false, false, true);
        } else {
            arrayList.add(this.zza(jSONObject2, "image", false, false));
        }
        zzky zzky2 = zzkx.zzn(arrayList);
        return zzkx.zza(zzky2, new zzkx.zza<List<zzc>, com.google.android.gms.ads.internal.formats.zza>(){

            public com.google.android.gms.ads.internal.formats.zza zzj(List<zzc> list) {
                try {
                    return list == null || list.isEmpty() ? null : new com.google.android.gms.ads.internal.formats.zza(string2, zzii.zzh(list), n3, n2, n > 0 ? Integer.valueOf(n) : null, n5 + n4, n6);
                }
                catch (RemoteException remoteException) {
                    zzkd.zzb((String)"Could not get attribution icon", (Throwable)remoteException);
                    return null;
                }
            }

            @Override
            public /* synthetic */ Object apply(Object object) {
                return this.zzj((List)object);
            }
        });
    }

    private Integer zzb(JSONObject jSONObject, String string2) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            int n = jSONObject2.getInt("r");
            int n2 = jSONObject2.getInt("g");
            int n3 = jSONObject2.getInt("b");
            return Color.rgb((int)n, (int)n2, (int)n3);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Future<zzc> zza(JSONObject jSONObject, String string2, boolean bl) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
        boolean bl2 = jSONObject2.optBoolean("require", true);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl2, bl);
    }

    public zzky<zzc> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2) throws JSONException {
        JSONObject jSONObject2 = bl ? jSONObject.getJSONObject(string2) : jSONObject.optJSONObject(string2);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl, bl2);
    }

    public List<zzky<zzc>> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2, boolean bl3) throws JSONException {
        JSONArray jSONArray = bl ? jSONObject.getJSONArray(string2) : jSONObject.optJSONArray(string2);
        ArrayList<zzky<zzc>> arrayList = new ArrayList<zzky<zzc>>();
        if (jSONArray == null || jSONArray.length() == 0) {
            this.zza(0, bl);
            return arrayList;
        }
        int n = bl3 ? jSONArray.length() : 1;
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
            arrayList.add(this.zza(jSONObject2, bl, bl2));
        }
        return arrayList;
    }

    private zzky<zzc> zza(JSONObject jSONObject, final boolean bl, boolean bl2) throws JSONException {
        final String string2 = bl ? jSONObject.getString("url") : jSONObject.optString("url");
        final double d = jSONObject.optDouble("scale", 1.0);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zza(0, bl);
            return new zzkw<Object>(null);
        }
        if (bl2) {
            return new zzkw<zzc>(new zzc(null, Uri.parse((String)string2), d));
        }
        return this.zzbzc.zza(string2, new zzkn.zza<zzc>(){

            public zzc zzqt() {
                zzii.this.zza(2, bl);
                return null;
            }

            public zzc zzg(InputStream inputStream) {
                byte[] byArray = null;
                try {
                    byArray = zzo.zzk((InputStream)inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (byArray == null) {
                    zzii.this.zza(2, bl);
                    return null;
                }
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                if (bitmap == null) {
                    zzii.this.zza(2, bl);
                    return null;
                }
                bitmap.setDensity((int)(160.0 * d));
                return new zzc((Drawable)new BitmapDrawable(Resources.getSystem(), bitmap), Uri.parse((String)string2), d);
            }

            @Override
            public /* synthetic */ Object zzqu() {
                return this.zzqt();
            }

            @Override
            public /* synthetic */ Object zzh(InputStream inputStream) {
                return this.zzg(inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzqs() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzbze;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzan(int n) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzbze = true;
            this.zzbyi = n;
        }
    }

    public void zza(int n, boolean bl) {
        if (bl) {
            this.zzan(n);
        }
    }

    private String[] zzc(JSONObject jSONObject, String string2) throws JSONException {
        JSONArray jSONArray = jSONObject.optJSONArray(string2);
        if (jSONArray == null) {
            return null;
        }
        String[] stringArray = new String[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            stringArray[i] = jSONArray.getString(i);
        }
        return stringArray;
    }

    private static List<Drawable> zzh(List<zzc> list) throws RemoteException {
        ArrayList<Drawable> arrayList = new ArrayList<Drawable>();
        for (zzc zzc2 : list) {
            arrayList.add((Drawable)zze.zzad((zzd)zzc2.zzkt()));
        }
        return arrayList;
    }

    zzih zza(Context context, zzju.zza zza2, zzq zzq2, zzas zzas2) {
        return new zzih(context, zza2, zzq2, zzas2);
    }

    @Override
    public /* synthetic */ Object call() throws Exception {
        return this.zzqr();
    }

    class zzb {
        public zzep zzbzz;

        zzb() {
        }
    }

    public static interface zza<T extends zzh.zza> {
        public T zza(zzii var1, JSONObject var2) throws JSONException, InterruptedException, ExecutionException;
    }
}

