/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.reward.client.RewardedVideoAdRequestParcel;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzfz;
import com.google.android.gms.internal.zzga;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzgj;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zziq;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjm;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkh;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzin
public class zzjf
extends zzb
implements zzji {
    private static final zzgi zzchg = new zzgi();
    private final Map<String, zzjm> zzchh = new HashMap<String, zzjm>();
    private boolean zzchi;

    public zzjf(Context context, zzd zzd2, AdSizeParcel adSizeParcel, zzgj zzgj2, VersionInfoParcel versionInfoParcel) {
        super(context, adSizeParcel, null, zzgj2, versionInfoParcel, zzd2);
    }

    public void zza(RewardedVideoAdRequestParcel rewardedVideoAdRequestParcel) {
        zzab.zzhi((String)"loadAd must be called on the main UI thread.");
        if (TextUtils.isEmpty((CharSequence)rewardedVideoAdRequestParcel.zzaou)) {
            zzkd.zzcx((String)"Invalid ad unit id. Aborting.");
            return;
        }
        this.zzchi = false;
        this.zzajs.zzaou = rewardedVideoAdRequestParcel.zzaou;
        super.zzb(rewardedVideoAdRequestParcel.zzcar);
    }

    @Override
    public void zza(final zzju.zza zza2, zzdk zzdk2) {
        if (zza2.errorCode != -2) {
            zzkh.zzclc.post(new Runnable(){

                @Override
                public void run() {
                    zzjf.this.zzb(new zzju(zza2, null, null, null, null, null, null, null));
                }
            });
            return;
        }
        this.zzajs.zzapc = zza2;
        if (zza2.zzcig == null) {
            this.zzajs.zzapc = this.zze(zza2);
        }
        this.zzajs.zzapw = 0;
        this.zzajs.zzaoz = zzu.zzfp().zza(this.zzajs.zzagf, this.zzajs.zzapc, this);
    }

    @Nullable
    public zzjm zzcf(String string) {
        zzjm zzjm2 = this.zzchh.get(string);
        if (zzjm2 == null) {
            try {
                zzgj zzgj2 = this.zzajz;
                if ("com.google.ads.mediation.admob.AdMobAdapter".equals(string)) {
                    zzgj2 = zzchg;
                }
                zzjm2 = new zzjm(zzgj2.zzbm(string), this);
                this.zzchh.put(string, zzjm2);
            }
            catch (Exception exception) {
                String string2 = String.valueOf(string);
                zzkd.zzd((String)(string2.length() != 0 ? "Fail to instantiate adapter ".concat(string2) : new String("Fail to instantiate adapter ")), (Throwable)exception);
            }
        }
        return zzjm2;
    }

    @Override
    public boolean zza(zzju zzju2, zzju zzju3) {
        return true;
    }

    @Override
    protected boolean zza(AdRequestParcel adRequestParcel, zzju zzju2, boolean bl) {
        return false;
    }

    @Override
    public void pause() {
        zzab.zzhi((String)"pause must be called on the main UI thread.");
        for (String string : this.zzchh.keySet()) {
            try {
                zzjm zzjm2 = this.zzchh.get(string);
                if (zzjm2 == null || zzjm2.zzru() == null) continue;
                zzjm2.zzru().pause();
            }
            catch (RemoteException remoteException) {
                String string2 = String.valueOf(string);
                zzkd.zzcx((String)(string2.length() != 0 ? "Fail to pause adapter: ".concat(string2) : new String("Fail to pause adapter: ")));
            }
        }
    }

    @Override
    public void resume() {
        zzab.zzhi((String)"resume must be called on the main UI thread.");
        for (String string : this.zzchh.keySet()) {
            try {
                zzjm zzjm2 = this.zzchh.get(string);
                if (zzjm2 == null || zzjm2.zzru() == null) continue;
                zzjm2.zzru().resume();
            }
            catch (RemoteException remoteException) {
                String string2 = String.valueOf(string);
                zzkd.zzcx((String)(string2.length() != 0 ? "Fail to resume adapter: ".concat(string2) : new String("Fail to resume adapter: ")));
            }
        }
    }

    @Override
    public void destroy() {
        zzab.zzhi((String)"destroy must be called on the main UI thread.");
        for (String string : this.zzchh.keySet()) {
            try {
                zzjm zzjm2 = this.zzchh.get(string);
                if (zzjm2 == null || zzjm2.zzru() == null) continue;
                zzjm2.zzru().destroy();
            }
            catch (RemoteException remoteException) {
                String string2 = String.valueOf(string);
                zzkd.zzcx((String)(string2.length() != 0 ? "Fail to destroy adapter: ".concat(string2) : new String("Fail to destroy adapter: ")));
            }
        }
    }

    public void zzrq() {
        zzab.zzhi((String)"showAd must be called on the main UI thread.");
        if (!this.isLoaded()) {
            zzkd.zzcx((String)"The reward video has not loaded.");
            return;
        }
        this.zzchi = true;
        zzjm zzjm2 = this.zzcf(this.zzajs.zzapb.zzbop);
        if (zzjm2 != null && zzjm2.zzru() != null) {
            try {
                zzjm2.zzru().showVideo();
            }
            catch (RemoteException remoteException) {
                zzkd.zzd((String)"Could not call showVideo.", (Throwable)remoteException);
            }
        }
    }

    public boolean isLoaded() {
        zzab.zzhi((String)"isLoaded must be called on the main UI thread.");
        return this.zzajs.zzaoy == null && this.zzajs.zzaoz == null && this.zzajs.zzapb != null && !this.zzchi;
    }

    @Override
    public void onRewardedVideoAdOpened() {
        this.zza(this.zzajs.zzapb, false);
        this.zzdt();
    }

    @Override
    public void onRewardedVideoStarted() {
        if (this.zzajs.zzapb != null && this.zzajs.zzapb.zzbon != null) {
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaow.zzcs, this.zzajs.zzapb, this.zzajs.zzaou, false, this.zzajs.zzapb.zzbon.zzbnd);
        }
        this.zzdv();
    }

    @Override
    public void onRewardedVideoAdClosed() {
        this.zzdr();
    }

    @Override
    public void zzc(@Nullable RewardItemParcel rewardItemParcel) {
        if (this.zzajs.zzapb != null && this.zzajs.zzapb.zzbon != null) {
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaow.zzcs, this.zzajs.zzapb, this.zzajs.zzaou, false, this.zzajs.zzapb.zzbon.zzbne);
        }
        if (this.zzajs.zzapb != null && this.zzajs.zzapb.zzcig != null && !TextUtils.isEmpty((CharSequence)this.zzajs.zzapb.zzcig.zzbnt)) {
            rewardItemParcel = new RewardItemParcel(this.zzajs.zzapb.zzcig.zzbnt, this.zzajs.zzapb.zzcig.zzbnu);
        }
        this.zza(rewardItemParcel);
    }

    @Override
    public void zzrr() {
        this.onAdClicked();
    }

    @Override
    public void onRewardedVideoAdLeftApplication() {
        this.zzds();
    }

    public void onContextChanged(@NonNull Context context) {
        for (zzjm zzjm2 : this.zzchh.values()) {
            try {
                zzjm2.zzru().zzj(zze.zzac((Object)context));
            }
            catch (RemoteException remoteException) {
                zzkd.zzb((String)"Unable to call Adapter.onContextChanged.", (Throwable)remoteException);
            }
        }
    }

    private zzju.zza zze(zzju.zza zza2) {
        Object object;
        zzkd.v("Creating mediation ad response for non-mediated rewarded ad.");
        String string = null;
        String string2 = null;
        try {
            string = zziq.zzc(zza2.zzciq).toString();
            object = new JSONObject();
            object.put("pubid", (Object)zza2.zzcip.zzaou);
            string2 = object.toString();
        }
        catch (JSONException jSONException) {
            zzkd.zzb((String)"Unable to generate ad state for non-mediated rewarded video.", (Throwable)jSONException);
            return this.zzf(zza2);
        }
        object = new zzfz(string, null, Arrays.asList("com.google.ads.mediation.admob.AdMobAdapter"), null, null, Collections.emptyList(), Collections.emptyList(), string2, null, Collections.emptyList(), Collections.emptyList(), null, null, null, null, null, Collections.emptyList());
        zzga zzga2 = new zzga(Arrays.asList(object), -1L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, "", -1L, 0, 1, null, 0, -1, -1L, false);
        return new zzju.zza(zza2.zzcip, zza2.zzciq, zzga2, zza2.zzapa, zza2.errorCode, zza2.zzcik, zza2.zzcil, zza2.zzcie);
    }

    private zzju.zza zzf(zzju.zza zza2) {
        return new zzju.zza(zza2.zzcip, zza2.zzciq, null, zza2.zzapa, 0, zza2.zzcik, zza2.zzcil, zza2.zzcie);
    }
}

