/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzas;
import com.google.android.gms.internal.zzcd;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdj;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzfd;
import com.google.android.gms.internal.zzhf;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzku;
import com.google.android.gms.internal.zzlg;
import com.google.android.gms.internal.zzlh;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.internal.zzln;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzin
class zzll
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzlh {
    private final zza zzcpc;
    private final Object zzail = new Object();
    @Nullable
    private final zzas zzbgd;
    private final VersionInfoParcel zzalo;
    private final com.google.android.gms.ads.internal.zzs zzcpd;
    private final zzd zzajv;
    private zzli zzcpe;
    private com.google.android.gms.ads.internal.overlay.zzd zzcpf;
    private AdSizeParcel zzani;
    private boolean zzcpg;
    private boolean zzcph;
    private boolean zzcpi;
    private boolean zzcpj;
    private Boolean zzcjw;
    private int zzcpk;
    private boolean zzcpl = true;
    boolean zzcpm = false;
    private String zzbvq = "";
    private zzlm zzcpn;
    private boolean zzcpo;
    private zzdi zzcpp;
    private zzdi zzcpq;
    private zzdi zzcpr;
    private zzdj zzcps;
    private WeakReference<View.OnClickListener> zzcpt;
    private com.google.android.gms.ads.internal.overlay.zzd zzcpu;
    private zzku zzaqg;
    private int zzbrg = -1;
    private int zzbrf = -1;
    private int zzbri = -1;
    private int zzbrj = -1;
    private Map<String, zzfd> zzcpv;
    private final WindowManager zzaqm;

    static zzll zzb(Context context, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, @Nullable zzas zzas2, VersionInfoParcel versionInfoParcel, zzdk zzdk2, com.google.android.gms.ads.internal.zzs zzs2, zzd zzd2) {
        zza zza2 = new zza(context);
        return new zzll(zza2, adSizeParcel, bl, bl2, zzas2, versionInfoParcel, zzdk2, zzs2, zzd2);
    }

    protected zzll(zza zza2, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, @Nullable zzas zzas2, VersionInfoParcel versionInfoParcel, zzdk zzdk2, com.google.android.gms.ads.internal.zzs zzs2, zzd zzd2) {
        super((Context)zza2);
        this.zzcpc = zza2;
        this.zzani = adSizeParcel;
        this.zzcpi = bl;
        this.zzcpk = -1;
        this.zzbgd = zzas2;
        this.zzalo = versionInfoParcel;
        this.zzcpd = zzs2;
        this.zzajv = zzd2;
        this.zzaqm = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        zzu.zzfq().zza((Context)zza2, versionInfoParcel.zzcs, webSettings);
        zzu.zzfs().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzvj();
        if (zzs.zzavs()) {
            this.addJavascriptInterface(new zzln(this), "googleAdsJsInterface");
        }
        if (zzs.zzavn()) {
            this.removeJavascriptInterface("accessibility");
            this.removeJavascriptInterface("accessibilityTraversal");
        }
        this.zzaqg = new zzku(this.zzcpc.zzue(), (View)this, this, null);
        this.zzd(zzdk2);
    }

    @Override
    public void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzli) {
            this.zzcpe = (zzli)webViewClient;
        }
    }

    @Override
    public WebView getWebView() {
        return this;
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public zzd zzug() {
        return this.zzajv;
    }

    public boolean zzvg() {
        int n;
        int n2;
        if (!this.zzuj().zzho()) {
            return false;
        }
        DisplayMetrics displayMetrics = zzu.zzfq().zza(this.zzaqm);
        int n3 = zzm.zziw().zzb(displayMetrics, displayMetrics.widthPixels);
        int n4 = zzm.zziw().zzb(displayMetrics, displayMetrics.heightPixels);
        Activity activity = this.zzue();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            int[] nArray = zzu.zzfq().zzh(activity);
            n2 = zzm.zziw().zzb(displayMetrics, nArray[0]);
            n = zzm.zziw().zzb(displayMetrics, nArray[1]);
        }
        if (this.zzbrf == n3 && this.zzbrg == n4 && this.zzbri == n2 && this.zzbrj == n) {
            return false;
        }
        boolean bl = this.zzbrf != n3 || this.zzbrg != n4;
        this.zzbrf = n3;
        this.zzbrg = n4;
        this.zzbri = n2;
        this.zzbrj = n;
        new zzhf(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzaqm.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzu.zzfq().zzam(map);
        }
        catch (JSONException jSONException) {
            zzkd.zzcx((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzkd.zzcx((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(string2, valueCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzdb(String string2) {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzkd.zzcx((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUrl(String string2) {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(string2);
                }
                catch (Throwable throwable) {
                    String string3 = String.valueOf(throwable);
                    zzkd.zzcx((String)new StringBuilder(24 + String.valueOf(string3).length()).append("Could not call loadUrl. ").append(string3).toString());
                }
            } else {
                zzkd.zzcx((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzcy(String string2) {
        Object object = this.zzail;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Throwable throwable) {
                String string3 = String.valueOf(throwable);
                zzkd.zzcx((String)new StringBuilder(24 + String.valueOf(string3).length()).append("Could not call loadUrl. ").append(string3).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(String string2, String string3, String string4) {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(string2, string3, string4);
            } else {
                zzkd.zzcx((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            } else {
                zzkd.zzcx((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    protected void zza(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.evaluateJavascript(string2, valueCallback);
            } else {
                zzkd.zzcx((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
            }
        }
    }

    protected void zzdc(String string2) {
        if (zzs.zzavu()) {
            if (this.zzsq() == null) {
                this.zzvh();
            }
            if (this.zzsq().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
            } else {
                String string3 = String.valueOf(string2);
                this.zzdb(string3.length() != 0 ? "javascript:".concat(string3) : new String("javascript:"));
            }
        } else {
            String string4 = String.valueOf(string2);
            this.zzdb(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzvh() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcjw = zzu.zzft().zzsq();
            if (this.zzcjw == null) {
                try {
                    String string2 = "(function(){})()";
                    this.evaluateJavascript(string2, null);
                    this.zzb(true);
                }
                catch (IllegalStateException illegalStateException) {
                    this.zzb(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzb(Boolean bl) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcjw = bl;
        }
        zzu.zzft().zzb(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean zzsq() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcjw;
        }
    }

    @Override
    public void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zzj(string2, string3);
    }

    @Override
    public void zzj(String string2, String string3) {
        String string4 = new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("(").append(string3).append(");").toString();
        this.zzdc(string4);
    }

    @Override
    public void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzkd.v(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: "));
        this.zzdc(stringBuilder.toString());
    }

    @Override
    public void zzuc() {
        this.zzvi();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzalo.zzcs);
        this.zza("onhide", hashMap);
    }

    @Override
    public void zzaf(int n) {
        this.zzvi();
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzalo.zzcs);
        this.zza("onhide", hashMap);
    }

    private void zzvi() {
        zzdg.zza(this.zzcps.zzkf(), this.zzcpq, "aeh2");
    }

    @Override
    public void zzoa() {
        if (this.zzcpp == null) {
            zzdg.zza(this.zzcps.zzkf(), this.zzcpr, "aes");
            this.zzcpp = zzdg.zzb(this.zzcps.zzkf());
            this.zzcps.zza("native:view_show", this.zzcpp);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzalo.zzcs);
        this.zza("onshow", hashMap);
    }

    @Override
    public void zzud() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzu.zzfq().zzfa()));
        hashMap.put("app_volume", String.valueOf(zzu.zzfq().zzey()));
        hashMap.put("device_volume", String.valueOf(zzu.zzfq().zzal(this.getContext())));
        this.zza("volume", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzuh() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcpf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzui() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcpu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdSizeParcel zzdn() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzani;
        }
    }

    @Override
    public zzli zzuj() {
        return this.zzcpe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzuk() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcpg;
        }
    }

    @Override
    public zzas zzul() {
        return this.zzbgd;
    }

    @Override
    public VersionInfoParcel zzum() {
        return this.zzalo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzun() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcpi;
        }
    }

    public void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzu.zzfq().zzb(this.getContext(), intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzkd.zzcv((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzbgd != null) {
            this.zzbgd.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int n, int n2) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzcpi || this.zzani.zzauu || this.zzani.zzauv) {
                super.onMeasure(n, n2);
                return;
            }
            if (this.zzani.zzaus) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzaqm.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n3 = View.MeasureSpec.getMode((int)n);
            int n4 = View.MeasureSpec.getSize((int)n);
            int n5 = View.MeasureSpec.getMode((int)n2);
            int n6 = View.MeasureSpec.getSize((int)n2);
            int n7 = Integer.MAX_VALUE;
            if (n3 == Integer.MIN_VALUE || n3 == 0x40000000) {
                n7 = n4;
            }
            int n8 = Integer.MAX_VALUE;
            if (n5 == Integer.MIN_VALUE || n5 == 0x40000000) {
                n8 = n6;
            }
            if (this.zzani.widthPixels > n7 || this.zzani.heightPixels > n8) {
                float f = this.zzcpc.getResources().getDisplayMetrics().density;
                int n9 = (int)((float)this.zzani.widthPixels / f);
                int n10 = (int)((float)this.zzani.heightPixels / f);
                int n11 = (int)((float)n4 / f);
                int n12 = (int)((float)n6 / f);
                zzkd.zzcx((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n9).append("x").append(n10).append(" dp, but only has ").append(n11).append("x").append(n12).append(" dp.").toString());
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzani.widthPixels, this.zzani.heightPixels);
            }
        }
    }

    public void onGlobalLayout() {
        boolean bl = this.zzvg();
        com.google.android.gms.ads.internal.overlay.zzd zzd2 = this.zzuh();
        if (zzd2 != null && bl) {
            zzd2.zznz();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(Context context, AdSizeParcel adSizeParcel, zzdk zzdk2) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzaqg.zztt();
            this.setContext(context);
            this.zzcpf = null;
            this.zzani = adSizeParcel;
            this.zzcpi = false;
            this.zzcpg = false;
            this.zzbvq = "";
            this.zzcpk = -1;
            zzu.zzfs().zzj(this);
            this.loadUrl("about:blank");
            this.zzcpe.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
            this.zzcpl = true;
            this.zzcpm = false;
            this.zzcpn = null;
            this.zzd(zzdk2);
            this.zzcpo = false;
            zzu.zzgj().zzd(this);
            this.zzvm();
        }
    }

    private void zzd(zzdk zzdk2) {
        this.zzvn();
        this.zzcps = new zzdj(new zzdk(true, "make_wv", this.zzani.zzaur));
        this.zzcps.zzkf().zzc(zzdk2);
        this.zzcpq = zzdg.zzb(this.zzcps.zzkf());
        this.zzcps.zza("native:view_create", this.zzcpq);
        this.zzcpr = null;
        this.zzcpp = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpf = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzc(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpu = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzani = adSizeParcel;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzah(boolean bl) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpi = bl;
            this.zzvj();
        }
    }

    @Override
    public void zzuu() {
        this.zzaqg.zzts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        Object object = this.zzail;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzaqg.onAttachedToWindow();
            }
            this.zzal(this.zzcpo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzaqg.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
        }
        this.zzal(false);
    }

    @Override
    public void setContext(Context context) {
        this.zzcpc.setBaseContext(context);
        this.zzaqg.zzl(this.zzcpc.zzue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzai(boolean bl) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzcpf != null) {
                this.zzcpf.zza(this.zzcpe.zzho(), bl);
            } else {
                this.zzcpg = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcpk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(int n) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpk = n;
            if (this.zzcpf != null) {
                this.zzcpf.setRequestedOrientation(this.zzcpk);
            }
        }
    }

    @Override
    public Activity zzue() {
        return this.zzcpc.zzue();
    }

    @Override
    public Context zzuf() {
        return this.zzcpc.zzuf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzvj() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzcpi || this.zzani.zzaus) {
                if (Build.VERSION.SDK_INT < 14) {
                    zzkd.zzcv((String)"Disabling hardware acceleration on an overlay.");
                    this.zzvk();
                } else {
                    zzkd.zzcv((String)"Enabling hardware acceleration on an overlay.");
                    this.zzvl();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                zzkd.zzcv((String)"Disabling hardware acceleration on an AdView.");
                this.zzvk();
            } else {
                zzkd.zzcv((String)"Enabling hardware acceleration on an AdView.");
                this.zzvl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzvk() {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.zzcpj) {
                zzu.zzfs().zzp((View)this);
            }
            this.zzcpj = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzvl() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzcpj) {
                zzu.zzfs().zzo((View)this);
            }
            this.zzcpj = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzvn();
            this.zzaqg.zztt();
            if (this.zzcpf != null) {
                this.zzcpf.close();
                this.zzcpf.onDestroy();
                this.zzcpf = null;
            }
            this.zzcpe.reset();
            if (this.zzcph) {
                return;
            }
            zzu.zzgj().zzd(this);
            this.zzvm();
            this.zzcph = true;
            zzkd.v("Initiating WebView self destruct sequence in 3...");
            this.zzcpe.zzuz();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.zzcph) {
                this.zzcpe.reset();
                zzu.zzgj().zzd(this);
                this.zzvm();
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzuo() {
        Object object = this.zzail;
        synchronized (object) {
            zzkd.v("Destroying WebView!");
            zzkh.zzclc.post(new Runnable(){

                @Override
                public void run() {
                    zzll.super.destroy();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcph;
        }
    }

    @TargetApi(value=21)
    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzuj() != null && this.zzuj().zzvf() != null) {
            this.zzuj().zzvf().zzem();
        }
    }

    @Override
    public void zzuv() {
        if (this.zzcpr == null) {
            this.zzcpr = zzdg.zzb(this.zzcps.zzkf());
            this.zzcps.zza("native:view_load", this.zzcpr);
        }
    }

    @Override
    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzs.zzavn()) {
                super.onPause();
            }
        }
        catch (Exception exception) {
            zzkd.zzb((String)"Could not pause webview.", (Throwable)exception);
        }
    }

    @Override
    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzs.zzavn()) {
                super.onResume();
            }
        }
        catch (Exception exception) {
            zzkd.zzb((String)"Could not resume webview.", (Throwable)exception);
        }
    }

    @Override
    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
        }
        catch (Exception exception) {
            zzkd.zzb((String)"Could not stop loading webview.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaj(boolean bl) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpl = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzou() {
        Object object = this.zzail;
        synchronized (object) {
            zzdg.zza(this.zzcps.zzkf(), this.zzcpq, "aebb2");
            return this.zzcpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzup() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcpm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzef() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpm = true;
            if (this.zzcpd != null) {
                this.zzcpd.zzef();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzeg() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpm = false;
            if (this.zzcpd != null) {
                this.zzcpd.zzeg();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzvm() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpv = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzcz(String string2) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzbvq = string2 == null ? "" : string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRequestId() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzbvq;
        }
    }

    @Override
    public zzlg zzuq() {
        return null;
    }

    @Override
    public zzdi zzur() {
        return this.zzcpr;
    }

    @Override
    public zzdj zzus() {
        return this.zzcps;
    }

    @Override
    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzcpt = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public View.OnClickListener zzuw() {
        return (View.OnClickListener)this.zzcpt.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzlm zzut() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcpn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzlm zzlm2) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzcpn != null) {
                zzkd.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
                return;
            }
            this.zzcpn = zzlm2;
        }
    }

    private void zzvn() {
        if (this.zzcps == null) {
            return;
        }
        zzdk zzdk2 = this.zzcps.zzkf();
        if (zzdk2 != null && zzu.zzft().zzsl() != null) {
            zzu.zzft().zzsl().zza(zzdk2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzcd zzcd2, boolean bl) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpo = bl;
        }
        this.zzal(bl);
    }

    private void zzal(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public void zza(String string2, zzep zzep2) {
        if (this.zzcpe != null) {
            this.zzcpe.zza(string2, zzep2);
        }
    }

    @Override
    public void zzb(String string2, zzep zzep2) {
        if (this.zzcpe != null) {
            this.zzcpe.zzb(string2, zzep2);
        }
    }

    @zzin
    public static class zza
    extends MutableContextWrapper {
        private Activity zzcmv;
        private Context zzaql;
        private Context zzcpx;

        public zza(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context context) {
            this.zzaql = context.getApplicationContext();
            this.zzcmv = context instanceof Activity ? (Activity)context : null;
            this.zzcpx = context;
            super.setBaseContext(this.zzaql);
        }

        public void startActivity(Intent intent) {
            if (this.zzcmv != null) {
                this.zzcmv.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.zzaql.startActivity(intent);
            }
        }

        public Activity zzue() {
            return this.zzcmv;
        }

        public Object getSystemService(String string2) {
            return this.zzcpx.getSystemService(string2);
        }

        public Context zzuf() {
            return this.zzcpx;
        }
    }
}

