/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.google.android.gms.internal.zzae;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzay;
import com.google.android.gms.internal.zzaz;
import com.google.android.gms.internal.zzbb;
import com.google.android.gms.internal.zzbc;
import com.google.android.gms.internal.zzbd;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzbf;
import com.google.android.gms.internal.zzbg;
import com.google.android.gms.internal.zzbh;
import com.google.android.gms.internal.zzbi;
import com.google.android.gms.internal.zzbj;
import com.google.android.gms.internal.zzbl;
import com.google.android.gms.internal.zzbm;
import com.google.android.gms.internal.zzbn;
import com.google.android.gms.internal.zzbo;
import com.google.android.gms.internal.zzbp;
import com.google.android.gms.internal.zzbq;
import com.google.android.gms.internal.zzbr;
import com.google.android.gms.internal.zzbs;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzdi;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class zzas
extends zzaq {
    private static final String TAG = zzas.class.getSimpleName();
    protected boolean zzagr = false;
    protected String zzags;
    private static long startTime = 0L;
    static boolean zzagt = false;
    protected boolean zzagu = false;
    protected boolean zzagv = false;
    protected static volatile zzbb zzafz = null;
    protected static final Object zzagw = new Object();

    protected static synchronized void zza(Context context, boolean bl) {
        if (!zzagt) {
            startTime = Calendar.getInstance().getTime().getTime() / 1000L;
            zzafz = zzas.zzb(context, bl);
            zzagt = true;
        }
    }

    protected zzas(Context context, String string2, boolean bl) {
        super(context);
        this.zzags = string2;
        this.zzagr = bl;
    }

    protected zzas(Context context, String string2) {
        super(context);
        this.zzags = string2;
        this.zzagr = false;
    }

    @Override
    protected zzae.zza zzc(Context context) {
        zzae.zza zza2 = new zzae.zza();
        if (!TextUtils.isEmpty((CharSequence)this.zzags)) {
            zza2.zzcs = this.zzags;
        }
        zzbb zzbb2 = zzas.zzb(context, this.zzagr);
        zzbb2.zzcw();
        this.zza(zzbb2, zza2);
        zzbb2.zzcx();
        return zza2;
    }

    @Override
    protected zzae.zza zza(Context context, View view) {
        zzae.zza zza2 = new zzae.zza();
        if (!TextUtils.isEmpty((CharSequence)this.zzags)) {
            zza2.zzcs = this.zzags;
        }
        zzbb zzbb2 = zzas.zzb(context, this.zzagr);
        zzbb2.zzcw();
        this.zza(zzbb2, zza2, view);
        zzbb2.zzcx();
        return zza2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static zzbb zzb(Context context, boolean bl) {
        if (zzafz == null) {
            Object object = zzagw;
            synchronized (object) {
                if (zzafz == null) {
                    zzbb zzbb2 = zzbb.zza(context, zzax.getKey(), zzax.zzay(), bl);
                    zzas.zza(zzbb2);
                    zzafz = zzbb2;
                }
            }
        }
        return zzafz;
    }

    private static void zza(zzbb zzbb2) {
        List<Class> list = Collections.singletonList(Context.class);
        zzbb2.zza(zzax.zzbj(), zzax.zzbk(), list);
        zzbb2.zza(zzax.zzbt(), zzax.zzbu(), list);
        zzbb2.zza(zzax.zzbr(), zzax.zzbs(), list);
        zzbb2.zza(zzax.zzbd(), zzax.zzbe(), list);
        zzbb2.zza(zzax.zzbn(), zzax.zzbo(), list);
        zzbb2.zza(zzax.zzaz(), zzax.zzba(), list);
        zzbb2.zza(zzax.zzcf(), zzax.zzcg(), list);
        List<Class> list2 = Arrays.asList(MotionEvent.class, DisplayMetrics.class);
        zzbb2.zza(zzax.zzcd(), zzax.zzce(), list2);
        zzbb2.zza(zzax.zzcb(), zzax.zzcc(), list2);
        zzbb2.zza(zzax.zzbh(), zzax.zzbi(), Collections.emptyList());
        zzbb2.zza(zzax.zzbz(), zzax.zzca(), Collections.emptyList());
        zzbb2.zza(zzax.zzbp(), zzax.zzbq(), Collections.emptyList());
        zzbb2.zza(zzax.zzbf(), zzax.zzbg(), Collections.emptyList());
        zzbb2.zza(zzax.zzbl(), zzax.zzbm(), Collections.emptyList());
        zzbb2.zza(zzax.zzbx(), zzax.zzby(), Collections.emptyList());
        List<Class> list3 = Arrays.asList(Context.class, Boolean.TYPE);
        zzbb2.zza(zzax.zzbb(), zzax.zzbc(), list3);
        List<Class> list4 = Arrays.asList(StackTraceElement[].class);
        zzbb2.zza(zzax.zzbv(), zzax.zzbw(), list4);
    }

    protected List<Callable<Void>> zzb(zzbb zzbb2, zzae.zza zza2) {
        int n = zzbb2.zzau();
        ArrayList<Callable<Void>> arrayList = new ArrayList<Callable<Void>>();
        arrayList.add(new zzbg(zzbb2, zzax.zzbb(), zzax.zzbc(), zza2, n, 27, zzdi.zzber.get() != false || zzdi.zzbes.get() != false));
        arrayList.add(new zzbj(zzbb2, zzax.zzbh(), zzax.zzbi(), zza2, startTime, n, 25));
        arrayList.add(new zzbo(zzbb2, zzax.zzbp(), zzax.zzbq(), zza2, n, 1));
        arrayList.add(new zzbp(zzbb2, zzax.zzbr(), zzax.zzbs(), zza2, n, 31));
        arrayList.add(new zzbs(zzbb2, zzax.zzbz(), zzax.zzca(), zza2, n, 33));
        arrayList.add(new zzbf(zzbb2, zzax.zzbt(), zzax.zzbu(), zza2, n, 29));
        arrayList.add(new zzbh(zzbb2, zzax.zzbd(), zzax.zzbe(), zza2, n, 5));
        arrayList.add(new zzbn(zzbb2, zzax.zzbn(), zzax.zzbo(), zza2, n, 12));
        arrayList.add(new zzbe(zzbb2, zzax.zzaz(), zzax.zzba(), zza2, n, 3));
        arrayList.add(new zzbi(zzbb2, zzax.zzbf(), zzax.zzbg(), zza2, n, 44));
        arrayList.add(new zzbm(zzbb2, zzax.zzbl(), zzax.zzbm(), zza2, n, 22));
        if (zzdi.zzbeu.get().booleanValue() || zzdi.zzbes.get().booleanValue()) {
            arrayList.add(new zzbt(zzbb2, zzax.zzcf(), zzax.zzcg(), zza2, n, 48));
        }
        if (zzdi.zzbez.get().booleanValue() || zzdi.zzbes.get().booleanValue()) {
            arrayList.add(new zzbr(zzbb2, zzax.zzbx(), zzax.zzby(), zza2, n, 51));
        }
        return arrayList;
    }

    protected List<Callable<Void>> zzc(zzbb zzbb2, zzae.zza zza2) {
        ArrayList<Callable<Void>> arrayList = new ArrayList<Callable<Void>>();
        ExecutorService executorService = zzbb2.zzch();
        if (executorService == null) {
            return arrayList;
        }
        int n = zzbb2.zzau();
        arrayList.add(new zzbl(zzbb2, zza2));
        arrayList.add(new zzbo(zzbb2, zzax.zzbp(), zzax.zzbq(), zza2, n, 1));
        arrayList.add(new zzbj(zzbb2, zzax.zzbh(), zzax.zzbi(), zza2, startTime, n, 25));
        arrayList.add(new zzbi(zzbb2, zzax.zzbf(), zzax.zzbg(), zza2, n, 44));
        arrayList.add(new zzbe(zzbb2, zzax.zzaz(), zzax.zzba(), zza2, n, 3));
        arrayList.add(new zzbm(zzbb2, zzax.zzbl(), zzax.zzbm(), zza2, n, 22));
        if (zzdi.zzbfd.get().booleanValue() || zzdi.zzbes.get().booleanValue()) {
            arrayList.add(new zzbh(zzbb2, zzax.zzbd(), zzax.zzbe(), zza2, n, 5));
        }
        if (zzdi.zzbew.get().booleanValue() || zzdi.zzbes.get().booleanValue()) {
            arrayList.add(new zzbt(zzbb2, zzax.zzcf(), zzax.zzcg(), zza2, n, 48));
        }
        if (zzdi.zzbfb.get().booleanValue() || zzdi.zzbes.get().booleanValue()) {
            arrayList.add(new zzbr(zzbb2, zzax.zzbx(), zzax.zzby(), zza2, n, 51));
        }
        if (zzdi.zzbfg.get().booleanValue() || zzdi.zzbes.get().booleanValue()) {
            arrayList.add(new zzbq(zzbb2, zzax.zzbv(), zzax.zzbw(), zza2, n, 45, new Throwable().getStackTrace()));
        }
        return arrayList;
    }

    protected void zza(zzbb zzbb2, zzae.zza zza2) {
        ExecutorService executorService = zzbb2.zzch();
        if (executorService == null) {
            return;
        }
        List<Callable<Void>> list = this.zzb(zzbb2, zza2);
        this.zza(list);
    }

    protected void zza(zzbb zzbb2, zzae.zza zza2, View view) {
        this.zzd(zzbb2, zza2);
        List<Callable<Void>> list = this.zzc(zzbb2, zza2);
        this.zza(list);
    }

    private void zzd(zzbb zzbb2, zzae.zza zza2) {
        try {
            zzbc zzbc2 = zzas.zza(zzbb2, this.zzage, this.zzagp);
            zza2.zzdf = zzbc2.zzaig;
            zza2.zzdg = zzbc2.zzaih;
            zza2.zzdh = zzbc2.zzaii;
            if (this.zzago) {
                zza2.zzdv = zzbc2.zzfb;
                zza2.zzdw = zzbc2.zzez;
            }
            if (zzdi.zzbex.get().booleanValue() || zzdi.zzbes.get().booleanValue()) {
                zzae.zza.zza zza3 = new zzae.zza.zza();
                zzbc2 = this.zzb(this.zzage);
                zza3.zzdf = zzbc2.zzaig;
                zza3.zzdg = zzbc2.zzaih;
                zza3.zzfe = zzbc2.zzaii;
                if (this.zzago) {
                    zza3.zzez = zzbc2.zzez;
                    zza3.zzfb = zzbc2.zzfb;
                    zza3.zzfd = zzbc2.zzaij != 0L ? 1 : 0;
                    if (this.zzagh > 0L) {
                        zza3.zzfa = this.zzagp != null ? Long.valueOf(Math.round((double)this.zzagm / (double)this.zzagh)) : null;
                        zza3.zzfc = Math.round((double)this.zzagl / (double)this.zzagh);
                    }
                    zza3.zzfg = zzbc2.zzfg;
                    zza3.zzff = zzbc2.zzff;
                    zza3.zzfh = zzbc2.zzaim != 0L ? 1 : 0;
                    if (this.zzagk > 0L) {
                        zza3.zzfi = this.zzagk;
                    }
                }
                zza2.zzeo = zza3;
            }
        }
        catch (zzay zzay2) {
            // empty catch block
        }
        if (this.zzagg > 0L) {
            zza2.zzea = this.zzagg;
        }
        if (this.zzagh > 0L) {
            zza2.zzdz = this.zzagh;
        }
        if (this.zzagi > 0L) {
            zza2.zzdy = this.zzagi;
        }
        if (this.zzagj > 0L) {
            zza2.zzeb = this.zzagj;
        }
        try {
            int n = this.zzagf.size() - 1;
            if (n > 0) {
                zza2.zzep = new zzae.zza.zza[n];
                for (int i = 0; i < n; ++i) {
                    zzbc zzbc3 = zzas.zza(zzbb2, (MotionEvent)this.zzagf.get(i), this.zzagp);
                    zzae.zza.zza zza4 = new zzae.zza.zza();
                    zza4.zzdf = zzbc3.zzaig;
                    zza4.zzdg = zzbc3.zzaih;
                    zza2.zzep[i] = zza4;
                }
            }
        }
        catch (zzay zzay3) {
            zza2.zzep = null;
        }
    }

    protected void zza(List<Callable<Void>> list) {
        if (zzafz == null) {
            return;
        }
        ExecutorService executorService = zzafz.zzch();
        if (executorService == null) {
            return;
        }
        if (!list.isEmpty()) {
            try {
                executorService.invokeAll(list, zzdi.zzben.get(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                Log.d((String)TAG, (String)String.format("class methods got exception: %s", zzbd.zza(interruptedException)));
            }
        }
    }

    static zzbc zza(zzbb zzbb2, MotionEvent motionEvent, DisplayMetrics displayMetrics) throws zzay {
        Method method = zzbb2.zzc(zzax.zzcd(), zzax.zzce());
        if (method == null || motionEvent == null) {
            throw new zzay();
        }
        try {
            zzbc zzbc2 = new zzbc((String)method.invoke(null, motionEvent, displayMetrics));
            return zzbc2;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new zzay(reflectiveOperationException);
        }
    }

    @Override
    protected zzbc zzb(MotionEvent motionEvent) throws zzay {
        Method method = zzafz.zzc(zzax.zzcb(), zzax.zzcc());
        if (method == null || motionEvent == null) {
            throw new zzay();
        }
        try {
            zzbc zzbc2 = new zzbc((String)method.invoke(null, motionEvent, this.zzagp));
            return zzbc2;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new zzay(reflectiveOperationException);
        }
    }

    @Override
    protected long zza(StackTraceElement[] stackTraceElementArray) throws zzay {
        Method method = zzafz.zzc(zzax.zzbv(), zzax.zzbw());
        if (method == null || stackTraceElementArray == null) {
            throw new zzay();
        }
        try {
            zzaz zzaz2 = new zzaz((String)method.invoke(null, new Object[]{stackTraceElementArray}));
            return zzaz2.zzahi;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new zzay(reflectiveOperationException);
        }
    }
}

